/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commands;

import com.ibm.etools.ejb.codegen.helpers.EntityHelper;
import com.ibm.etools.j2ee.commands.CommandExecutionFailure;
import com.ibm.etools.j2ee.commands.CreatePrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.EnterpriseBeanCodegenCommand;
import com.ibm.etools.j2ee.commands.EnterpriseBeanCommand;
import com.ibm.etools.j2ee.commands.EntityCodegenCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.commands.UpdateContainerManagedEntityCommand;
import com.ibm.etools.j2ee.commands.UpdateEntityCommand;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;

public abstract class EntityCommand
extends EnterpriseBeanCommand {
    protected static final String KEY_CLASS_SUFFIX = "Key";
    private boolean isReentrant = false;
    private boolean isReentrantSet = false;
    private boolean createAdditionalCommand = true;

    public EntityCommand(EnterpriseBean anEjb, EJBArtifactEdit artifactEdit) {
        super(anEjb, artifactEdit);
    }

    public EntityCommand(String aName, EJBArtifactEdit artifactEdit) {
        super(aName, artifactEdit);
    }

    @Override
    protected EnterpriseBeanCodegenCommand createCodegenCommand() {
        return new EntityCodegenCommand(this.getEntity());
    }

    @Override
    protected EnterpriseBean createEJB() {
        Entity bean = this.getEJBFactory().createEntity();
        bean.setName(this.getName());
        this.getArtifactEdit().getEJBJarXmiResource().setID((EObject)bean, this.getName());
        return bean;
    }

    @Override
    protected void ensureEJBProxiesAreResolved() {
        super.ensureEJBProxiesAreResolved();
        Entity anEntity = this.getEntity();
        if (anEntity != null) {
            anEntity.getPrimaryKey();
        }
    }

    @Override
    protected void executeForMetadataGeneration() throws CommandExecutionFailure {
        super.executeForMetadataGeneration();
        if (this.isReentrantSet || this.isCreateCommand()) {
            this.getEntity().setReentrant(this.isReentrant());
        }
    }

    public Entity getEntity() {
        return (Entity)this.getEjb();
    }

    protected String getPrimaryKeyQualifiedName() {
        if (this.getEntity().getPrimaryKeyName() != null) {
            return this.getEntity().getPrimaryKeyName();
        }
        String beanName = this.getEntity().getEjbClassName();
        String baseName = beanName.substring(0, beanName.length() - 4);
        return String.valueOf(baseName) + KEY_CLASS_SUFFIX;
    }

    protected List getSubtypes() {
        EjbModuleExtensionHelper helper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        if (helper == null) {
            return Collections.EMPTY_LIST;
        }
        return helper.getSubtypes(this.getEjb());
    }

    @Override
    protected void initializeAdditionalCommand() {
        if (!this.shouldCreateAdditionalCommand()) {
            return;
        }
        if (!this.shouldPropagate) {
            return;
        }
        this.doInitializeAdditionalCommand();
    }

    public boolean shouldCreateAdditionalCommand() {
        return this.createAdditionalCommand;
    }

    protected void doInitializeAdditionalCommand() {
        this.initializeAdditionalCommandForInheritance();
    }

    protected void initializeAdditionalCommandForInheritance() {
        if (this.needToRegenerateSubtypes()) {
            List subtypes = this.getSubtypes();
            if (subtypes.isEmpty()) {
                return;
            }
            JavaClass pkClass = null;
            if (this.isKeyClassChanging()) {
                pkClass = this.getEntity().getPrimaryKey();
            }
            IRootCommand command = null;
            int i = 0;
            while (i < subtypes.size()) {
                Entity entity = (Entity)subtypes.get(i);
                if (this.hasInitializedAdditionalCommand()) {
                    command = this.getAdditionalCommand().getRootCommand(entity);
                }
                if (command == null) {
                    command = entity.isContainerManagedEntity() ? new UpdateContainerManagedEntityCommand((EnterpriseBean)entity, this.getArtifactEdit()) : new UpdateEntityCommand((EnterpriseBean)entity, this.getArtifactEdit());
                    command.getCodegenCommand();
                    command.setGenerateJava(true);
                    this.getAdditionalCommand().append(command);
                }
                if (pkClass != null) {
                    new CreatePrimaryKeyClassCommand(command, pkClass, false);
                }
                ++i;
            }
        }
    }

    protected boolean isKeyChanging() {
        EntityHelper helper = (EntityHelper)this.getCodegenCommand().getHelper();
        return helper.isKeyChanging() || this.isKeyClassChanging();
    }

    protected boolean isKeyClassChanging() {
        Entity oldEjb = (Entity)this.getOldEjb();
        if (oldEjb != null && oldEjb.getPrimaryKeyName() != null) {
            return !oldEjb.getPrimaryKeyName().equals(this.getEntity().getPrimaryKeyName());
        }
        return false;
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    protected boolean needToRegenerateSubtypes() {
        return this.isKeyChanging();
    }

    public void setReentrant(boolean newReentrant) {
        this.isReentrant = newReentrant;
        this.isReentrantSet = true;
    }

    @Override
    protected void undoMetadataGeneration() {
        super.undoMetadataGeneration();
        Entity oldEntity = (Entity)this.getOldEjb();
        if (oldEntity != null) {
            this.getEntity().setReentrant(oldEntity.isReentrant());
        }
    }

    public void setCreateAdditionalCommand(boolean createAdditionalCommand) {
        this.createAdditionalCommand = createAdditionalCommand;
    }
}

