/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.commands;

import com.ibm.etools.ejb.codegen.helpers.EJBCodeGenResourceHandler;
import com.ibm.etools.j2ee.commands.FeatureValueConversionException;
import com.ibm.etools.j2ee.commands.FeatureValueConverter;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;

public class DefaultFeatureValueConverter
implements FeatureValueConverter {
    private static final String FAILED_CONVERSION_PATTERN = EJBCodeGenResourceHandler.Failed_to_convert_0_to__ERROR_;

    protected Object convertToBoolean(Object aValue) {
        if (aValue instanceof String) {
            return Boolean.valueOf((String)aValue);
        }
        if (aValue instanceof Boolean) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Boolean_UI_);
    }

    protected Object convertToByte(Object aValue) {
        if (aValue instanceof String) {
            return Byte.valueOf((String)aValue);
        }
        if (aValue instanceof Byte) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Byte_UI_);
    }

    protected Object convertToCharacter(Object aValue) {
        if (aValue instanceof String && ((String)aValue).length() == 1) {
            return new Character(((String)aValue).charAt(0));
        }
        if (aValue instanceof Character) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Character_UI_);
    }

    protected Object convertToDouble(Object aValue) {
        if (aValue instanceof String) {
            try {
                return Double.valueOf((String)aValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultDouble();
            }
        }
        if (aValue instanceof Double) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Double_UI_);
    }

    protected Object convertToEnum(Object aValue, EStructuralFeature aFeature) {
        EEnumLiteral literal;
        EEnum enumVar = (EEnum)aFeature.getEType();
        if (aValue instanceof String) {
            literal = enumVar.getEEnumLiteral((String)aValue);
        } else if (aValue instanceof Integer) {
            literal = enumVar.getEEnumLiteral(((Integer)aValue).intValue());
        } else if (aValue instanceof EEnumLiteral) {
            literal = (EEnumLiteral)aValue;
        } else {
            return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Enumeration_UI_);
        }
        if (literal != null) {
            return literal.getInstance();
        }
        return null;
    }

    protected Object convertToFloat(Object aValue) {
        if (aValue instanceof String) {
            try {
                return Float.valueOf((String)aValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultFloat();
            }
        }
        if (aValue instanceof Float) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Float_UI_);
    }

    protected Object convertToInteger(Object aValue) {
        if (aValue instanceof String) {
            try {
                return Integer.valueOf((String)aValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultInteger();
            }
        }
        if (aValue instanceof Integer) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Integer_UI_);
    }

    protected Object convertToJavaObject(Object aValue) {
        return aValue;
    }

    protected Object convertToLong(Object aValue) {
        if (aValue instanceof String) {
            try {
                return Long.valueOf((String)aValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultLong();
            }
        }
        if (aValue instanceof Long) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Long_UI_);
    }

    protected Object convertToMofObject(Object aValue) {
        if (aValue instanceof EObject) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.MofObject_UI_);
    }

    protected Object convertToShort(Object aValue) {
        if (aValue instanceof String) {
            try {
                return Short.valueOf((String)aValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.defaultShort();
            }
        }
        if (aValue instanceof Short) {
            return aValue;
        }
        return this.failedToConvert(aValue, EJBCodeGenResourceHandler.Short_UI_);
    }

    protected Object convertToString(Object aValue) {
        return aValue.toString();
    }

    protected Object convertValue(Object aValue, EAttribute anAttribute) {
        Revisit.revisit();
        EClassifier meta = anAttribute.getEType();
        if (meta == null) {
            return aValue;
        }
        if (meta instanceof EEnum) {
            return this.convertToEnum(aValue, (EStructuralFeature)anAttribute);
        }
        switch (meta.getClassifierID()) {
            case 50: {
                return this.convertToString(aValue);
            }
            case 22: 
            case 23: {
                return this.convertToBoolean(aValue);
            }
            case 39: 
            case 40: {
                return this.convertToInteger(aValue);
            }
            case 37: 
            case 38: {
                return this.convertToFloat(aValue);
            }
            case 27: 
            case 28: {
                return this.convertToCharacter(aValue);
            }
            case 43: 
            case 44: {
                return this.convertToLong(aValue);
            }
            case 24: 
            case 26: {
                return this.convertToByte(aValue);
            }
            case 31: 
            case 32: {
                return this.convertToDouble(aValue);
            }
            case 48: 
            case 49: {
                return this.convertToShort(aValue);
            }
            case 10: {
                return this.convertToMofObject(aValue);
            }
            case 42: {
                return this.convertToJavaObject(aValue);
            }
        }
        return aValue;
    }

    @Override
    public Object convertValue(Object aValue, EStructuralFeature aFeature) {
        if (aValue == null || aFeature == null || !(aFeature instanceof EAttribute)) {
            return aValue;
        }
        return this.convertValue(aValue, (EAttribute)aFeature);
    }

    protected Double defaultDouble() {
        return null;
    }

    protected Float defaultFloat() {
        return null;
    }

    protected Integer defaultInteger() {
        return null;
    }

    protected Long defaultLong() {
        return null;
    }

    protected Short defaultShort() {
        return null;
    }

    protected Object failedToConvert(Object aValue, String aString) {
        String errorString = MessageFormat.format(FAILED_CONVERSION_PATTERN, aValue.toString(), aString);
        throw new FeatureValueConversionException(errorString);
    }
}

