/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.codegen.helpers;

import com.ibm.etools.ejb.codegen.helpers.EJBCodeGenResourceHandler;
import com.ibm.etools.ejb.codegen.helpers.IEJBCodegenHandler;
import com.ibm.etools.j2ee.ejb.EjbPlugin;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.enablement.Identifiable;
import org.eclipse.wst.common.frameworks.internal.enablement.IdentifiableComparator;
import org.eclipse.wst.common.internal.emf.utilities.Assert;

public class EJBCodegenHandlerExtensionReader
extends RegistryReader {
    static EJBCodegenHandlerExtensionReader instance = null;
    protected SortedSet handlerExtensions = null;

    public EJBCodegenHandlerExtensionReader() {
        super("com.ibm.etools.j2ee.ejb", "EJBCodegenHandler");
    }

    protected void addExtension(IConfigurationElement newExtension) {
        this.getHandlerExtensions().add(new Descriptor(newExtension));
    }

    public boolean readElement(IConfigurationElement element) {
        if ("codegenExtensionHandler".equals(element.getName())) {
            this.addExtension(element);
            return true;
        }
        return false;
    }

    public IEJBCodegenHandler getEJBExtHandler(IProject project) {
        for (Descriptor descriptor : this.getHandlerExtensions()) {
            if (!EnablementManager.INSTANCE.getIdentifier(descriptor.getID(), project).isEnabled()) continue;
            return descriptor.getInstance();
        }
        return null;
    }

    public static EJBCodegenHandlerExtensionReader getInstance() {
        if (instance == null) {
            instance = new EJBCodegenHandlerExtensionReader();
            instance.readRegistry();
        }
        return instance;
    }

    protected SortedSet getHandlerExtensions() {
        if (this.handlerExtensions == null) {
            this.handlerExtensions = new TreeSet(IdentifiableComparator.getInstance());
        }
        return this.handlerExtensions;
    }

    public static class Descriptor
    implements Identifiable {
        public static final String CODEGEN_EXTENSION = "codegenExtensionHandler";
        public static final String RUN = "run";
        public static final String ATT_ID = "id";
        public static final String ATT_CLASS = "class";
        private static int loadOrderCounter = 0;
        private IConfigurationElement element;
        private String id;
        private int loadOrder;
        private IEJBCodegenHandler instance;
        private boolean errorCondition = false;

        public Descriptor(IConfigurationElement element) {
            Assert.isLegal((boolean)CODEGEN_EXTENSION.equals(element.getName()), (String)NLS.bind((String)EJBCodeGenResourceHandler.EJBCodegenHandlerExtensionReader_ERROR_0, (Object[])new Object[]{CODEGEN_EXTENSION}));
            this.element = element;
            this.init();
        }

        private void init() {
            this.id = this.element.getAttribute(ATT_ID);
            this.loadOrder = loadOrderCounter++;
        }

        public String getID() {
            return this.id;
        }

        public int getLoadOrder() {
            return this.loadOrder;
        }

        public IEJBCodegenHandler getInstance() {
            try {
                if (this.instance == null && !this.errorCondition) {
                    this.instance = (IEJBCodegenHandler)this.element.createExecutableExtension(RUN);
                }
            }
            catch (Throwable e) {
                EjbPlugin.logError(e);
                this.errorCondition = true;
            }
            return this.instance;
        }

        public String toString() {
            return new StringBuffer("CodegenDescriptor[id=\"").append(this.id).append("\", loadOrder=").append(this.loadOrder).append("]").toString();
        }
    }
}

