#!/bin/sh

baseDir=`dirname "$0"`
pwd=`pwd`
if [ $baseDir = "." ]
then
  baseDir=$pwd
fi
if ! [ -d "$JAVA_HOME" ]; then
  JAVA_HOME=$baseDir/../eclipse
fi
if ! [ -d "$JAVA_HOME/jre/bin" ]; then
  JAVA_HOME=$baseDir/../jdk
fi
if ! [ -d "$JAVA_HOME/jre/bin" ]; then
  echo ERROR: JAVA_HOME must point to a Java installation containing jre/bin
  exit 1
fi

STARTUP_JAR=$baseDir/../startup.jar
if ! [ -f "$STARTUP_JAR" ]; then
  STARTUP_JAR=$baseDir/../eclipse/startup.jar
fi
if ! [ -f "$STARTUP_JAR" ]; then
  echo ERROR: Unable to locate Eclipse startup.jar
  exit 1
fi

if ! [ -d "$workspace" ]; then
  ########### Set the location of your workspace here ##############
  workspace=$HOME/default_workspace
  echo trying default workspace $workspace
fi

if [ -d "$workspace" ]; then
  echo using workspace $workspace
else
  echo ERROR incorrect workspace $workspace ...
  echo ERROR ... edit this runAnt.sh and correct the workspace var
  echo ERROR ... or, create this workspace directory.
  exit 1
fi

PLATFORM=`/bin/uname`
case $PLATFORM in
  AIX)
    OSOPTIONS="-os aix -ws gtk"
    export OSOPTIONS;;
  Linux)
    OSOPTIONS="-os linux -ws gtk"
    export OSOPTIONS;;
  SunOS)
    OSOPTIONS="-os sparc -ws gtk"
    export OSOPTIONS;;
  HP-UX)
    OSOPTIONS="-ws gtk"
    export OSOPTIONS;;
esac


echo "invoking java launch of Eclipse ..."
$JAVA_HOME/jre/bin/java -Xms256m -Xmx512m -Xj9 -Dwtp.autotest.noninteractive=true -Dwas.runtime=$baseDir/../../runtimes -cp $STARTUP_JAR org.eclipse.core.launcher.Main -application com.ibm.etools.j2ee.ant.RunAnt -data "$workspace" $OSOPTIONS $*
errorcode=$?
echo "java returned ErrorCode $errorcode"


if [ $errorcode -eq 13 ]; then
  echo ERROR runAnt BUILD FAILED.
  exit 1
elif [ $errorcode -eq 15 ]; then
  echo ERROR WORKSPACE is already BEING USED.
  exit 1
elif [ $errorcode -eq 23 ]; then
  echo WARNING echo totally clean UNINITIALIZED workspace, it is now setup.  will rerun...
  $JAVA_HOME/jre/bin/java -Xms256m -Xmx512m -Xj9 -Dwtp.autotest.noninteractive=true -Dwas.runtime=$baseDir/../../runtimes -cp $STARTUP_JAR org.eclipse.core.launcher.Main -application com.ibm.etools.j2ee.ant.RunAnt -data "$workspace" $OSOPTIONS $*
elif [ $errorcode -ne 0 ]; then
  echo ERROR runAnt FAILED.  ErrorCode=$errorcode
  exit 1
fi

echo runAnt.sh DONE.
exit 0

