/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.views.factories;

import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.AbstractShapeViewFactory;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class NodeViewFactory
extends AbstractShapeViewFactory {
    public View createView(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        String hint = semanticHint;
        TypedElement element = (TypedElement)semanticAdapter.getAdapter(TypedElement.class);
        String type = element.getType();
        if (type != null) {
            hint = element.getType();
        }
        View view = super.createView(semanticAdapter, containerView, hint, index, persisted, preferencesHint);
        Location loc = NotationFactory.eINSTANCE.createLocation();
        ((Node)view).setLayoutConstraint((LayoutConstraint)loc);
        return view;
    }

    public static final RGB getRGBFromPreferences(String name, PreferencesHint hint) {
        IPreferenceStore store = (IPreferenceStore)hint.getPreferenceStore();
        String string = store.getString(name);
        try {
            return StringConverter.asRGB((String)string);
        }
        catch (DataFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void initializeFromPreferences(View view) {
        super.initializeFromPreferences(view);
        EObject object = ViewUtil.resolveSemanticElement((View)view);
        if (object instanceof MNode) {
            MNode node = (MNode)object;
            IElementType type = ElementTypeRegistry.getInstance().getType(node.getType());
            IconService.getInstance().getIcon((IAdaptable)node);
            if (type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                DiagramModelElementTypeFactory.DiagramModelSpecializationType diagramType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
                RGB fillColor = NodeViewFactory.getRGBFromPreferences(diagramType.getFillColorPreferencesHint(), this.getPreferencesHint());
                RGB lineColor = NodeViewFactory.getRGBFromPreferences(diagramType.getLineColorPreferencesHint(), this.getPreferencesHint());
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillColor));
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineColor));
            }
        }
    }
}

