/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.views.factories;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.view.factories.ConnectionViewFactory;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class EdgeViewFactory
extends ConnectionViewFactory {
    protected void decorateView(View containerView, View view, IAdaptable element, String semanticHint, int index, boolean persisted) {
        super.decorateView(containerView, view, element, semanticHint, index, persisted);
        MEdge edge = (MEdge)element.getAdapter(MEdge.class);
        if (edge != null && edge.getTitleProperty() != null) {
            EdgeViewFactory.getViewService().createNode(element, view, "wde.edgeLabel", -1, true, this.getPreferencesHint());
        }
    }

    public View createView(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        String hint = semanticHint;
        TypedElement element = (TypedElement)semanticAdapter.getAdapter(TypedElement.class);
        String type = element.getType();
        if (type != null) {
            hint = element.getType();
        }
        View view = super.createView(semanticAdapter, containerView, hint, index, true, preferencesHint);
        if (((MEdge)element).getModel() == null) {
            Debug.noop();
            Exception e = new Exception();
            e.printStackTrace();
        }
        return view;
    }

    public static final RGB getRGBFromPreferences(String name, PreferencesHint hint) {
        IPreferenceStore store = (IPreferenceStore)hint.getPreferenceStore();
        String string = store.getString(name);
        return StringConverter.asRGB((String)string);
    }

    protected void initializeFromPreferences(View view) {
        super.initializeFromPreferences(view);
        EObject object = ViewUtil.resolveSemanticElement((View)view);
        if (object instanceof MEdge) {
            MEdge edge = (MEdge)object;
            IElementType type = ElementTypeRegistry.getInstance().getType(edge.getType());
            if (type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                DiagramModelElementTypeFactory.DiagramModelSpecializationType diagramType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
                RGB lineColor = EdgeViewFactory.getRGBFromPreferences(diagramType.getLineColorPreferencesHint(), this.getPreferencesHint());
                ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineColor));
                RoutingStyle routingStyle = (RoutingStyle)view.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
            }
        }
    }
}

