/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.layout;

import com.ibm.etools.diagram.ui.internal.figures.TitleFigure;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class NodeLayout
extends AbstractLayout {
    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        List children = container.getChildren();
        TitleFigure title = (TitleFigure)((Object)container.getChildren().get(0));
        if (children.size() == 2 || children.size() == 3) {
            IFigure primary = this.getPrimary(children);
            Dimension pSize = primary.getPreferredSize();
            pSize.height += title.getLabel().getPreferredSize().height;
            IFigure secondary = this.getSecondary(children);
            Dimension sSize = new Dimension(0, 0);
            if (secondary != null) {
                sSize = secondary.getPreferredSize();
                if (sSize.height + title.getLabel().getPreferredSize().height * 2 > pSize.height) {
                    sSize.height += title.getLabel().getPreferredSize().height * 2;
                }
            }
            Dimension d = title.getPreferredSize();
            d = d.union(pSize);
            d = d.union(sSize);
            return d;
        }
        return new Dimension(-1, -1);
    }

    public void layout(IFigure parent) {
        IFigure secondary;
        int INDENT = MapModeUtil.getMapMode((IFigure)parent).DPtoLP(20);
        Point offset = this.getOrigin(parent);
        Rectangle bounds = null;
        List children = parent.getChildren();
        TitleFigure title = (TitleFigure)((Object)children.get(0));
        bounds = new Rectangle();
        bounds.setLocation(offset.getCopy());
        bounds.width = parent.getBounds().width;
        bounds.height = title.getLabel().getPreferredSize().height * 2;
        title.setBounds(bounds);
        IFigure primary = this.getPrimary(children);
        if (primary != null) {
            bounds = new Rectangle();
            bounds.setLocation(offset.getTranslated(new Point(INDENT * 2, title.getBounds().height / 2)));
            bounds.setSize(primary.getPreferredSize());
            primary.setBounds(bounds);
        }
        if ((secondary = this.getSecondary(children)) != null) {
            bounds = new Rectangle();
            bounds.setLocation(offset.getTranslated(new Point(INDENT, title.getBounds().height)));
            bounds.setSize(secondary.getPreferredSize());
            if (primary != null) {
                bounds.width = primary.getBounds().x - bounds.x + primary.getBounds().width;
            }
            secondary.setBounds(bounds);
        }
    }

    private IFigure getPrimary(List children) {
        IFigure primary = null;
        if (children.size() == 2) {
            primary = (IFigure)children.get(1);
        } else if (children.size() == 3) {
            primary = (IFigure)children.get(2);
        }
        return primary;
    }

    private IFigure getSecondary(List children) {
        IFigure secondary = null;
        if (children.size() == 3) {
            secondary = (IFigure)children.get(1);
        }
        return secondary;
    }

    public void invalidate() {
        super.invalidate();
    }
}

