/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderCompartmentEditPart;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;

public class TwizzleFigure
extends NodeFigure {
    private final ProviderCompartmentEditPart part;
    private Color hoverColor;
    private Color lineColor;
    private boolean hover;
    private boolean drawRoundRectangles;
    private boolean selected;

    public TwizzleFigure(ProviderCompartmentEditPart part) {
        IElementType type;
        this.part = part;
        this.hoverColor = DiagramColorRegistry.getInstance().getColor(DiagramColors.twizzleHover);
        this.lineColor = DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeInnerStroke);
        EObject o = ViewUtil.resolveSemanticElement((View)((View)part.getModel()));
        if (o instanceof Compartment && (o = ((Compartment)o).getParent()) != null && (type = ((TypedElement)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (dType.getShapeStyle() == 2) {
                this.drawRoundRectangles = false;
            } else if (dType.getShapeStyle() == 1) {
                this.drawRoundRectangles = true;
            }
        }
        this.setCollapsed(true);
    }

    public void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            this.repaint();
        }
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle twizzle = this.getClientArea().getCopy();
        twizzle.y -= MapModeUtil.getMapMode((IFigure)this).DPtoLP(14);
        twizzle.height += MapModeUtil.getMapMode((IFigure)this).DPtoLP(14);
        if (this.hover) {
            graphics.setBackgroundColor(this.hoverColor);
        } else {
            graphics.setBackgroundColor(ColorConstants.white);
        }
        graphics.setForegroundColor(this.lineColor);
        if (this.drawRoundRectangles) {
            if (this.selected) {
                graphics.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedInnerStroke));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedOuterStroke));
                graphics.fillRoundRectangle(twizzle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.drawRoundRectangle(twizzle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
            } else {
                graphics.fillRoundRectangle(twizzle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.drawRoundRectangle(twizzle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
            }
        } else if (this.selected) {
            graphics.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedInnerStroke));
            graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.shapeSelectedOuterStroke));
            graphics.fillRectangle(twizzle);
            graphics.drawRectangle(twizzle);
        } else {
            graphics.fillRectangle(twizzle);
            graphics.drawRectangle(twizzle);
        }
        Rectangle clientArea = this.getClientArea().getCopy();
        graphics.drawLine(clientArea.getTopLeft(), clientArea.getTopRight());
        twizzle.x = twizzle.x + twizzle.width - MapModeUtil.getMapMode((IFigure)this).DPtoLP(12);
        twizzle.y = this.getClientArea().y + MapModeUtil.getMapMode((IFigure)this).DPtoLP(2);
        twizzle.width = MapModeUtil.getMapMode((IFigure)this).DPtoLP(6);
        twizzle.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(3);
        DrawerStyle style = (DrawerStyle)((View)this.part.getModel()).getStyle(NotationPackage.eINSTANCE.getDrawerStyle());
        if (style != null) {
            if (style.isCollapsed()) {
                graphics.drawLine(twizzle.getTopLeft(), twizzle.getBottom());
                graphics.drawLine(twizzle.getBottom(), twizzle.getTopRight());
            } else {
                graphics.drawLine(twizzle.getBottomLeft(), twizzle.getTop());
                graphics.drawLine(twizzle.getTop(), twizzle.getBottomRight());
            }
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = new Dimension(-1, -1);
        d.height = MapModeUtil.getMapMode((IFigure)this).DPtoLP(6);
        return d;
    }

    public void setLineColor(Color lineColor) {
        if (this.lineColor != lineColor) {
            this.lineColor = lineColor;
            this.repaint();
        }
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
            this.repaint();
        }
    }

    public void setCollapsed(boolean collapsed) {
        Label tooltip = new Label();
        if (collapsed) {
            tooltip.setText(NLS.bind((String)Messages.DoubleClickToShowX, (Object)this.part.getCompartmentName()));
        } else {
            tooltip.setText(NLS.bind((String)Messages.TwizzleFigure_0, (Object)this.part.getCompartmentName()));
        }
        this.setToolTip((IFigure)tooltip);
    }
}

