/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.figures;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.editparts.NodeItemEditPart;
import com.ibm.etools.diagram.ui.internal.figures.NodeItemSlidableAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class NodeItemFigure
extends NodeFigure {
    private boolean drawBorder;
    private final NodeItemEditPart part;
    private final Color fillColor;
    private boolean drawRoundRectangles = true;
    private boolean shadeBackground;

    public NodeItemFigure(NodeItemEditPart part) {
        IElementType type;
        this.part = part;
        this.fillColor = DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemConnected);
        EObject o = ViewUtil.resolveSemanticElement((View)((View)part.getModel()));
        if (o instanceof Item && (o = ((Item)o).getNode()) != null && (type = ((TypedElement)o).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (dType.getShapeStyle() == 2) {
                this.drawRoundRectangles = false;
            } else if (dType.getShapeStyle() == 1) {
                this.drawRoundRectangles = true;
            }
        }
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        return new NodeItemSlidableAnchor((IFigure)this, p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new NodeItemSlidableAnchor((IFigure)this);
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        return super.createConnectionAnchor(p);
    }

    public WrappingLabel getLabel() {
        return (WrappingLabel)this.getChildren().get(1);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int max;
        Dimension d = super.getPreferredSize(wHint, hHint);
        this.getLabel().getPreferredSize();
        Dimension labelMax = this.getLabel().getMaximumSize();
        d.width = Math.max(d.width, labelMax.width + MapModeUtil.getMapMode((IFigure)this).DPtoLP(2));
        int min = MapModeUtil.getMapMode((IFigure)this).DPtoLP(110);
        if (d.width < min) {
            d.width = min;
        }
        if (d.width > (max = MapModeUtil.getMapMode((IFigure)this).DPtoLP(200))) {
            d.width = max;
        }
        return d;
    }

    public void paintFigure(Graphics graphics) {
        int originalHeight;
        Rectangle newClip;
        Rectangle oldClip;
        Rectangle shrunk;
        Rectangle background;
        Rectangle outsideRectangle = this.getBounds().getCopy();
        outsideRectangle.crop(new Insets(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), 0, 0, 0));
        boolean compartment2 = false;
        boolean lastCompartment = false;
        EditPart compartment = this.part.getParent();
        if (compartment.getParent().getChildren().indexOf(compartment) == 1) {
            compartment2 = true;
        }
        if (compartment.getParent().getChildren().indexOf(compartment) == compartment.getParent().getChildren().size() - 1) {
            lastCompartment = true;
        }
        if (this.shadeBackground) {
            Rectangle copy;
            if (this.drawRoundRectangles && compartment2 && !lastCompartment && this.part.getParent().getChildren().indexOf(this.part) == 0) {
                copy = outsideRectangle.getCopy();
                outsideRectangle.height += MapModeUtil.getMapMode((IFigure)this).DPtoLP(14);
                graphics.setBackgroundColor(this.fillColor);
                graphics.fillRoundRectangle(outsideRectangle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                outsideRectangle = copy;
            } else if (this.drawRoundRectangles && lastCompartment && this.part.getParent().getChildren().indexOf(this.part) == this.part.getParent().getChildren().size() - 1) {
                copy = outsideRectangle.getCopy();
                graphics.setBackgroundColor(this.fillColor);
                graphics.fillRoundRectangle(outsideRectangle, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                if (this.part.getParent().getChildren().indexOf(this.part) != 0) {
                    outsideRectangle.height /= 2;
                    graphics.fillRectangle(outsideRectangle);
                }
                outsideRectangle = copy;
            } else {
                graphics.setBackgroundColor(this.fillColor);
                graphics.fillRectangle(outsideRectangle);
            }
        }
        if (this.drawBorder && this.isVisible()) {
            if (this.drawRoundRectangles && compartment2 && this.part.getParent().getChildren().indexOf(this.part) == 0) {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                oldClip = graphics.getClip(new Rectangle());
                newClip = outsideRectangle.getCopy();
                originalHeight = newClip.height;
                newClip.height /= 2;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverOuterStroke));
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverInnerStroke));
                graphics.drawRoundRectangle(shrunk, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                newClip.y += originalHeight / 2;
                newClip.height = originalHeight;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverInnerStroke));
                graphics.drawRectangle(shrunk);
                graphics.setClip(oldClip);
            } else if (this.drawRoundRectangles && compartment2 && lastCompartment && this.part.getParent().getChildren().indexOf(this.part) == this.part.getParent().getChildren().size() - 1) {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                oldClip = graphics.getClip(new Rectangle());
                newClip = outsideRectangle.getCopy();
                originalHeight = newClip.height;
                newClip.height /= 2;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverInnerStroke));
                graphics.drawRectangle(shrunk);
                newClip.y += originalHeight / 2;
                newClip.height = originalHeight;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverOuterStroke));
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverInnerStroke));
                graphics.drawRoundRectangle(shrunk, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setClip(oldClip);
            } else {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemHoverInnerStroke));
                graphics.drawRectangle(shrunk);
            }
        }
        if (this.part.getSelected() > 0) {
            if (this.drawRoundRectangles && compartment2 && this.part.getParent().getChildren().indexOf(this.part) == 0) {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                oldClip = graphics.getClip(new Rectangle());
                newClip = outsideRectangle.getCopy();
                originalHeight = newClip.height;
                newClip.height /= 2;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedOuterStroke));
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedInnerStroke));
                graphics.drawRoundRectangle(shrunk, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                newClip.y += originalHeight / 2;
                newClip.height = originalHeight;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedInnerStroke));
                graphics.drawRectangle(shrunk);
                graphics.setClip(oldClip);
            } else if (this.drawRoundRectangles && compartment2 && lastCompartment && this.part.getParent().getChildren().indexOf(this.part) == this.part.getParent().getChildren().size() - 1) {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                oldClip = graphics.getClip(new Rectangle());
                newClip = outsideRectangle.getCopy();
                originalHeight = newClip.height;
                newClip.height /= 2;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedInnerStroke));
                graphics.drawRectangle(shrunk);
                newClip.y += originalHeight / 2;
                newClip.height = originalHeight;
                graphics.setClip(newClip);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedOuterStroke));
                graphics.drawRoundRectangle(background, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedInnerStroke));
                graphics.drawRoundRectangle(shrunk, MapModeUtil.getMapMode((IFigure)this).DPtoLP(14), MapModeUtil.getMapMode((IFigure)this).DPtoLP(14));
                graphics.setClip(oldClip);
            } else {
                background = outsideRectangle.getCopy();
                shrunk = background.getCopy().shrink(MapModeUtil.getMapMode((IFigure)this).DPtoLP(1), MapModeUtil.getMapMode((IFigure)this).DPtoLP(1));
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedOuterStroke));
                graphics.drawRectangle(background);
                graphics.setForegroundColor(DiagramColorRegistry.getInstance().getColor(DiagramColors.nodeItemSelectedInnerStroke));
                graphics.drawRectangle(shrunk);
            }
        }
        graphics.setForegroundColor(ColorConstants.black);
    }

    public void setDrawBorder(boolean drawborder) {
        if (this.drawBorder != drawborder) {
            this.drawBorder = drawborder;
            this.repaint();
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setShadeBackground(boolean shadeBackground) {
        if (this.shadeBackground != shadeBackground) {
            this.shadeBackground = shadeBackground;
            this.repaint();
        }
    }
}

