/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies.handles;

import com.ibm.etools.diagram.ui.internal.editparts.NodeItemEditPart;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderNodeEditPart;
import com.ibm.etools.diagram.ui.internal.editpolicies.handles.FixedConnectorHandleLocator;
import com.ibm.etools.diagram.ui.internal.editpolicies.handles.WebConnectionHandle;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;

public class ProviderConnectorHandleEditPolicy
extends ConnectionHandleEditPolicy {
    private boolean limitEastWest = false;
    private final boolean fixed;

    public ProviderConnectorHandleEditPolicy(boolean limitEastWest, boolean fixed) {
        this.limitEastWest = limitEastWest;
        this.fixed = fixed;
    }

    protected List<WebConnectionHandle> getHandleFigures() {
        ArrayList<WebConnectionHandle> list = new ArrayList<WebConnectionHandle>(1);
        String tooltip = this.buildTooltip(ConnectionHandle.HandleDirection.OUTGOING);
        if (tooltip != null) {
            list.add(new WebConnectionHandle((IGraphicalEditPart)this.getHost(), ConnectionHandle.HandleDirection.OUTGOING, tooltip));
        }
        return list;
    }

    protected ConnectionHandleLocator getConnectionHandleLocator(Point referencePoint) {
        if (this.fixed) {
            return new FixedConnectorHandleLocator(this.getHostFigure(), referencePoint);
        }
        if (this.limitEastWest) {
            return new FixedConnectorHandleLocator(this.getHostFigure(), referencePoint);
        }
        return new ConnectionHandleLocator(this.getHostFigure(), referencePoint);
    }

    protected int getAppearanceDelay() {
        return super.getAppearanceDelay();
    }

    protected int getDisappearanceDelay() {
        return -1;
    }

    protected int getDisappearanceDelayUponExit() {
        if (this.fixed) {
            return 2000;
        }
        return 2000;
    }

    protected String buildTooltip(ConnectionHandle.HandleDirection direction) {
        EditPart part = this.getHost();
        if (part instanceof NodeItemEditPart) {
            return Messages.DragToShowOrChangeTarget;
        }
        if (part instanceof ProviderNodeEditPart) {
            return Messages.CreateTarget;
        }
        return null;
    }
}

