/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies.canonical;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MDiagram;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.TypedElement;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class ProviderCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private static final List<String> allowedNotationTypes = Arrays.asList("Text,Note,NoteAttachment,oval,triangle,rectangle,shadowRectangle,rectangle3D,roundRectangle,hexagon,octagon,pentagon,diamond,cylinder,line".split(","));
    private boolean reEntrantRefresh = false;

    protected List<MNode> getSemanticChildrenList() {
        MDiagram d = (MDiagram)ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
        return d.getNodes();
    }

    protected List<Object> getSemanticConnectionsList() {
        MDiagram d = (MDiagram)ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
        if (d == null || d.getModel() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> edges = new ArrayList<Object>((Collection<Object>)d.getModel().getEdges());
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            MEdge edge = (MEdge)iter.next();
            if (edge.getSource() != null && edge.getTarget() != null && edge.getModel() != null) continue;
            iter.remove();
        }
        return edges;
    }

    protected EObject getSourceElement(EObject relationship) {
        MEdge edge = (MEdge)relationship;
        MNode node = edge.getSource();
        EList compartments = node.getCompartments();
        Item item = EdgeGeneratorService.getInstance().getEdgesItem((List)compartments, (MEdge)relationship);
        return item == null ? node : item;
    }

    protected EObject getTargetElement(EObject relationship) {
        MEdge edge = (MEdge)relationship;
        return edge.getTarget();
    }

    private List<Object> getDiagramConnections() {
        Diagram dView = ((View)this.host().getModel()).getDiagram();
        return dView == null ? Collections.EMPTY_LIST : new ArrayList(dView.getEdges());
    }

    protected Collection<Edge> getConnectionViews() {
        HashSet<Edge> retval = new HashSet<Edge>();
        List children = this.getViewChildren();
        for (Edge edge : this.getDiagramConnections()) {
            if (!this.shouldIncludeConnection(edge, children)) continue;
            retval.add(edge);
        }
        return retval;
    }

    protected boolean shouldCheckForConnections(View view, Collection viewChildren) {
        return super.shouldCheckForConnections(view, viewChildren);
    }

    protected boolean shouldIncludeConnection(Edge connection, Collection children) {
        View src = connection.getSource();
        View target = connection.getTarget();
        if (src == null || target == null) {
            return true;
        }
        return children.contains(src) || children.contains(src.eContainer()) || children.contains(target) || children.contains(target.eContainer());
    }

    private Command getReSourceEdgeCommand(final View source, final Edge edge) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Debug.noop();
                edge.setSource(source);
                return CommandResult.newOKCommandResult();
            }
        });
    }

    protected List<Object> refreshSemanticConnections() {
        Collection<Edge> viewChildren = this.getConnectionViews();
        HashSet<Object> semanticChildren = new HashSet<Object>();
        semanticChildren.addAll(this.getSemanticConnectionsList());
        ArrayList<Edge> orphaned = new ArrayList<Edge>();
        ArrayList<Command> resourceCommands = new ArrayList<Command>();
        Iterator<Edge> iter = viewChildren.iterator();
        block0: while (iter.hasNext()) {
            EObject semanticObject;
            Edge edge = iter.next();
            if (edge.getElement() == null) {
                iter.remove();
                orphaned.add(edge);
                continue;
            }
            boolean bl = false;
            Iterator iterator = semanticChildren.iterator();
            while (iterator.hasNext()) {
                MEdge semEdge = (MEdge)iterator.next();
                if (!edge.getElement().equals(semEdge)) continue;
                bl = true;
                iterator.remove();
            }
            if (!bl) {
                if (edge.getElement() != null && edge.getElement().eResource() != null && edge.getElement().eContainer() != null && (edge.getSource() == null || edge.getSource().eResource() != null) && (edge.getTarget() == null || edge.getTarget().eResource() != null)) continue;
                iter.remove();
                orphaned.add(edge);
                continue;
            }
            if (edge.getSource() != null || !((semanticObject = edge.getElement()) instanceof MEdge)) continue;
            MEdge semanticEdge = (MEdge)semanticObject;
            EList nodeChildren = ((View)this.host().getModel()).getDiagram().getChildren();
            for (View view : nodeChildren) {
                if (semanticEdge.getSource() != view.getElement()) continue;
                resourceCommands.add(this.getReSourceEdgeCommand(view, edge));
                continue block0;
            }
        }
        for (Command cmd : resourceCommands) {
            this.executeCommand(cmd);
        }
        EditPartViewer viewer = this.getHost().getViewer();
        for (View view : viewChildren) {
            EditPart viewPart = (EditPart)viewer.getEditPartRegistry().get(view);
            if (viewPart == null) continue;
            viewPart.refresh();
        }
        if (orphaned.size() > 0) {
            Debug.noop();
        }
        this.deleteViews(orphaned.iterator());
        ArrayList<Object> viewDescriptors = new ArrayList<Object>();
        for (EObject eObject : semanticChildren) {
            Edge viewChild = this.createConnectionView(eObject, -1);
            if (viewChild == null) continue;
            viewDescriptors.add(new EObjectAdapter((EObject)viewChild));
        }
        this.makeViewsMutable(viewDescriptors);
        HashSet<EditPart> ends = new HashSet<EditPart>();
        ListIterator li = viewDescriptors.listIterator();
        while (li.hasNext()) {
            EditPart targetEP;
            IAdaptable adaptable = (IAdaptable)li.next();
            Edge edge = (Edge)adaptable.getAdapter(Edge.class);
            EditPart sourceEP = this.getEditPartFor((EObject)edge.getSource(), (EObject)edge);
            if (sourceEP != null) {
                ends.add(sourceEP);
            }
            if ((targetEP = this.getEditPartFor((EObject)edge.getTarget(), (EObject)edge)) == null) continue;
            ends.add(targetEP);
        }
        for (EditPart end : ends) {
            end.refresh();
        }
        return viewDescriptors;
    }

    protected EditPart getSourceEditPartFor(EObject connection) {
        EObject sel = this.getSourceElement(connection);
        EditPart sep = this.getEditPartFor(sel, connection);
        return sep;
    }

    private EditPart getEditPartFor(EObject element, EObject context) {
        EditPartViewer viewer;
        if (element != null && !(element instanceof View) && (viewer = this.getHost().getViewer()) instanceof IDiagramGraphicalViewer) {
            EObject container;
            EditPart containerEP;
            List parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(((XMLResource)element.eResource()).getID(element), INodeEditPart.class);
            if (parts.isEmpty() && (containerEP = this.getEditPartFor(container = element.eContainer(), null)) != null) {
                containerEP.refresh();
                parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(((XMLResource)element.eResource()).getID(element), INodeEditPart.class);
            }
            return this.findEditPartForElement(element, context, parts);
        }
        return (EditPart)this.host().getViewer().getEditPartRegistry().get(element);
    }

    protected boolean shouldDeleteView(View view) {
        return !allowedNotationTypes.contains(view.getType());
    }

    protected void refreshSemantic() {
        if (!this.reEntrantRefresh) {
            boolean local = this.reEntrantRefresh;
            this.reEntrantRefresh = true;
            super.refreshSemantic();
            this.reEntrantRefresh = local;
        }
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
    }

    public void setEnable(boolean enable) {
        super.setEnable(enable);
    }

    public void enableRefresh(boolean enable) {
        super.enableRefresh(enable);
    }

    protected boolean shouldHandleNotificationEvent(Notification event) {
        boolean shouldhandle = super.shouldHandleNotificationEvent(event);
        return shouldhandle;
    }

    public void activate() {
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
    }

    protected void executeCommand(final Command cmd) {
        Map<String, Boolean> options = null;
        EditPart ep = this.getHost();
        while (ep != null && !(ep instanceof DiagramEditPart)) {
            ep = ep.getParent();
        }
        if (ep == null || ((DiagramEditPart)ep).isActivatingDiagram() || !EditPartUtil.isWriteTransactionInProgress((IGraphicalEditPart)((IGraphicalEditPart)this.getHost()), (boolean)false, (boolean)false)) {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
        } else {
            options = Collections.singletonMap("unprotected", Boolean.TRUE);
            Debug.noop();
        }
        AbstractEMFOperation operation = new AbstractEMFOperation(((IGraphicalEditPart)this.getHost()).getEditingDomain(), "", options){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                cmd.execute();
                return Status.OK_STATUS;
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Status status = new Status(4, DiagramPlugin.getPluginId(), 4, "executeCommand", (Throwable)e);
            DiagramPlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element) {
        String factoryHint = this.getDefaultFactoryHint();
        if (element instanceof TypedElement) {
            factoryHint = ((TypedElement)element).getType();
        }
        CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(element, factoryHint);
        int pos = this.getViewIndexFor(element);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, this.getFactoryHint((IAdaptable)elementAdapter, factoryHint), pos);
        return descriptor;
    }
}

