/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies.canonical;

import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.ui.internal.DiagramPlugin;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

public class CompartmentCreationEditPolicy
extends CanonicalEditPolicy {
    private boolean reEntrantRefresh = false;

    protected List<Object> getSemanticChildrenList() {
        EObject o = this.host().resolveSemanticElement();
        if (!(o instanceof MNode)) {
            return Collections.EMPTY_LIST;
        }
        MNode providerNode = (MNode)o;
        Command cmd = this.getCompartmentsCommand(providerNode);
        this.executeCommand(cmd);
        ArrayList<Object> compartments = new ArrayList<Object>(DiagramCommandStack.getReturnValues((Command)cmd));
        return compartments;
    }

    private Command getCompartmentsCommand(final MNode node) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "Load Compartments", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EList compartments = node.getCompartments();
                return CommandResult.newOKCommandResult((Object)compartments);
            }
        });
    }

    protected void refreshSemantic() {
        if (!this.reEntrantRefresh) {
            this.reEntrantRefresh = true;
            List createdViews = this.refreshSemanticChildren();
            this.makeViewsMutable(createdViews);
            this.reEntrantRefresh = false;
        }
    }

    protected Command getDeleteViewCommand(View view) {
        return super.getDeleteViewCommand(view);
    }

    protected boolean shouldDeleteView(View view) {
        return super.shouldDeleteView(view);
    }

    protected final List<Object> _refreshSemanticChildren() {
        if (this.resolveSemanticElement() == null) {
            return Collections.EMPTY_LIST;
        }
        List viewChildren = this.getViewChildren();
        ArrayList<Object> semanticChildren = new ArrayList<Object>(this.getSemanticChildrenList());
        List<View> orphaned = this._cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
        boolean changed = false;
        if (!orphaned.isEmpty()) {
            changed = this.deleteViews(orphaned.iterator());
        }
        List createdViews = Collections.EMPTY_LIST;
        if (!semanticChildren.isEmpty()) {
            createdViews = this.createViews(semanticChildren);
            int i = 0;
            while (i < createdViews.size()) {
                View createdView = (View)((IAdaptable)createdViews.get(i)).getAdapter(View.class);
                if (createdView == null) {
                    String eMsg = NLS.bind((String)Messages.CreateViewFailed, semanticChildren.get(i));
                    IllegalStateException ise = new IllegalStateException(eMsg);
                    Log.error((Plugin)DiagramPlugin.getInstance(), (int)4, (String)eMsg, (Throwable)ise);
                    throw ise;
                }
                ++i;
            }
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        return createdViews;
    }

    protected final List<View> _cleanCanonicalSemanticChildren(Collection<Object> viewChildren, Collection<Object> semanticChildren) {
        ArrayList<View> orphaned = new ArrayList<View>();
        for (View view : viewChildren) {
            if (this.hasType(view.getType(), semanticChildren)) {
                this.removeTypeAndUpdateView(view, semanticChildren);
                continue;
            }
            orphaned.add(view);
        }
        return orphaned;
    }

    private void removeTypeAndUpdateView(View view, Collection<Object> semanticChildren) {
        Iterator<Object> iter = semanticChildren.iterator();
        while (iter.hasNext()) {
            Compartment compartment = (Compartment)iter.next();
            if (!view.getType().equals(compartment.getType())) continue;
            iter.remove();
            break;
        }
    }

    private boolean hasType(String type, Collection<Object> semanticChildren) {
        for (Compartment compartment : semanticChildren) {
            if (!type.equals(compartment.getType())) continue;
            return true;
        }
        return false;
    }
}

