/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editpolicies;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.DiagramFacetUtil;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.ui.internal.adapters.EdgeItemConnectionAdapter;
import com.ibm.etools.diagram.ui.internal.commands.CreateOrSelectEdgeCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.widgets.Display;

public class ResourceGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        CompoundCommand cc;
        if (request.getStartCommand() instanceof CompoundCommand && (cc = (CompoundCommand)request.getStartCommand()).getCommands().size() >= 2 && cc.getChildren()[1] instanceof ICommandProxy) {
            Command saved = request.getStartCommand();
            request.setStartCommand((Command)cc.getChildren()[1]);
            cc.getCommands().set(1, super.getConnectionCompleteCommand(request));
            request.setStartCommand(saved);
            return request.getStartCommand();
        }
        return super.getConnectionCompleteCommand(request);
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        createElementRequest.setPrompt(!request.isUISupressed());
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        View sourceView = (View)request.getSourceEditPart().getModel();
        View targetView = (View)targetEP.getModel();
        createElementRequest.setSource(ViewUtil.resolveSemanticElement((View)sourceView));
        createElementRequest.setTarget(ViewUtil.resolveSemanticElement((View)targetView));
        createElementRequest.addParameters(request.getExtendedData());
        Command createElementCommand = targetEP.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class))));
        if (createElementCommand == null) {
            return null;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        if (viewCommand == null) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getUnspecifiedConnectionCompleteCommand(CreateUnspecifiedTypeConnectionRequest request) {
        Item item;
        IGraphicalEditPart targetEP;
        if (request.isDirectionReversed()) {
            return this.getReversedUnspecifiedConnectionCompleteCommand(request);
        }
        List allRequests = request.getAllRequests();
        if (allRequests.isEmpty()) {
            return null;
        }
        IGraphicalEditPart sourceEP = (IGraphicalEditPart)((CreateConnectionRequest)allRequests.get(0)).getSourceEditPart();
        if (sourceEP == (targetEP = (IGraphicalEditPart)((CreateConnectionRequest)allRequests.get(0)).getTargetEditPart())) {
            return null;
        }
        List relTypes = request.useModelingAssistantService() ? ModelingAssistantService.getInstance().getRelTypesOnSourceAndTarget((IAdaptable)sourceEP, (IAdaptable)targetEP) : request.getElementTypes();
        Item sourceItem = (Item)sourceEP.getAdapter(Item.class);
        MNode targetNode = (MNode)targetEP.getAdapter(MNode.class);
        if (targetNode == null && (item = (Item)targetEP.getAdapter(Item.class)) != null) {
            targetNode = item.getNode();
        }
        if (targetNode == null || sourceItem != null && sourceItem.getNode().equals(targetNode)) {
            return null;
        }
        HashMap<EdgeItemConnectionAdapter, Map<String, Object>> requestOptions = new HashMap<EdgeItemConnectionAdapter, Map<String, Object>>();
        ArrayList<EdgeItemConnectionAdapter> validRelTypes = new ArrayList<EdgeItemConnectionAdapter>();
        for (IElementType type : relTypes) {
            CreateRequest createConnectorRequest = request.getRequestForType(type);
            if (createConnectorRequest == null) continue;
            ArrayList itemTypes = new ArrayList();
            if (type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
                List genItemTypes = dType.getGeneratesItemIds();
                if (genItemTypes.isEmpty()) {
                    itemTypes.add(null);
                } else {
                    itemTypes.addAll(genItemTypes);
                }
            } else {
                itemTypes.add(null);
            }
            for (String id : itemTypes) {
                IElementType genItemType = null;
                if (id != null) {
                    genItemType = ElementTypeRegistry.getInstance().getType(id);
                }
                boolean foundExisting = false;
                boolean ignoreReference = false;
                if (sourceItem != null) {
                    List references = EdgeGeneratorService.getInstance().generateExistingReferences(sourceItem, type, genItemType);
                    for (SourceReference ref : references) {
                        if (ref == SourceReference.HIDDEN) {
                            ignoreReference = true;
                            break;
                        }
                        boolean resolvable = EdgeResolverService.getInstance().isResolvable(targetNode, ref);
                        if (resolvable) {
                            EdgeItemConnectionAdapter adapter = new EdgeItemConnectionAdapter(type, genItemType);
                            boolean alreadyConnected = false;
                            List edges = EdgeGeneratorService.getInstance().getItemsEdges(sourceItem);
                            Iterator eItr = edges.iterator();
                            while (eItr.hasNext() && !alreadyConnected) {
                                MEdge edge = (MEdge)eItr.next();
                                if (!ref.getEdgeType().getId().equals(edge.getType()) || !targetNode.equals(edge.getTarget())) continue;
                                alreadyConnected = true;
                            }
                            if (!alreadyConnected) {
                                HashMap<String, Object> m = new HashMap<String, Object>();
                                m.put("source reference", ref);
                                m.put("existing edge", Boolean.TRUE);
                                m.put("Selected Item Type Parameter Key", genItemType);
                                requestOptions.put(adapter, m);
                                validRelTypes.add(adapter);
                                foundExisting = true;
                                continue;
                            }
                            foundExisting = true;
                            continue;
                        }
                        List descriptors = EdgeResolverService.getInstance().getTargetableNodeDescriptors(targetNode.getElementType(), ref);
                        if (!descriptors.contains(ModelDescriptor.HIDDEN)) continue;
                        ignoreReference = true;
                    }
                }
                if (ignoreReference || foundExisting) continue;
                EdgeItemConnectionAdapter adapter = new EdgeItemConnectionAdapter(type, genItemType);
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("source node item", sourceItem);
                m.put("existing edge", Boolean.FALSE);
                m.put("Selected Item Type Parameter Key", genItemType);
                String requiredFacet = null;
                if (type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                    HashMap reqs = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getItemFacetRequirements();
                    requiredFacet = (String)reqs.get(id);
                }
                if (requiredFacet != null) {
                    IProject project;
                    IFile file;
                    EditPart part = request.getSourceEditPart();
                    EObject eo = (EObject)part.getModel();
                    Resource res = eo.eResource();
                    if (res == null || (file = WorkspaceSynchronizer.getFile((Resource)res)) == null || !DiagramFacetUtil.hasFacet((IProject)(project = file.getProject()), (String)requiredFacet)) continue;
                    validRelTypes.add(adapter);
                    requestOptions.put(adapter, m);
                    continue;
                }
                validRelTypes.add(adapter);
                requestOptions.put(adapter, m);
            }
        }
        if (requestOptions.isEmpty()) {
            return null;
        }
        if (requestOptions.size() == 1) {
            EdgeItemConnectionAdapter adapter = (EdgeItemConnectionAdapter)requestOptions.keySet().toArray()[0];
            CreateRequest req = request.getRequestForType(adapter.getEdgeType());
            req.getExtendedData().putAll((Map)requestOptions.get(adapter));
            Command cmd = this.getHost().getCommand((Request)req);
            return cmd;
        }
        CreateOrSelectEdgeCommand selectAndCreateConnectorCmd = new CreateOrSelectEdgeCommand(Display.getCurrent().getActiveShell(), validRelTypes);
        selectAndCreateConnectorCmd.setHost(this.getHost());
        selectAndCreateConnectorCmd.setRequestOptions(requestOptions);
        selectAndCreateConnectorCmd.setUnspecifiedTypeConnectionRequest(request);
        return new ICommandProxy((ICommand)selectAndCreateConnectorCmd);
    }

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (request instanceof CreateConnectionViewAndElementRequest) {
            CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
            req.getConnectionViewDescriptor().setPersisted(false);
        }
        return super.getConnectionCreateCommand(request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return super.getReconnectTargetCommand(request);
    }
}

