/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.editparts;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.emf.Adaptable;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.ui.internal.DiagramColors;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderCompartmentEditPart;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderTextCompartmentEditPart;
import com.ibm.etools.diagram.ui.internal.editparts.ProviderTitleEditPart;
import com.ibm.etools.diagram.ui.internal.editpolicies.DiagramConstrainedToolbarLayoutPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.OpenFileEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.ProviderCreationEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.ResourceGraphicalNodeEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.canonical.CompartmentCreationEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.handles.ProviderConnectorHandleEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.popups.NonModelPopupBarToolEditPolicy;
import com.ibm.etools.diagram.ui.internal.editpolicies.size.ProviderShapeResizableEditPolicy;
import com.ibm.etools.diagram.ui.internal.figures.ProviderFigure;
import com.ibm.etools.diagram.ui.internal.requests.CreateSemanticElementRequest;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.ChangePropertyValueRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ProviderNodeEditPart
extends ShapeNodeEditPart
implements IPrimaryEditPart {
    public ProviderNodeEditPart(View shapeView) {
        super(shapeView);
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        MNode node;
        IElementType type;
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore && (type = (node = (MNode)this.resolveSemanticElement()).getElementType()) instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
            DiagramModelElementTypeFactory.DiagramModelSpecializationType dType = (DiagramModelElementTypeFactory.DiagramModelSpecializationType)type;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                String lineHint = dType.getLineColorPreferencesHint();
                if (lineHint == null) {
                    lineHint = "Appearance.lineColor";
                }
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)lineHint));
            }
            if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.fontColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                String fillColor = dType.getFillColorPreferencesHint();
                if (fillColor == null) {
                    fillColor = "Appearance.fillColor";
                }
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)fillColor));
            }
        }
        return super.getPreferredValue(feature);
    }

    public Object getAdapter(Class key) {
        Object o = super.getAdapter(key);
        if (o != null) {
            return o;
        }
        EObject e = this.resolveSemanticElement();
        if (e != null) {
            IFile file;
            if (key == IResource.class && (file = (IFile)Platform.getAdapterManager().getAdapter((Object)e, IFile.class)) != null) {
                return file;
            }
            Object obj = Platform.getAdapterManager().getAdapter((Object)e, key);
            if (obj != null) {
                return obj;
            }
            if (e instanceof Adaptable) {
                obj = ((Adaptable)e).getAdapter(key);
                return obj;
            }
        }
        return null;
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    EObject object = ProviderNodeEditPart.this.resolveSemanticElement();
                    if (object instanceof IPropertyHolder) {
                        e.result = PropertyDisplayService.getInstance().getTooltip(((IPropertyHolder)object).getTitleProperty());
                        if (e.result == null && ((IPropertyHolder)object).getTitleProperty() != null) {
                            e.result = ((IPropertyHolder)object).getTitleProperty().getValue();
                        }
                    }
                }
            };
        }
        return this.accessibleEP;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new ProviderCreationEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SemanticEditPolicy(){

            protected IEditCommandRequest completeRequest(IEditCommandRequest request) {
                HashMap map = new HashMap(request.getParameters());
                IEditCommandRequest req = super.completeRequest(request);
                req.addParameters(map);
                return req;
            }

            public boolean understandsRequest(Request request) {
                Command cmd;
                boolean understands = super.understandsRequest(request);
                if (!understands && "create semantic element".equals(request.getType()) && (cmd = this.getCommand(request)) != null && cmd.canExecute()) {
                    understands = true;
                }
                return understands;
            }

            public Command getCommand(Request request) {
                Command cmd = null;
                if ("create semantic element".equals(request.getType())) {
                    cmd = this.getSemanticCommand((IEditCommandRequest)((CreateSemanticElementRequest)request).getCreateElementRequest());
                    if (cmd == null) {
                        cmd = UnexecutableCommand.INSTANCE;
                    }
                } else {
                    cmd = super.getCommand(request);
                }
                return cmd;
            }
        });
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramConstrainedToolbarLayoutPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ResourceGraphicalNodeEditPolicy());
        boolean hasHandles = true;
        EObject object = this.resolveSemanticElement();
        if (object instanceof IPropertyHolder) {
            hasHandles = PropertyDisplayService.getInstance().hasHandles(((IPropertyHolder)object).getTitleProperty());
        }
        if (hasHandles) {
            this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ProviderConnectorHandleEditPolicy(false, true));
        } else {
            this.removeEditPolicy("ConnectionHandlesPolicy");
        }
        this.installEditPolicy("Canonical", (EditPolicy)new CompartmentCreationEditPolicy());
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new NonModelPopupBarToolEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteSemanticCommand(GroupRequest deleteRequest) {
                DestroyElementRequest req = new DestroyElementRequest(false);
                req.addParameters(deleteRequest.getExtendedData());
                EditCommandRequestWrapper editCommandRequest = new EditCommandRequestWrapper((IEditCommandRequest)req);
                editCommandRequest.getExtendedData().putAll(deleteRequest.getExtendedData());
                Command semanticCmd = this.getHost().getCommand((Request)editCommandRequest);
                if (semanticCmd != null && semanticCmd.canExecute()) {
                    CompoundCommand cc = new CompoundCommand();
                    cc.add(semanticCmd);
                    return cc;
                }
                return this.createDeleteViewCommand(deleteRequest);
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new AbstractEditPolicy(){

            public boolean understandsRequest(Request req) {
                return super.understandsRequest(req);
            }

            public void showTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    ProviderFigure fig = (ProviderFigure)ProviderNodeEditPart.this.getFigure();
                    fig.setDrawBorder(true);
                }
            }

            public void eraseTargetFeedback(Request request) {
                if ("selection".equals(request.getType())) {
                    ProviderFigure fig = (ProviderFigure)ProviderNodeEditPart.this.getFigure();
                    fig.setDrawBorder(false);
                }
            }
        });
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected void addChild(EditPart child, int index) {
        super.addChild(child, index);
    }

    public void activate() {
        super.activate();
    }

    protected NodeFigure createNodeFigure() {
        ProviderFigure fig = new ProviderFigure(this);
        fig.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(2), this.getMapMode().DPtoLP(2), this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(2)));
        return fig;
    }

    public WrappingLabel getTitleLabel() {
        return ((ProviderTitleEditPart)((Object)this.getChildren().get(0))).getLabel();
    }

    public void changeDrawerPosition(boolean expand) {
        List children = this.getChildren();
        for (EditPart part : children) {
            ProviderCompartmentEditPart compartment;
            if (!(part instanceof ProviderCompartmentEditPart) || (compartment = (ProviderCompartmentEditPart)part).isPrimary()) continue;
            Boolean e = expand ? Boolean.TRUE : Boolean.FALSE;
            ChangePropertyValueRequest request = new ChangePropertyValueRequest("", PackageUtil.getID((ENamedElement)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed()), (Object)e);
            final Command cmd = compartment.getCommand((Request)request);
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    cmd.execute();
                }
            });
        }
    }

    public Command getCommand(Request _request) {
        if (_request instanceof CreateConnectionViewAndElementRequest) {
            Debug.noop();
        }
        Command cmd = super.getCommand(_request);
        return cmd;
    }

    public IFigure getContentPane() {
        return this.getProviderfigure().getContentPane();
    }

    public ProviderFigure getProviderfigure() {
        return (ProviderFigure)this.getFigure();
    }

    protected ConnectionEditPart createOrFindConnection(Object model) {
        ConnectionEditPart conx = (ConnectionEditPart)this.getViewer().getEditPartRegistry().get(model);
        if (conx != null) {
            return conx;
        }
        return this.createConnection(model);
    }

    protected void refreshBackgroundColor() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getFillStyle());
        if (style != null) {
            MNode node;
            RGB primaryColor = FigureUtilities.integerToRGB((Integer)new Integer(style.getFillColor()));
            EObject o = this.resolveSemanticElement();
            if (o instanceof MNode && !(node = (MNode)o).isRealized()) {
                primaryColor = DiagramColors.shapeUnrealizedSolid;
            }
            this.getProviderfigure().setFillColor(primaryColor);
        }
    }

    protected void setBackgroundColor(Color color) {
        this.refreshBackgroundColor();
    }

    protected void setForegroundColor(Color color) {
        this.refreshForegroundColor();
    }

    protected void refreshForegroundColor() {
        LineStyle style = (LineStyle)this.getPrimaryView().getStyle(NotationPackage.eINSTANCE.getLineStyle());
        if (style != null) {
            RGB fillColor = FigureUtilities.integerToRGB((Integer)new Integer(style.getLineColor()));
            this.getProviderfigure().setLineColor(fillColor);
            EObject o = this.resolveSemanticElement();
            if (o instanceof MNode) {
                MNode node = (MNode)o;
                node.isRealized();
            }
            this.getProviderfigure().setLineColor(fillColor);
        }
    }

    protected void refreshFont() {
        super.refreshFont();
    }

    protected void refreshFontColor() {
        super.refreshFontColor();
    }

    public EditPart getPrimaryChildEditPart() {
        EditPart part = super.getPrimaryChildEditPart();
        return part;
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
    }

    protected void handleNotificationEvent(Notification e) {
        super.handleNotificationEvent(e);
        if (DiagramModelPackage.eINSTANCE.getIRealizable_Realized().equals(e.getFeature())) {
            Debug.println((String)("ProviderNodeEditPart responded to EMF realized event. Element:" + this.resolveSemanticElement()), (String)Debug.DiagramTraceOptions.TRACE_NOTATION, null);
            this.refreshBackgroundColor();
            this.refreshForegroundColor();
            List children = this.getChildren();
            for (IGraphicalEditPart part : children) {
                if (part instanceof ProviderCompartmentEditPart) {
                    ((ProviderCompartmentEditPart)part).refreshVisuals();
                    continue;
                }
                if (!(part instanceof ProviderTitleEditPart)) continue;
                List list = part.getChildren();
                for (EditPart part2 : list) {
                    if (!(part2 instanceof ProviderTextCompartmentEditPart)) continue;
                    ((ProviderTextCompartmentEditPart)part2).refreshFontColor();
                    ((ProviderTextCompartmentEditPart)part2).refreshLabel();
                }
            }
        }
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }

    public boolean canAttachNote() {
        return true;
    }

    public EditPolicy getEditPolicy(Object key) {
        if (key == "Canonical") {
            List l = this.getChildren();
            for (EditPart part : l) {
                if (!(part instanceof CompartmentEditPart)) continue;
                return part.getEditPolicy(key);
            }
        }
        return super.getEditPolicy(key);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ProviderShapeResizableEditPolicy();
    }

    protected List getModelChildren() {
        List children = super.getModelChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    private static boolean isVisible(View target) {
        if (target == null) {
            return true;
        }
        if (target.isVisible()) {
            EObject parent = target.eContainer();
            if (parent instanceof View) {
                return ProviderNodeEditPart.isVisible((View)parent);
            }
            return true;
        }
        return false;
    }

    private static List<Object> getSourceConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> sourceConnections = new ArrayList<Object>();
        for (Edge edge : view.getSourceEdges()) {
            View target = edge.getTarget();
            if (!edge.isVisible() || !ProviderNodeEditPart.isVisible(target)) continue;
            sourceConnections.add(edge);
        }
        return sourceConnections;
    }

    private static List<Object> getTargetConnectionsConnectingVisibleViews(View view) {
        if (!view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> targteConnections = new ArrayList<Object>();
        for (Edge edge : view.getTargetEdges()) {
            View source = edge.getSource();
            if (!edge.isVisible() || !ProviderNodeEditPart.isVisible(source)) continue;
            targteConnections.add(edge);
        }
        return targteConnections;
    }

    protected List<Object> getModelSourceConnections() {
        ArrayList<Object> children = new ArrayList<Object>(ProviderNodeEditPart.getSourceConnectionsConnectingVisibleViews((View)this.getModel()));
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    protected List<Object> getModelTargetConnections() {
        ArrayList<Object> children = new ArrayList<Object>(ProviderNodeEditPart.getTargetConnectionsConnectingVisibleViews((View)this.getModel()));
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            View view = (View)iter.next();
            if (view.eResource() != null) continue;
            iter.remove();
        }
        return children;
    }

    public void performRequest(Request request) {
        if (!this.isEditModeEnabled() && !"open".equals(request.getType())) {
            return;
        }
        if ("open".equals(request.getType())) {
            EditPart targetEditPart = this.getTargetEditPart(request);
            Command command = targetEditPart.getCommand(request);
            MNode node = (MNode)this.resolveSemanticElement();
            if (node.isRealized()) {
                if (command != null && command.canExecute()) {
                    try {
                        command.execute();
                    }
                    finally {
                        command.dispose();
                    }
                }
            } else if (command != null) {
                this.getDiagramEditDomain().getDiagramCommandStack().execute(command);
                return;
            }
            return;
        }
        super.performRequest(request);
    }
}

