/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.commands;

import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.NodeItem;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.services.DiagramFacetUtil;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.ui.internal.adapters.EdgeItemConnectionAdapter;
import com.ibm.etools.diagram.ui.internal.commands.NodeInfo;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.commands.PromptForConnectionAndEndCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class CustomPromptForConnectionAndEndCommand
extends PromptForConnectionAndEndCommand {
    private CreateConnectionRequest request;
    private ObjectAdapter endAdapter = new ObjectAdapter();

    public CustomPromptForConnectionAndEndCommand(CreateConnectionRequest request, IGraphicalEditPart containerEP) {
        super(request, containerEP);
        this.request = request;
    }

    protected List<IAdaptable> getConnectionMenuContent() {
        Object type;
        List<IElementType> validRelTypes = new ArrayList<IElementType>();
        if (this.request instanceof CreateUnspecifiedTypeConnectionRequest) {
            List allRelTypes = null;
            allRelTypes = ((CreateUnspecifiedTypeConnectionRequest)this.request).useModelingAssistantService() ? (this.isDirectionReversed() ? ModelingAssistantService.getInstance().getRelTypesOnTarget((IAdaptable)this.getKnownEnd()) : ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)this.getKnownEnd())) : ((CreateUnspecifiedTypeConnectionRequest)this.request).getElementTypes();
            if (this.isDirectionReversed()) {
                validRelTypes = allRelTypes;
            } else {
                for (IElementType rType : allRelTypes) {
                    CreateConnectionRequest req = (CreateConnectionRequest)((CreateUnspecifiedTypeConnectionRequest)this.request).getRequestForType(rType);
                    if (req == null || req.getStartCommand() == null) continue;
                    validRelTypes.add(rType);
                }
            }
        } else if (this.request instanceof CreateConnectionViewAndElementRequest) {
            if (((CreateConnectionViewAndElementRequest)this.request).getStartCommand() != null) {
                validRelTypes.add(((CreateRelationshipRequest)((CreateConnectionViewAndElementRequest)this.request).getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter().getAdapter(CreateRelationshipRequest.class)).getElementType());
            }
        } else if (this.request instanceof CreateConnectionViewRequest && ((CreateConnectionViewRequest)this.request).getStartCommand() != null && (type = ((CreateConnectionViewRequest)this.request).getConnectionViewDescriptor().getElementAdapter().getAdapter(IElementType.class)) != null) {
            validRelTypes.add((IElementType)type);
        }
        ArrayList<IAdaptable> list = new ArrayList<IAdaptable>();
        Object[] array = validRelTypes.toArray();
        int i = 0;
        while (i < array.length) {
            IElementType type2 = (IElementType)array[i];
            if (type2 instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) {
                List ids = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type2).getGeneratesItemIds();
                if (!ids.isEmpty()) {
                    HashMap reqs = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type2).getItemFacetRequirements();
                    for (String id : ids) {
                        String requiredFacet = (String)reqs.get(id);
                        if (requiredFacet != null) {
                            IProject project;
                            IFile file;
                            EditPart part = this.request.getSourceEditPart();
                            EObject eo = (EObject)part.getModel();
                            Resource res = eo.eResource();
                            if (res == null || (file = WorkspaceSynchronizer.getFile((Resource)res)) == null || !DiagramFacetUtil.hasFacet((IProject)(project = file.getProject()), (String)requiredFacet)) continue;
                            IElementType itemType = ElementTypeRegistry.getInstance().getType(id);
                            EdgeItemConnectionAdapter adapter = new EdgeItemConnectionAdapter(type2, itemType);
                            list.add(adapter);
                            continue;
                        }
                        IElementType itemType = ElementTypeRegistry.getInstance().getType(id);
                        EdgeItemConnectionAdapter adapter = new EdgeItemConnectionAdapter(type2, itemType);
                        list.add(adapter);
                    }
                } else {
                    list.add((IAdaptable)type2);
                }
            } else {
                list.add((IAdaptable)type2);
            }
            ++i;
        }
        return list;
    }

    private void filterShowInCreateMenu(List<Object> list) {
        Iterator<Object> iter = list.iterator();
        while (iter.hasNext()) {
            IElementType type = (IElementType)iter.next();
            if (!(type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) || ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).isShowInCreateMenu()) continue;
            iter.remove();
        }
    }

    protected List<Object> getEndMenuContent(Object connectionItem) {
        IElementType itemType = null;
        Object realConnectionItem = null;
        if (connectionItem instanceof EdgeItemConnectionAdapter) {
            realConnectionItem = ((EdgeItemConnectionAdapter)connectionItem).getEdgeType();
            itemType = ((EdgeItemConnectionAdapter)connectionItem).getItemType();
        } else {
            realConnectionItem = connectionItem;
        }
        List newTypes = super.getEndMenuContent(realConnectionItem);
        this.filterShowInCreateMenu(newTypes);
        ArrayList<Object> existingTypes = new ArrayList<Object>();
        boolean alreadyInDiagram = false;
        boolean hasConnection = false;
        Item item = (Item)this.getKnownEnd().getAdapter(Item.class);
        if (item != null && realConnectionItem instanceof IElementType) {
            IElementType edgeType = (IElementType)realConnectionItem;
            List references = EdgeGeneratorService.getInstance().generateExistingReferences(item, edgeType, itemType);
            for (SourceReference ref : references) {
                if (ref == SourceReference.HIDDEN) {
                    return Collections.EMPTY_LIST;
                }
                IElementType[] allNodes = ElementTypeRegistry.getInstance().getAllTypesMatching((EObject)item.getNode());
                int i = 0;
                while (i < allNodes.length) {
                    IElementType elementType = allNodes[i];
                    List targetDescriptors = EdgeResolverService.getInstance().getTargetableNodeDescriptors(elementType, ref);
                    for (ModelDescriptor desc : targetDescriptors) {
                        String fromSource;
                        if (desc == ModelDescriptor.HIDDEN) {
                            newTypes.remove(elementType);
                            continue;
                        }
                        NodeInfo info = new NodeInfo();
                        info.type = elementType;
                        info.ref = ref;
                        info.nodedesc = desc;
                        info.existing = true;
                        info.displayText = fromSource = ref.getDisplayText() == null || ref.getDisplayText().length() == 0 ? desc.getDisplayName() : ref.getDisplayText();
                        if (existingTypes.contains(info)) continue;
                        List edges = EdgeGeneratorService.getInstance().getItemsEdges(item);
                        if (edges.size() > 0) {
                            EList nodes = item.getNode().getParent().getNodes();
                            for (MNode node : nodes) {
                                if (!desc.matches(node)) continue;
                                for (MEdge edge : edges) {
                                    if (!edgeType.getId().equals(edge.getType()) || !edge.getTarget().equals(node)) continue;
                                    hasConnection = true;
                                    break;
                                }
                                alreadyInDiagram = true;
                                break;
                            }
                        }
                        if (hasConnection && alreadyInDiagram) continue;
                        existingTypes.add(info);
                    }
                    ++i;
                }
            }
        }
        if (alreadyInDiagram && hasConnection) {
            return Collections.EMPTY_LIST;
        }
        if (existingTypes.size() > 0) {
            return existingTypes;
        }
        return newTypes;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        List resultList;
        PopupMenu popup = this.createPopupMenu();
        if (popup == null) {
            return CommandResult.newErrorCommandResult((String)this.getLabel());
        }
        this.setPopupMenu(popup);
        if (!this.getPopupMenu().show((Control)this.getParentShell())) {
            progressMonitor.setCanceled(true);
            return CommandResult.newCancelledCommandResult();
        }
        Object result = this.getPopupMenu().getResult();
        if (result instanceof List && (resultList = (List)result).size() == 2) {
            Object o = resultList.get(0);
            if (o instanceof EdgeItemConnectionAdapter) {
                IElementType itemType = ((EdgeItemConnectionAdapter)o).getItemType();
                o = ((EdgeItemConnectionAdapter)o).getEdgeType();
                this.request.getExtendedData().put("Selected Item Type Parameter Key", itemType);
            }
            this.getConnectionAdapter().setObject(o);
            Object targetResult = resultList.get(1);
            if (targetResult instanceof NodeInfo) {
                if (((NodeInfo)targetResult).existing) {
                    HashMap<String, Boolean> m = new HashMap<String, Boolean>();
                    m.put("existing node", Boolean.TRUE);
                    m.put("target node descriptor", (Boolean)((NodeInfo)targetResult).nodedesc);
                    m.put("source reference", (Boolean)((NodeInfo)targetResult).ref);
                    m.put("existing edge", Boolean.TRUE);
                    if (this.request.getExtendedData() != null) {
                        this.request.getExtendedData().putAll(m);
                    } else {
                        this.request.setExtendedData(m);
                    }
                    MNode alreadyInDiagramNode = null;
                    ModelDescriptor descriptor = ((NodeInfo)targetResult).nodedesc;
                    Item item = (Item)this.getKnownEnd().getAdapter(Item.class);
                    EList nodes = item.getNode().getParent().getNodes();
                    for (MNode node : nodes) {
                        if (!descriptor.matches(node)) continue;
                        alreadyInDiagramNode = node;
                        break;
                    }
                    if (alreadyInDiagramNode != null) {
                        ((ObjectAdapter)this.getEndAdapter()).setObject(alreadyInDiagramNode);
                    } else {
                        ((ObjectAdapter)this.getEndAdapter()).setObject((Object)((NodeInfo)targetResult).type);
                    }
                }
            } else {
                EditPart sourceEP = this.request.getSourceEditPart();
                NodeItem item = (NodeItem)sourceEP.getAdapter(NodeItem.class);
                if (item != null) {
                    SourceReference ref = new SourceReference((Item)item, (IElementType)o);
                    ref.setNewreference(true);
                    this.request.getExtendedData().put("existing edge", Boolean.TRUE);
                    this.request.getExtendedData().put("source reference", ref);
                }
                ((ObjectAdapter)this.getEndAdapter()).setObject(targetResult);
            }
            return CommandResult.newOKCommandResult();
        }
        return CommandResult.newErrorCommandResult((String)this.getLabel());
    }

    public IAdaptable getEndAdapter() {
        return this.endAdapter;
    }

    private EditPart getKnownEnd() {
        return this.request.getSourceEditPart();
    }

    protected ILabelProvider getEndLabelProvider() {
        return new CustomEndLabelProvider();
    }

    protected ILabelProvider getConnectionAndEndLabelProvider(Object connectionItem) {
        return new CustomConnectionAndEndLabelProvider(connectionItem);
    }

    protected ILabelProvider getConnectionLabelProvider() {
        return new CustomConnectionLabelProvider();
    }

    protected PopupMenu createPopupMenu() {
        final List<IAdaptable> connectionMenuContent = this.getConnectionMenuContent();
        if (connectionMenuContent == null || connectionMenuContent.isEmpty()) {
            return null;
        }
        if (connectionMenuContent.size() == 1) {
            List<Object> menuContent = this.getEndMenuContent(connectionMenuContent.get(0));
            if (menuContent == null || menuContent.isEmpty()) {
                return null;
            }
            ILabelProvider labelProvider = this.getConnectionAndEndLabelProvider(connectionMenuContent.get(0));
            return new PopupMenu(menuContent, labelProvider){

                public Object getResult() {
                    Object endResult = super.getResult();
                    if (endResult == null) {
                        return null;
                    }
                    ArrayList<Object> resultList = new ArrayList<Object>(2);
                    resultList.add(connectionMenuContent.get(0));
                    resultList.add(endResult);
                    return resultList;
                }
            };
        }
        ArrayList<PopupMenu.CascadingMenu> menuContent = new ArrayList<PopupMenu.CascadingMenu>();
        HashMap<IAdaptable, List<Object>> map = new HashMap<IAdaptable, List<Object>>();
        for (IAdaptable connectionItem : connectionMenuContent) {
            List<Object> subMenuContent = this.getEndMenuContent(connectionItem);
            if (subMenuContent.isEmpty()) continue;
            map.put(connectionItem, subMenuContent);
            PopupMenu subMenu = new PopupMenu(subMenuContent, this.getEndLabelProvider());
            menuContent.add(new PopupMenu.CascadingMenu((Object)connectionItem, subMenu));
        }
        if (menuContent.size() == 1) {
            Iterator itr = map.keySet().iterator();
            final Object cItem = itr.next();
            ILabelProvider labelProvider = this.getEndLabelProvider();
            List subMenuContent = (List)map.get(cItem);
            return new PopupMenu(subMenuContent, labelProvider){

                public Object getResult() {
                    Object endResult = super.getResult();
                    if (endResult == null) {
                        return null;
                    }
                    ArrayList<Object> resultList = new ArrayList<Object>(2);
                    resultList.add(cItem);
                    resultList.add(endResult);
                    return resultList;
                }
            };
        }
        if (!menuContent.isEmpty()) {
            return new PopupMenu(menuContent, this.getConnectionLabelProvider());
        }
        return null;
    }

    protected class CustomConnectionAndEndLabelProvider
    extends PromptForConnectionAndEndCommand.ConnectionAndEndLabelProvider {
        public CustomConnectionAndEndLabelProvider(Object connectionItem) {
            super((PromptForConnectionAndEndCommand)CustomPromptForConnectionAndEndCommand.this, connectionItem);
        }

        public String getText(Object element) {
            if (element instanceof NodeInfo) {
                return ((NodeInfo)element).displayText;
            }
            if (element instanceof IElementType) {
                return NLS.bind((String)Messages.TargetItemToNewNodeX, (Object)((IElementType)element).getDisplayName());
            }
            return super.getText(element);
        }

        public Image getImage(Object object) {
            if (object instanceof NodeInfo) {
                IElementType type = ((NodeInfo)object).type;
                return IconService.getInstance().getIcon((IAdaptable)type);
            }
            return super.getImage(object);
        }
    }

    protected class CustomConnectionLabelProvider
    extends PromptForConnectionAndEndCommand.ConnectionLabelProvider {
        protected CustomConnectionLabelProvider() {
            super((PromptForConnectionAndEndCommand)CustomPromptForConnectionAndEndCommand.this);
        }

        public String getText(Object element) {
            String theInputStr = null;
            String text = null;
            theInputStr = CustomPromptForConnectionAndEndCommand.this.isDirectionReversed() ? Messages.Popup_CreateXFrom : Messages.Popup_CreateXTo;
            text = element instanceof IElementType ? ((IElementType)element).getDisplayName() : (element instanceof EdgeItemConnectionAdapter ? ParserService.getInstance().getPrintString((IAdaptable)((EdgeItemConnectionAdapter)element)) : element.toString());
            text = NLS.bind((String)theInputStr, (Object)text);
            return text;
        }

        public Image getImage(Object object) {
            if (object instanceof NodeInfo) {
                IElementType type = ((NodeInfo)object).type;
                return IconService.getInstance().getIcon((IAdaptable)type);
            }
            if (object instanceof EdgeItemConnectionAdapter) {
                return IconService.getInstance().getIcon((IAdaptable)((EdgeItemConnectionAdapter)object));
            }
            return super.getImage(object);
        }
    }

    protected class CustomEndLabelProvider
    extends PromptForConnectionAndEndCommand.EndLabelProvider {
        protected CustomEndLabelProvider() {
            super((PromptForConnectionAndEndCommand)CustomPromptForConnectionAndEndCommand.this);
        }

        public String getText(Object element) {
            if (element instanceof NodeInfo) {
                return ((NodeInfo)element).displayText;
            }
            if (element instanceof IElementType) {
                return ((IElementType)element).getDisplayName();
            }
            return element.toString();
        }

        public Image getImage(Object object) {
            if (object instanceof NodeInfo) {
                IElementType type = ((NodeInfo)object).type;
                return IconService.getInstance().getIcon((IAdaptable)type);
            }
            return super.getImage(object);
        }
    }
}

