/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.celleditor;

import com.ibm.etools.diagram.model.internal.emf.IPropertyHolder;
import com.ibm.etools.diagram.model.internal.emf.IRealizable;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.Property;
import com.ibm.etools.diagram.ui.internal.adapters.ResourceSelectionDialogAdapter;
import com.ibm.etools.diagram.ui.internal.celleditor.TextDialogCellEditor;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import com.ibm.etools.diagram.ui.internal.services.PropertyDisplayService;
import java.util.Collections;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TextEditPartDialogCellEditor
extends TextDialogCellEditor {
    private boolean isDialogOpen;
    private Object value;
    private final IPropertyHolder propertyHolder;
    private ResourceSelectionDialogAdapter resourcesSelectionDialog;

    public TextEditPartDialogCellEditor(Composite composite, IPropertyHolder propertyHolder, ResourceSelectionDialogAdapter adapter) {
        this.propertyHolder = propertyHolder;
        this.resourcesSelectionDialog = adapter;
        if (this.resourcesSelectionDialog != null && this.resourcesSelectionDialog.getDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Collections.EMPTY_MAP) == null) {
            this.resourcesSelectionDialog = null;
        }
        this.create(composite);
    }

    protected void fireEditorValueChanged(boolean oldValidState, boolean newValidState) {
        super.fireEditorValueChanged(oldValidState, newValidState);
    }

    @Override
    protected void setErrorMessage(String message) {
        super.setErrorMessage(message);
    }

    protected Button createButton(Composite parent) {
        Button button = new Button(parent, 0x800000);
        button.setText("...");
        button.setToolTipText(Messages.TextEditPartDialogCellEditor_0);
        if (this.resourcesSelectionDialog == null) {
            button.setVisible(false);
        }
        return button;
    }

    @Override
    protected Object openDialogBox(Control cellEditorWindow) {
        Object o;
        Object[] result;
        SelectionDialog dialog;
        int i;
        this.isDialogOpen = true;
        if (this.resourcesSelectionDialog != null && (i = (dialog = this.resourcesSelectionDialog.getDialog(cellEditorWindow.getShell(), null)).open()) == 0 && (result = dialog.getResult()).length > 0 && (o = result[0]) != null) {
            return o;
        }
        this.isDialogOpen = false;
        return null;
    }

    protected void updateContents(Object value) {
        this.value = value;
        if (this.defaultText != null) {
            if (value != null) {
                if (value instanceof String) {
                    this.defaultText.setText(value.toString());
                } else {
                    String resultString = null;
                    if (this.resourcesSelectionDialog != null) {
                        resultString = this.resourcesSelectionDialog.getStringForResult(value);
                    }
                    if (resultString == null) {
                        this.defaultText.setText("");
                    } else {
                        this.defaultText.setText(resultString);
                    }
                }
            } else {
                this.defaultText.setText("");
            }
        }
    }

    @Override
    protected Object doGetValue() {
        if (this.value instanceof String) {
            Property title = this.propertyHolder.getTitleProperty();
            String reconstituted = PropertyDisplayService.getInstance().parseEditedString(title, this.defaultText.getText());
            if (reconstituted == null) {
                reconstituted = this.defaultText.getText();
            }
            return reconstituted;
        }
        return this.value;
    }

    @Override
    protected void doSetValue(Object value) {
        this.value = value;
        if (!(value instanceof String)) {
            Property title = this.propertyHolder.getTitleProperty();
            String reconstituted = PropertyDisplayService.getInstance().parseEditedString(title, this.defaultText.getText());
            if (reconstituted == null) {
                reconstituted = this.defaultText.getText();
            }
            super.doSetValue(reconstituted);
        } else {
            super.doSetValue(value);
        }
    }

    public void activate() {
        super.activate();
        this.editor.layout(true);
    }

    @Override
    protected void handleDeactivate(Event event) {
        if (!this.isDialogOpen) {
            boolean oldValidState = this.isValueValid();
            if (oldValidState) {
                this.valueChanged(oldValidState, true);
                this.fireApplyEditorValue();
            } else {
                this.fireCancelEditor();
            }
        }
    }

    public void setOriginalValue(String editText) {
        this.setValue(editText);
    }

    public Text getText() {
        return this.defaultText;
    }

    public void setFont(Font font) {
        this.defaultText.setFont(font);
    }

    public Button getButton() {
        return this.button;
    }

    protected void focusLost() {
        super.focusLost();
    }

    @Override
    protected void addFieldDecorators(ControlDecoration field) {
        if (field == null) {
            return;
        }
        boolean addDecorator = false;
        if (this.propertyHolder instanceof IRealizable) {
            boolean bl = addDecorator = !((IRealizable)this.propertyHolder).isRealized();
        }
        if (this.propertyHolder instanceof Item) {
            addDecorator = false;
        }
        if (addDecorator) {
            FieldDecoration d = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
            field.setImage(d.getImage());
            field.setDescriptionText(Messages.TextEditPartDialogCellEditor_1);
        }
    }
}

