/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.ui.internal.actions.support;

import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import com.ibm.etools.diagram.model.internal.commands.support.ResourceTree;
import com.ibm.etools.diagram.ui.internal.nls.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourcesTreeLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        if (element instanceof ResourceTree) {
            ResourceTree tree = (ResourceTree)element;
            Image image = IconService.getInstance().getIcon((IAdaptable)tree.getResource());
            if (image == null && tree.getResource() != null) {
                WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
                return provider.getImage(tree.getResource().getResource());
            }
            return image;
        }
        if (element instanceof ResourceDescriptor) {
            ResourceDescriptor desc = (ResourceDescriptor)element;
            Image image = IconService.getInstance().getIcon((IAdaptable)desc);
            if (image == null) {
                WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
                return provider.getImage(desc.getResource());
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ResourceTree) {
            ResourceTree tree = (ResourceTree)element;
            if (tree.getResource() == null) {
                return "";
            }
            String text = tree.getResource().getDisplayText();
            if (text == null && tree.getResource() != null) {
                WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
                return NLS.bind((String)Messages.DeleteFileX, (Object)provider.getText(tree.getResource().getResource()));
            }
            return text;
        }
        if (element instanceof ResourceDescriptor) {
            ResourceDescriptor desc = (ResourceDescriptor)element;
            String text = desc.getDisplayText();
            if (text == null) {
                WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
                return NLS.bind((String)Messages.DeleteFileX, (Object)provider.getText(desc.getResource()));
            }
            return text;
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

