/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.util;

import com.ibm.etools.diagram.model.internal.Debug;
import com.ibm.etools.diagram.model.internal.nls.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public final class ModelUpdateUtils {
    private ModelUpdateUtils() {
    }

    public static final void updateModelNoUndo(Resource model, Runnable runnable, boolean unprotected) {
        ModelUpdateUtils.updateModelNoUndo(null, model, runnable, unprotected);
    }

    public static final void updateModelNoUndo(IOperationHistory history, Resource model, Runnable runnable, boolean unprotected) {
        if (model == null) {
            return;
        }
        if (model.getResourceSet() == null) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)model);
        if (domain != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (unprotected) {
                map.put("unprotected", Boolean.TRUE);
                map.put("silent", Boolean.FALSE);
            } else {
                map.put("unprotected", Boolean.FALSE);
            }
            map.put("no_undo", Boolean.TRUE);
            ModelUpdater updater = new ModelUpdater(domain, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)model)), map, runnable);
            try {
                if (history != null) {
                    new DefaultOperationHistory().execute((IUndoableOperation)updater, (IProgressMonitor)new NullProgressMonitor(), null);
                } else if (unprotected) {
                    new DefaultOperationHistory().execute((IUndoableOperation)updater, (IProgressMonitor)new NullProgressMonitor(), null);
                } else {
                    new DefaultOperationHistory().execute((IUndoableOperation)updater, (IProgressMonitor)new NullProgressMonitor(), null);
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<IElementType> convertIdsToElements(List<String> ids) {
        ArrayList<IElementType> edgeTypes = new ArrayList<IElementType>(ids.size());
        for (String id : ids) {
            IElementType element = ElementTypeRegistry.getInstance().getType(id);
            if (element == null) {
                Debug.println("Warning: Specified element type id \"" + id + "\" does not match a IElementType in the registry, ignoring", Debug.DiagramTraceOptions.WARNING, null);
                continue;
            }
            edgeTypes.add(element);
        }
        return edgeTypes;
    }

    private static final class ModelUpdater
    extends AbstractTransactionalCommand {
        private final Runnable runnable;

        public ModelUpdater(TransactionalEditingDomain domain, List<IFile> affectedFiles, Map<String, Boolean> options, Runnable runnable) {
            super(domain, Messages.UpdateModelToResourceChanges, options, affectedFiles);
            this.runnable = runnable;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.runnable.run();
            return CommandResult.newOKCommandResult();
        }

        public boolean canRedo() {
            return false;
        }

        public boolean canUndo() {
            return false;
        }
    }
}

