/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.Compartment;
import com.ibm.etools.diagram.model.internal.model.DiagramModelElementTypeFactory;
import com.ibm.etools.diagram.model.internal.operations.GetNodeItemsOperation;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.providers.INodeItemProvider;
import com.ibm.etools.diagram.model.internal.services.DiagramFacetUtil;
import com.ibm.etools.diagram.model.internal.services.configuration.NodeTypesProviderConfiguration;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class NodeItemService
extends Service {
    private static NodeItemService service = null;

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected NodeItemService() {
    }

    protected NodeItemService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    protected NodeItemService(boolean optimized) {
        super(optimized);
    }

    public static NodeItemService getInstance() {
        if (service == null) {
            service = new NodeItemService(false, false);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "NodeItemProvider");
        }
        return service;
    }

    protected Object getCachingKey(IOperation operation) {
        return ((GetProvidersOperation)operation).getElement();
    }

    public List<String> getValidNodeItemsTypes(Compartment node) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        List providers = this.getAllProviders();
        for (ProviderDescriptor descriptor : providers) {
            if (!descriptor.isApplicable(node)) continue;
            results.addAll(descriptor.getProvidableNodeTypeIds());
        }
        IFile file = WorkspaceSynchronizer.getFile((Resource)node.eResource());
        IProject project = file.getProject();
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            List<String> requiredFacets;
            String id = (String)iter.next();
            IElementType type = ElementTypeRegistry.getInstance().getType(id);
            if (!(type instanceof DiagramModelElementTypeFactory.DiagramModelSpecializationType) || (requiredFacets = ((DiagramModelElementTypeFactory.DiagramModelSpecializationType)type).getRequiresAnyFacetIds()).isEmpty()) continue;
            boolean hasFacet = false;
            for (String facetid : requiredFacets) {
                if (!DiagramFacetUtil.hasFacet(project, facetid)) continue;
                hasFacet = true;
                break;
            }
            if (hasFacet) continue;
            iter.remove();
        }
        return new ArrayList<String>(results);
    }

    public List<String> getValidSubItemsTypes(Compartment c, String nodeItemTypeId) {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        List providers = this.getAllProviders();
        for (ProviderDescriptor descriptor : providers) {
            if (!descriptor.isApplicable(c)) continue;
            results.addAll(descriptor.getSubItemTypeIds(nodeItemTypeId));
        }
        return new ArrayList<String>(results);
    }

    public void refreshNode(final Compartment node) {
        if (node.getType() == null) {
            return;
        }
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(node));
        for (final INodeItemProvider provider : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    provider.refreshNodeItems(node);
                }
            });
        }
    }

    public void compartmentExpanded(final Compartment node) {
        if (node.getType() == null) {
            return;
        }
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(node));
        for (final INodeItemProvider provider : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    provider.compartmentExpanded(node);
                }
            });
        }
    }

    public void compartmentCollapsed(final Compartment node) {
        if (node.getType() == null) {
            return;
        }
        List list = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(node));
        for (final INodeItemProvider provider : list) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    provider.compartmentCollapsed(node);
                }
            });
        }
    }

    protected static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private final NodeTypesProviderConfiguration providerConfiguration;
        private final Map<String, List<String>> nodeTypeIds;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = NodeTypesProviderConfiguration.parse(element);
            assert (this.providerConfiguration != null);
            this.nodeTypeIds = new HashMap<String, List<String>>();
            IConfigurationElement[] edgeTypesContainer = element.getChildren("providesNodeItemTypes");
            int i = 0;
            while (i < edgeTypesContainer.length) {
                IConfigurationElement edgeTypes = edgeTypesContainer[i];
                IConfigurationElement[] edgeTypeArray = edgeTypes.getChildren("nodeItemType");
                int j = 0;
                while (j < edgeTypeArray.length) {
                    IConfigurationElement edgeType = edgeTypeArray[j];
                    ArrayList<String> subItems = new ArrayList<String>();
                    IConfigurationElement[] subItemElements = edgeType.getChildren("subItemType");
                    int k = 0;
                    while (k < subItemElements.length) {
                        IConfigurationElement subItem = subItemElements[k];
                        subItems.add(subItem.getAttribute("id"));
                        ++k;
                    }
                    this.nodeTypeIds.put(edgeType.getAttribute("id"), subItems);
                    ++j;
                }
                ++i;
            }
        }

        public boolean provides(IOperation operation) {
            return this.isSupportedInExtention(operation);
        }

        public Collection<String> getProvidableNodeTypeIds() {
            return this.nodeTypeIds.keySet();
        }

        public Collection<String> getProvidableSubItemTypeIds() {
            ArrayList<String> list = new ArrayList<String>();
            Collection<List<String>> values = this.nodeTypeIds.values();
            for (List<String> subItems : values) {
                list.addAll(subItems);
            }
            return list;
        }

        public boolean isApplicable(Object type) {
            return this.providerConfiguration.supports(type);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetNodeItemsOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.getProvidableNodeTypeIds().contains(((IElementType)getConfigOp.getElement()).getId());
            }
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.isApplicable(getConfigOp.getElement());
            }
            return false;
        }

        public Collection<String> getSubItemTypeIds(String nodeItemTypeId) {
            Collection c = this.nodeTypeIds.get(nodeItemTypeId);
            return c == null ? Collections.EMPTY_LIST : c;
        }
    }
}

