/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.CommonElement;
import com.ibm.etools.diagram.model.internal.operations.GetProvidersOperation;
import com.ibm.etools.diagram.model.internal.providers.IMigrationProvider;
import com.ibm.etools.diagram.model.internal.services.configuration.ObjectDescriptorProviderConfiguration;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.notation.Diagram;

public class MigrationService
extends Service {
    private static MigrationService service = null;

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected MigrationService() {
    }

    protected MigrationService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    protected MigrationService(boolean optimized) {
        super(optimized);
    }

    public static MigrationService getInstance() {
        if (service == null) {
            service = new MigrationService(true, true);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "MigrationProvider");
        }
        return service;
    }

    public void migrateElement(final CommonElement element, final String oldVersion) {
        if (element == null) {
            return;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(element));
        for (final IMigrationProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    provider.migrateElement(element, oldVersion);
                }
            });
        }
    }

    public void postProcessDiagram(final Diagram diagram, final String oldVersion) {
        if (diagram == null) {
            return;
        }
        List providers = this.execute(ExecutionStrategy.FORWARD, new GetProvidersOperation(diagram));
        for (final IMigrationProvider provider : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(provider){

                public void doRun() throws Exception {
                    provider.postProcessDiagram(diagram, oldVersion);
                }
            });
        }
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private ObjectDescriptorProviderConfiguration providerConfiguration;

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            this.providerConfiguration = ObjectDescriptorProviderConfiguration.parse(element);
            assert (this.providerConfiguration != null);
        }

        public boolean provides(IOperation operation) {
            return this.isSupportedInExtention(operation);
        }

        private boolean isSupportedInExtention(IOperation operation) {
            if (operation instanceof GetProvidersOperation) {
                GetProvidersOperation getConfigOp = (GetProvidersOperation)operation;
                return this.providerConfiguration.supports(getConfigOp.getElement());
            }
            return false;
        }
    }
}

