/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.services;

import com.ibm.etools.diagram.model.internal.DiagramModelPlugin;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.operations.GetEdgeResolversOperation;
import com.ibm.etools.diagram.model.internal.providers.IEdgeResolverProvider;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.util.ModelUpdateUtils;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.Service;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;

public class EdgeResolverService
extends Service {
    private static EdgeResolverService service = null;
    private HashMap<GetEdgeResolversOperation, GetEdgeResolversOperation> operationsCache = null;

    protected Service.ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected EdgeResolverService() {
    }

    protected EdgeResolverService(boolean optimized, boolean optimistic) {
        super(optimized, optimistic);
    }

    protected EdgeResolverService(boolean optimized) {
        super(optimized);
    }

    public static EdgeResolverService getInstance() {
        if (service == null) {
            service = new EdgeResolverService(true, true);
            service.configureProviders(DiagramModelPlugin.getPluginId(), "EdgeResolverProvider");
        }
        return service;
    }

    private GetEdgeResolversOperation getOp(String targetNodeType, String edgeType) {
        GetEdgeResolversOperation cachedop;
        GetEdgeResolversOperation op = new GetEdgeResolversOperation(targetNodeType, edgeType);
        if (this.operationsCache == null) {
            this.operationsCache = new HashMap();
        }
        if ((cachedop = this.operationsCache.get(op)) == null) {
            this.operationsCache.put(op, op);
            return op;
        }
        return cachedop;
    }

    public List<IElementType> getResolvableEdgeTypes(IElementType node) {
        ArrayList<String> ids = new ArrayList<String>();
        List providers = this.getAllProviders();
        for (ProviderDescriptor descriptor : providers) {
            if (!descriptor.isApplicable(node)) continue;
            ids.addAll(descriptor.getResolvableEdgeTypes());
        }
        return ModelUpdateUtils.convertIdsToElements(ids);
    }

    public List<IElementType> getResolvableEdgeTypes(List<IElementType> possibleEdges, IElementType node) {
        List<IElementType> resolvable = this.getResolvableEdgeTypes(node);
        resolvable.retainAll(possibleEdges);
        return resolvable;
    }

    public boolean isEdgeTypeValid(IElementType edge, IElementType node) {
        List<IElementType> resolvable = this.getResolvableEdgeTypes(node);
        return resolvable.contains(edge);
    }

    public boolean isResolvable(final MNode targetNode, final SourceReference reference) {
        if (reference.getEdgeType() == null) {
            return false;
        }
        List providers = this.execute(ExecutionStrategy.FIRST, this.getOp(targetNode.getType(), reference.getEdgeType().getId()));
        boolean resolvable = providers.size() != 0;
        final Object[] resultHolder = new Object[1];
        for (final IEdgeResolverProvider edgeResolver : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(edgeResolver){

                public void doRun() throws Exception {
                    resultHolder[0] = Boolean.FALSE;
                    resultHolder[0] = edgeResolver.isResolvable(targetNode, reference) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            resolvable &= ((Boolean)resultHolder[0]).booleanValue();
        }
        return resolvable;
    }

    public List getTargetableNodeDescriptors(final IElementType targetNodeType, final SourceReference reference) {
        final ArrayList targetDescriptors = new ArrayList();
        List providers = this.execute(ExecutionStrategy.FORWARD, this.getOp(targetNodeType.getId(), reference.getEdgeType().getId()));
        for (final IEdgeResolverProvider edgeResolver : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(edgeResolver){

                public void doRun() throws Exception {
                    targetDescriptors.addAll(edgeResolver.getTargetableNodeDescriptors(targetNodeType, reference));
                }
            });
        }
        return targetDescriptors;
    }

    public void instantiateEdge(final MEdge node, final SourceReference reference, final MNode target) {
        List providers = this.execute(ExecutionStrategy.FORWARD, this.getOp(target.getType(), reference.getEdgeType().getId()));
        for (final IEdgeResolverProvider edgeResolver : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(edgeResolver){

                public void doRun() throws Exception {
                    edgeResolver.instantiateEdge(node, reference, target);
                }
            });
        }
    }

    public void instantiateNode(final MNode target, final SourceReference reference, final ModelDescriptor descriptor) {
        List providers = this.execute(ExecutionStrategy.FORWARD, this.getOp(target.getType(), reference.getEdgeType().getId()));
        for (final IEdgeResolverProvider edgeResolver : providers) {
            SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(edgeResolver){

                public void doRun() throws Exception {
                    edgeResolver.instantiateNode(reference, target, descriptor);
                }
            });
        }
    }

    private static class ProviderDescriptor
    extends Service.ProviderDescriptor {
        private final List<String> edgeTypesIds = new ArrayList<String>();
        private final List<String> generatesAndResolvesNodeIds = new ArrayList<String>();

        public ProviderDescriptor(IConfigurationElement element) {
            super(element);
            IConfigurationElement[] edgeTypesContainer = element.getChildren("resolvesEdgeTypes");
            int i = 0;
            while (i < edgeTypesContainer.length) {
                IConfigurationElement edgeTypes = edgeTypesContainer[i];
                IConfigurationElement[] edgeTypeArray = edgeTypes.getChildren("edgeType");
                int j = 0;
                while (j < edgeTypeArray.length) {
                    IConfigurationElement edgeType = edgeTypeArray[j];
                    this.edgeTypesIds.add(edgeType.getAttribute("id"));
                    ++j;
                }
                ++i;
            }
            IConfigurationElement[] generatesContainer = element.getChildren("generatesAndResolvesForNodeTypes");
            int i2 = 0;
            while (i2 < generatesContainer.length) {
                IConfigurationElement nodeTypes = generatesContainer[i2];
                IConfigurationElement[] nodeTypesArray = nodeTypes.getChildren("nodeType");
                int j = 0;
                while (j < nodeTypesArray.length) {
                    IConfigurationElement nodeType = nodeTypesArray[j];
                    this.generatesAndResolvesNodeIds.add(nodeType.getAttribute("id"));
                    ++j;
                }
                ++i2;
            }
        }

        public List<String> getResolvableEdgeTypes() {
            return this.edgeTypesIds;
        }

        public boolean provides(IOperation operation) {
            if (operation instanceof GetEdgeResolversOperation) {
                GetEdgeResolversOperation op = (GetEdgeResolversOperation)operation;
                String type = op.getTargetNodeType();
                boolean applicable = this.generatesAndResolvesNodeIds.contains(type);
                if (!applicable) {
                    return false;
                }
                applicable = this.edgeTypesIds.contains(op.getEdgeType());
                return applicable;
            }
            return false;
        }

        public List<String> getGeneratedEdgeTypes() {
            return this.edgeTypesIds;
        }

        public boolean isApplicable(Object type) {
            if (type instanceof IElementType) {
                IElementType eType = (IElementType)type;
                return this.generatesAndResolvesNodeIds.contains(eType.getId());
            }
            return false;
        }
    }
}

