/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.metamodel;

import com.ibm.etools.diagram.model.internal.metamodel.IDisposeListener;
import com.ibm.etools.model2.base.DelegatingSafeRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.ecore.EObject;

public class ModelLifecycleManager {
    private static final ModelLifecycleManager INSTANCE = new ModelLifecycleManager();
    private Map<EObject, List> listenersToElementMap = new HashMap<EObject, List>();

    private ModelLifecycleManager() {
    }

    public static final ModelLifecycleManager getInstance() {
        return INSTANCE;
    }

    public void addDisposeListener(IDisposeListener disposeListener, EObject modelObject) {
        ArrayList<IDisposeListener> listeners = this.listenersToElementMap.get(modelObject);
        if (listeners == null) {
            listeners = new ArrayList<IDisposeListener>();
            this.listenersToElementMap.put(modelObject, listeners);
        }
        listeners.add(disposeListener);
    }

    public void disposeObject(EObject modelObject) {
        List listeners = this.listenersToElementMap.get(modelObject);
        if (listeners != null) {
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                final IDisposeListener listener = (IDisposeListener)iter.next();
                SafeRunner.run((ISafeRunnable)new DelegatingSafeRunnable(listener){

                    public void doRun() throws Exception {
                        listener.dispose();
                    }
                });
                iter.remove();
            }
            if (listeners.isEmpty()) {
                this.listenersToElementMap.remove(modelObject);
            }
        }
    }
}

