/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.edithelpers;

import com.ibm.etools.diagram.model.internal.commands.CreateEdgeCommand;
import com.ibm.etools.diagram.model.internal.commands.CreateResourceNodeCommand;
import com.ibm.etools.diagram.model.internal.edithelpers.AbstractProviderEditHelper;
import com.ibm.etools.diagram.model.internal.emf.DiagramModelPackage;
import com.ibm.etools.diagram.model.internal.emf.Item;
import com.ibm.etools.diagram.model.internal.emf.MEdge;
import com.ibm.etools.diagram.model.internal.emf.MNode;
import com.ibm.etools.diagram.model.internal.emf.Model;
import com.ibm.etools.diagram.model.internal.emf.util.Model2Type;
import com.ibm.etools.diagram.model.internal.providers.ModelDescriptor;
import com.ibm.etools.diagram.model.internal.providers.SourceReference;
import com.ibm.etools.diagram.model.internal.requests.DestroyNonModelElementRequest;
import com.ibm.etools.diagram.model.internal.services.ConfiguratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeGeneratorService;
import com.ibm.etools.diagram.model.internal.services.EdgeResolverService;
import com.ibm.etools.diagram.model.internal.services.ReverseEngineerConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.GetEditContextCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;

public class ContainerEditHelper
extends AbstractProviderEditHelper {
    protected ICommand getCreateCommand(CreateElementRequest req) {
        ISpecializationType specialization;
        Object cmd = UnexecutableCommand.INSTANCE;
        this.setDefaultContainmentFeature(req);
        IElementType type = req.getElementType();
        if (type instanceof ISpecializationType && (specialization = (ISpecializationType)type).isSpecializationOf(Model2Type.RESOURCENODE)) {
            cmd = new CreateResourceNodeCommand(req);
        }
        return cmd;
    }

    protected ICommand getEditContextCommand(GetEditContextRequest req) {
        GetEditContextCommand result = null;
        IEditCommandRequest editRequest = req.getEditCommandRequest();
        if (editRequest instanceof CreateElementRequest) {
            result = new GetEditContextCommand(req);
            EObject container = ((CreateElementRequest)editRequest).getContainer();
            if (container instanceof Diagram) {
                EObject element = ((Diagram)container).getElement();
                if (element == null) {
                    EObject annotation = ((Diagram)container).eContainer();
                    if (annotation != null) {
                        element = annotation.eContainer();
                    }
                } else {
                    container = element instanceof Model ? ((Model)element).getDiagram() : element;
                }
            }
            result.setEditContext((Object)container);
        }
        return result;
    }

    protected void setDefaultContainmentFeature(CreateElementRequest req) {
        if (req.getContainmentFeature() == null) {
            boolean setFeature = false;
            if (req.getElementType() instanceof ISpecializationType) {
                ISpecializationType specializationType = (ISpecializationType)req.getElementType();
                if (specializationType.isSpecializationOf(Model2Type.NODEITEM) || specializationType.isSpecializationOf(Model2Type.SUBITEM)) {
                    req.setContainmentFeature(DiagramModelPackage.eINSTANCE.getCompartment_Items());
                    setFeature = true;
                }
                if (specializationType.isSpecializationOf(Model2Type.EDGE)) {
                    req.setContainmentFeature(DiagramModelPackage.eINSTANCE.getModel_Edges());
                    setFeature = true;
                }
            }
            if (!setFeature) {
                req.setContainmentFeature(DiagramModelPackage.eINSTANCE.getMDiagram_Nodes());
            }
        }
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        ISpecializationType specializationType;
        this.setDefaultContainmentFeature((CreateElementRequest)req);
        IElementType elementType = req.getElementType();
        if (elementType instanceof ISpecializationType && (specializationType = (ISpecializationType)elementType).isSpecializationOf(Model2Type.EDGE)) {
            return new CreateEdgeCommand(req);
        }
        return super.getCreateRelationshipCommand(req);
    }

    protected ICommand getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return super.getDestroyReferenceCommand(req);
    }

    private ICommand deleteEdges(List<MEdge> edges, List selection, Map parameters) {
        CompositeCommand compositeDeleteCommand = new CompositeCommand(null);
        for (MEdge edge : edges) {
            if (selection != null && selection.contains(edge) || edge.eResource() == null) continue;
            IElementType type = edge.getElementType();
            DestroyElementRequest req = new DestroyElementRequest((EObject)edge, false);
            req.getParameters().putAll(parameters);
            ICommand cmd = type.getEditHelper().getEditCommand((IEditCommandRequest)req);
            compositeDeleteCommand.compose((IUndoableOperation)cmd);
        }
        return compositeDeleteCommand.size() == 0 ? null : compositeDeleteCommand;
    }

    @Override
    protected ICommand getInsteadCommand(IEditCommandRequest request) {
        if (request instanceof DestroyNonModelElementRequest) {
            DestroyNonModelElementRequest req = (DestroyNonModelElementRequest)request;
            CompositeCommand destroyElement = new CompositeCommand(null);
            destroyElement.add((IUndoableOperation)IdentityCommand.INSTANCE);
            EObject o = req.getElementToDestroy();
            List selection = (List)req.getParameter("selected resources");
            if (o instanceof MNode) {
                MNode nodeToDestroy = (MNode)o;
                ArrayList<MEdge> edges = new ArrayList<MEdge>((Collection<MEdge>)nodeToDestroy.getInput());
                edges.addAll((Collection<MEdge>)nodeToDestroy.getOutput());
                destroyElement.compose((IUndoableOperation)this.deleteEdges(edges, selection, req.getParameters()));
            } else if (o instanceof Item) {
                List<MEdge> edges = EdgeGeneratorService.getInstance().getItemsEdges((Item)o);
                destroyElement.compose((IUndoableOperation)this.deleteEdges(edges, selection, req.getParameters()));
            }
            return destroyElement;
        }
        return super.getInsteadCommand(request);
    }

    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        CompositeCommand destroyElement = new CompositeCommand(null);
        EObject o = req.getElementToDestroy();
        List selection = (List)req.getParameter("selected resources");
        if (o instanceof MNode) {
            MNode nodeToDestroy = (MNode)o;
            ArrayList<MEdge> edges = new ArrayList<MEdge>((Collection<MEdge>)nodeToDestroy.getInput());
            edges.addAll((Collection<MEdge>)nodeToDestroy.getOutput());
            destroyElement.compose((IUndoableOperation)this.deleteEdges(edges, selection, req.getParameters()));
        } else if (o instanceof Item) {
            List<MEdge> edges = EdgeGeneratorService.getInstance().getItemsEdges((Item)o);
            destroyElement.compose((IUndoableOperation)this.deleteEdges(edges, selection, req.getParameters()));
        }
        destroyElement.compose((IUndoableOperation)new DestroyElementCommand(req));
        return destroyElement;
    }

    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        return new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                MNode node = (MNode)req.getElementToConfigure();
                if (Boolean.TRUE.equals(req.getParameter("existing node"))) {
                    SourceReference ref = (SourceReference)req.getParameter("source reference");
                    ModelDescriptor desc = (ModelDescriptor)req.getParameter("target node descriptor");
                    EdgeResolverService.getInstance().instantiateNode(node, ref, desc);
                    ConfiguratorService.getInstance().configureLoad(node);
                    node.refresh();
                } else if (req.getParameter("existing from adapter") != null) {
                    Map map = Collections.unmodifiableMap(req.getParameters());
                    ConfiguratorService.getInstance().configureExisting(node, req.getParameter("existing from adapter"), map);
                    node.refresh();
                } else if (req.getParameter(ReverseEngineerConstants.REVERSE_ENGINEERING) != null) {
                    Map map = Collections.unmodifiableMap(req.getParameters());
                    ConfiguratorService.getInstance().configureExisting(node, req.getParameter("existing from adapter"), map);
                } else {
                    node.configure();
                    node.refresh();
                }
                return CommandResult.newOKCommandResult((Object)node);
            }
        };
    }
}

