/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.diagram.model.internal.commands.support;

import com.ibm.etools.diagram.model.internal.commands.support.ResourceDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public final class ResourceTree
implements IAdaptable {
    private final List<IAdaptable> list;
    private ResourceTree parent;
    private static final ResourceTree ROOT_MARKER = new ResourceTree();

    public ResourceTree() {
        this.list = new ArrayList<IAdaptable>();
        this.parent = ROOT_MARKER;
    }

    public ResourceTree(ResourceDescriptor resource) {
        Assert.isNotNull((Object)resource, (String)"Resource Descriptor cannot be null");
        this.list = new ArrayList<IAdaptable>();
        this.addChild(resource);
        this.parent = ROOT_MARKER;
    }

    public Object getAdapter(Class adapter) {
        if (this.getClass().isInstance(adapter)) {
            return this;
        }
        if (this.getClass().isInstance(this.getResource().getResource())) {
            return this.getResource().getResource();
        }
        return null;
    }

    public ResourceDescriptor getResource() {
        if (this.list.size() == 0 || this.list.get(0) == ROOT_MARKER) {
            return null;
        }
        return (ResourceDescriptor)this.list.get(0);
    }

    public void addChild(ResourceDescriptor resource) {
        this.list.add(resource);
        resource.setParent(this);
    }

    public void addChild(ResourceTree tree) {
        tree.setParent(this);
        this.list.add(tree);
    }

    public List<IAdaptable> getChildren() {
        if (this.list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.list.get(0) instanceof ResourceDescriptor) {
            return Collections.unmodifiableList(this.list.subList(1, this.list.size()));
        }
        return Collections.unmodifiableList(this.list);
    }

    public List<Object> getChildrenRecursive() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getResource());
        ArrayList<IAdaptable> children = new ArrayList<IAdaptable>(this.getChildren());
        while (!children.isEmpty()) {
            Object o = children.remove(0);
            if (o instanceof ResourceTree) {
                ResourceTree subTree = (ResourceTree)o;
                list.add(subTree.getResource());
                children.addAll(subTree.getChildren());
                continue;
            }
            if (!(o instanceof ResourceDescriptor)) continue;
            list.add(o);
        }
        return list;
    }

    private void setParent(ResourceTree parent) {
        this.parent = parent;
    }

    public int recursiveSize() {
        int size = 0;
        for (IAdaptable o : this.list) {
            if (o == ROOT_MARKER) continue;
            if (o instanceof ResourceTree) {
                size += ((ResourceTree)o).recursiveSize();
                continue;
            }
            ++size;
        }
        return size;
    }

    public ResourceTree getParent() {
        return this.parent;
    }
}

