/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;

public final class JavaIdentifier {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 1998, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private String _fName;

    public JavaIdentifier(String name) {
        this._fName = name.trim();
    }

    public boolean isValid() {
        return JavaIdentifier.isValid(this._fName);
    }

    public static boolean isValid(String fName) {
        if (fName.length() == 0) {
            return false;
        }
        IStatus status = JavaConventions.validateIdentifier((String)fName);
        if (!status.isOK()) {
            return false;
        }
        if (!UCharacter.isJavaIdentifierStart((int)UTF16.charAt((String)fName, (int)0))) {
            return false;
        }
        if (fName.length() > 1) {
            int i = 1;
            while (i < fName.length()) {
                int ch = UTF16.charAt((String)fName, (int)i);
                if (!UCharacter.isJavaIdentifierPart((int)ch)) {
                    return false;
                }
                i += UTF16.getCharCount((int)ch);
            }
        }
        return true;
    }

    public static boolean isValidIdentifierSegment(String fName) {
        if (fName.length() == 0) {
            return false;
        }
        if (!UCharacter.isJavaIdentifierStart((int)UTF16.charAt((String)fName, (int)0))) {
            return false;
        }
        if (fName.length() > 1) {
            int i = 1;
            while (i < fName.length()) {
                int ch = UTF16.charAt((String)fName, (int)i);
                if (!UCharacter.isJavaIdentifierPart((int)ch)) {
                    return false;
                }
                i += UTF16.getCharCount((int)ch);
            }
        }
        return true;
    }
}

