/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.util;

import com.ibm.etools.ctc.cobol2xsd.util.HashVectorEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class HashVectorTable
extends Hashtable {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 1998, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public HashVectorTable() {
    }

    public HashVectorTable(int initialCapacity) {
        super(initialCapacity);
    }

    public HashVectorTable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean contains(Object value) {
        try {
            Enumeration e = this.elements();
            do {
                if (e.hasMoreElements()) continue;
                return false;
            } while (!e.nextElement().equals(value));
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {}
        return false;
    }

    @Override
    public synchronized Enumeration elements() {
        return new HashVectorEnumeration(super.elements());
    }

    public synchronized Enumeration elementsAt(Object key) {
        Vector v = (Vector)this.get(key);
        if (v == null) {
            return null;
        }
        return v.elements();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Vector<Object> v = (Vector<Object>)this.get(key);
        if (v != null) {
            v.addElement(value);
            return value;
        }
        v = new Vector<Object>();
        super.put(key, v);
        ((Vector)this.get(key)).addElement(value);
        return null;
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            buf.append(String.valueOf(obj.toString()) + "=" + ((Vector)this.get(obj)).toString());
            if (!e.hasMoreElements()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

