/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.util;

import com.ibm.etools.cobol.COBOLClassifier;
import com.ibm.etools.cobol.COBOLComposedType;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.ctc.cobol2xsd.util.JavaIdentifier;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class FixInvalidNames {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2003, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();

    public static void fixInvalidNames(COBOLElement element) {
        Vector<COBOLElement> invalidFields = new Vector<COBOLElement>();
        COBOLClassifier classifier = element.getSharedType();
        EList list = null;
        if (!(classifier instanceof COBOLComposedType)) {
            return;
        }
        COBOLComposedType type = (COBOLComposedType)classifier;
        list = type.getElement();
        for (COBOLElement field : list) {
            if (!JavaIdentifier.isValid(field.getName())) {
                invalidFields.addElement(field);
            }
            if (!(field.getSharedType() instanceof COBOLComposedType)) continue;
            FixInvalidNames.fixInvalidNames(field);
        }
        StringBuffer newNameBuf = null;
        String invalidName = null;
        COBOLElement invalidField = null;
        String replacementName = null;
        Enumeration e = invalidFields.elements();
        while (e.hasMoreElements()) {
            invalidField = (COBOLElement)e.nextElement();
            invalidName = invalidField.getName();
            newNameBuf = new StringBuffer();
            boolean problemFound = false;
            if (invalidName.length() == 0) continue;
            int c = UTF16.charAt((String)invalidName, (int)0);
            if (UCharacter.isJavaIdentifierStart((int)c)) {
                UTF16.append((StringBuffer)newNameBuf, (int)c);
            } else {
                newNameBuf.append('_');
                problemFound = true;
            }
            if (invalidName.length() > 1) {
                int i = 1;
                while (i < invalidName.length()) {
                    c = UTF16.charAt((String)invalidName, (int)i);
                    if (UCharacter.isJavaIdentifierPart((int)c)) {
                        UTF16.append((StringBuffer)newNameBuf, (int)c);
                    } else {
                        newNameBuf.append('_');
                        problemFound = true;
                    }
                    i += UTF16.getCharCount((int)c);
                }
            }
            if (!problemFound) {
                newNameBuf.append('_');
            }
            replacementName = newNameBuf.toString();
            COBOLElement field = FixInvalidNames.locate(list, replacementName);
            while (field != null) {
                replacementName = String.valueOf(replacementName) + "_";
                field = FixInvalidNames.locate(list, replacementName);
            }
            invalidField.setName(replacementName);
        }
    }

    private static COBOLElement locate(EList list, String name) {
        if (name == null) {
            return null;
        }
        for (COBOLElement element : list) {
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }
}

