/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.cobol2xsd.typesimport;

import com.ibm.adapter.framework.BaseException;
import com.ibm.adapter.typesimport.impl.GroupReferenceInliner;
import com.ibm.adapter.typesimport.impl.TypesImportCommand;
import com.ibm.etools.cobol.COBOLElement;
import com.ibm.etools.ctc.cobol2xsd.Cobol2XSDPlugin;
import com.ibm.etools.ctc.cobol2xsd.typesimport.CobolElementVisitor;
import com.ibm.etools.ctc.cobol2xsd.typesimport.GeneralUtil;
import com.ibm.etools.ctc.cobol2xsd.typesimport.XsdHelper;
import com.ibm.etools.ctc.cobol2xsd.util.FixInvalidNames;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class CobolTypes2XSDCommand
extends TypesImportCommand {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure " + "restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    protected Map xsdTypesTdBasePair = new HashMap();
    protected XSDSchema xsdSchema = null;
    protected XsdHelper xsdHelper = new XsdHelper();
    protected String appInfoSourceURI = "http://www.wsadie.com/appinfo";
    protected String annotationNSPrefix = "";
    protected String annotationNS = "";
    private CobolElementVisitor visitor;

    public IFile getCobolFile() {
        return this.fieldTypesFile;
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public void importTypes(IProgressMonitor monitor) throws BaseException {
        if (this.xsdSchema == null) {
            URI scheamURI = URI.createFileURI((String)this.fieldSchemaFile.getLocation().toOSString());
            if (this.fieldResourceSet == null) {
                this.fieldResourceSet = new ResourceSetImpl();
            }
            this.fieldSchemaResource = this.fieldResourceSet.createResource(scheamURI);
            this.fieldResourceSet.getResources().add((Object)this.fieldSchemaResource);
            if (this.fieldSchemaFile.exists()) {
                try {
                    this.fieldSchemaResource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exc) {
                    Status s = new Status(4, Cobol2XSDPlugin.getPluginID(), 0, exc.getLocalizedMessage(), (Throwable)exc);
                    throw new BaseException((IStatus)s);
                }
            }
            this.xsdSchema = this.loadOrCreateInitializedSchemaForSchemaResource(this.fieldSchemaResource);
        }
        if (this.fieldGenerateFlat) {
            GeneralUtil.setUseDoubleUnderScore(true);
        } else {
            GeneralUtil.setUseDoubleUnderScore(false);
        }
        this.visitTypes();
        if (!this.fieldGenerateGroupRefs) {
            GroupReferenceInliner.inlineModelGroupsInSchema((XSDSchema)this.xsdSchema);
        }
        if (!this.xsdSchema.isIncrementalUpdate()) {
            this.xsdSchema.setIncrementalUpdate(true);
        }
    }

    protected XSDSchema loadOrCreateInitializedSchemaForSchemaResource(Resource schemaModelResource) {
        XSDSchema schema = null;
        EList ext = schemaModelResource.getContents();
        int i = 0;
        while (i < ext.size()) {
            Object candidate = ext.get(i);
            if (candidate instanceof XSDSchema) {
                if (this.fieldClearXSD) {
                    ext.remove(i);
                    schema = this.xsdFactory.createXSDSchema();
                    ext.add(schema);
                } else {
                    schema = (XSDSchema)candidate;
                }
            }
            ++i;
        }
        if (schema == null) {
            schema = this.xsdFactory.createXSDSchema();
            ext.add(schema);
        }
        this.xsdHelper.initializeSchema(schema, this.fieldSchemaFile, this.schemaTargetNS);
        schema.updateElement();
        if (schema.isIncrementalUpdate()) {
            schema.setIncrementalUpdate(false);
        }
        return schema;
    }

    public void setSchema(XSDSchema newSchema) {
        this.xsdSchema = newSchema;
    }

    private void visitTypes() throws BaseException {
        if (this.fieldXSDTypes == null) {
            this.fieldXSDTypes = new HashMap();
        }
        Iterator i = this.fieldTypes.iterator();
        while (i.hasNext()) {
            this.visitor = new CobolElementVisitor();
            this.visitor.setXsdSchema(this.xsdSchema);
            this.visitor.setXsdTypesTdBasePair(this.xsdTypesTdBasePair);
            this.visitor.setOverwriteTypes(this.fieldOverwriteTypes);
            this.visitor.setGenerateFlat(this.fieldGenerateFlat);
            this.visitor.setPreserveCase(this.fieldPreserveCase);
            this.visitor.setVAJStyle(this.fieldStyle);
            String annNS = this.getAnnotationNS();
            if (annNS != null && !annNS.equals("")) {
                this.visitor.setAnnotationNS(this.getAnnotationNS());
                String annPrefix = this.getAnnotationNSPrefix();
                if (annPrefix.endsWith(":")) {
                    annPrefix = annPrefix.substring(0, annPrefix.length() - 1);
                }
                this.xsdSchema.getQNamePrefixToNamespaceMap().put(annPrefix, annNS);
                this.visitor.setAnnotationNSPrefix(String.valueOf(annPrefix) + ":");
            }
            this.visitor.setAppInfoSourceURI(this.getAppInfoSourceURI());
            COBOLElement cobolElement = (COBOLElement)i.next();
            if (this.fieldTypes.size() > 1) {
                this.visitor.setXsdTypeName(cobolElement.getName());
                this.visitor.setTopTypePrefix(this.fieldXSDTypePrefix);
            } else {
                if (this.fieldXSDTypeName == null || this.fieldXSDTypeName.length() == 0) {
                    this.fieldXSDTypeName = cobolElement.getName();
                }
                this.visitor.setTopTypePrefix(this.fieldXSDTypePrefix);
                this.visitor.setXsdTypeName(this.fieldXSDTypeName);
            }
            if (this.fieldStyle != 0) {
                FixInvalidNames.fixInvalidNames(cobolElement);
            }
            this.visitor.acceptItemVisitor(cobolElement, 1);
            XSDTypeDefinition returnedType = this.visitor.getXSDType();
            this.fieldXSDTypes.put(returnedType.getName(), returnedType);
        }
    }

    public Map getXSDTypesTdBasePair() {
        return this.xsdTypesTdBasePair;
    }

    public String getAnnotationNS() {
        return this.annotationNS;
    }

    public void setAnnotationNS(String annotationNS) {
        this.annotationNS = annotationNS;
    }

    public String getAnnotationNSPrefix() {
        return this.annotationNSPrefix;
    }

    public void setAnnotationNSPrefix(String annotationNSPrefix) {
        this.annotationNSPrefix = annotationNSPrefix;
    }

    public String getAppInfoSourceURI() {
        return this.appInfoSourceURI;
    }

    public void setAppInfoSourceURI(String appInfoSourceURI) {
        this.appInfoSourceURI = appInfoSourceURI;
    }
}

