/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.c2xsd.typesimport;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class BaseURI {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private URI uriObject;
    protected static final String fileProtocol = "file";

    public BaseURI() {
    }

    public BaseURI(URI uri) {
        this.uriObject = uri;
    }

    public BaseURI(String uri) {
        this.uriObject = URI.createURI((String)uri);
    }

    public BaseURI(URL url) {
        this.uriObject = URI.createURI((String)url.toString());
    }

    public String getAbsoluteURI(URI uri) {
        return this.getAbsoluteURI(uri.toString());
    }

    public static URL makeURL(String uriString) {
        URL newURL = null;
        int index = uriString.indexOf(":");
        if (index == -1 || index == 1) {
            uriString = "file:" + uriString;
        }
        try {
            newURL = new URL(uriString);
        }
        catch (Exception exception) {}
        return newURL;
    }

    public String getAbsoluteURI(String uri) {
        Path path;
        URL url = null;
        try {
            url = new URL(BaseURI.makeURL(this.uriObject.toString()), uri);
        }
        catch (MalformedURLException malformedURLException) {
            return uri;
        }
        if ("platform".equals(url.getProtocol())) {
            try {
                IFile resolved;
                path = new Path(url.getFile());
                IFile file = null;
                if (path.segmentCount() > 2 && "resource".equals(path.segment(0))) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(FileLocator.resolve((URL)url).getFile()));
                }
                if (path.segmentCount() > 2 && "plugin".equals(path.segment(0))) {
                    return url.toString();
                }
                if (path.segmentCount() > 0 && uri.startsWith("/")) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(FileLocator.resolve((URL)BaseURI.makeURL(this.uriObject.toString())).getFile())).getProject();
                        file = project.getFile((IPath)path);
                    }
                    catch (Throwable throwable) {}
                    if (file == null) {
                        return "platform:/resource" + path.toString();
                    }
                }
                if (file != null && (resolved = this.resolve(file)) != null) {
                    return "platform:/resource" + resolved.getFullPath();
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            if ("platform".equals(url.getProtocol()) && !"resource".equals((path = new Path(url.getFile())).segment(0))) {
                return "platform:/resource" + path;
            }
        }
        catch (Throwable throwable) {}
        return url.toString();
    }

    public String getRelativeURI(URI uri) {
        if (uri.toString().indexOf(58) == -1) {
            return uri.toString();
        }
        return this.getRelativeURI(BaseURI.makeURL(uri.toString()));
    }

    public String getRelativeURI(String uri) {
        return this.getRelativeURI(URI.createURI((String)uri));
    }

    public String getRelativeURI(URL url) {
        URL baseURL = BaseURI.makeURL(this.uriObject.toString());
        if ((baseURL.getProtocol() == url.getProtocol() || baseURL.getProtocol() != null && baseURL.getProtocol().equals(url.getProtocol())) && (baseURL.getHost() == url.getHost() || baseURL.getHost() != null && baseURL.getHost().equals(url.getHost())) && baseURL.getPort() == url.getPort()) {
            Path basePath = new Path(baseURL.getFile());
            Path path = new Path(url.getFile());
            String baseDevice = basePath.getDevice();
            String device = path.getDevice();
            if (baseDevice == null && device == null || baseDevice != null && baseDevice.equals(device)) {
                if ("platform".equals(baseURL.getProtocol()) && "platform".equals(url.getProtocol()) && (basePath.segmentCount() <= 1 || path.segmentCount() <= 1 || !basePath.segment(0).equals(path.segment(0)))) {
                    return url.toString();
                }
                if ("platform".equals(baseURL.getProtocol()) && "resource".equals(basePath.segment(0)) && basePath.segmentCount() > 1 && "platform".equals(url.getProtocol()) && "resource".equals(path.segment(0)) && path.segmentCount() > 1) {
                    try {
                        IJavaElement javaElement;
                        Object baseFile = null;
                        Object file = null;
                        baseFile = basePath.segmentCount() > 2 ? ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(FileLocator.resolve((URL)baseURL).getFile())) : ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(baseURL.toString()).lastSegment());
                        file = path.segmentCount() > 2 ? ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(FileLocator.resolve((URL)url).getFile())) : ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(url.toString()).lastSegment());
                        basePath = baseFile.getProjectRelativePath();
                        try {
                            javaElement = JavaCore.create((IResource)baseFile.getParent());
                            if (javaElement instanceof IPackageFragment) {
                                javaElement = javaElement.getParent();
                            }
                            if (javaElement instanceof IPackageFragmentRoot) {
                                basePath = basePath.removeFirstSegments(basePath.matchingFirstSegments(javaElement.getUnderlyingResource().getProjectRelativePath()));
                            }
                        }
                        catch (Throwable throwable) {}
                        path = file.getProjectRelativePath();
                        try {
                            javaElement = JavaCore.create((IResource)file.getParent());
                            if (javaElement instanceof IPackageFragment) {
                                javaElement = javaElement.getParent();
                            }
                            if (javaElement instanceof IPackageFragmentRoot) {
                                path = path.removeFirstSegments(path.matchingFirstSegments(javaElement.getUnderlyingResource().getProjectRelativePath()));
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {}
                }
                if ((path = path.setDevice("")).equals((Object)basePath)) {
                    return path.lastSegment();
                }
                int matching = path.matchingFirstSegments((IPath)basePath);
                IPath relativePath = path.removeFirstSegments(matching);
                int i = basePath.segmentCount() - 1;
                while (i > matching) {
                    relativePath = new Path("..").append(relativePath);
                    --i;
                }
                return relativePath.toString();
            }
        }
        return url.toString();
    }

    public IFile resolve(IProject project, IFile file) {
        block14: {
            if (file == null) {
                return null;
            }
            IPath relativePath = file.getProjectRelativePath();
            try {
                IFile resolved = project.getFile(relativePath);
                if (resolved.exists()) {
                    return resolved;
                }
            }
            catch (Exception exception) {}
            try {
                IJavaElement javaElement = JavaCore.create((IResource)file.getParent());
                if (javaElement instanceof IPackageFragment) {
                    javaElement = javaElement.getParent();
                }
                if (javaElement instanceof IPackageFragmentRoot) {
                    relativePath = relativePath.removeFirstSegments(relativePath.matchingFirstSegments(javaElement.getUnderlyingResource().getProjectRelativePath()));
                }
            }
            catch (Throwable throwable) {}
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                if (packageFragmentRoots == null) break block14;
                int f = 0;
                while (f < packageFragmentRoots.length) {
                    try {
                        IFile resolved = ResourcesPlugin.getWorkspace().getRoot().getFile(packageFragmentRoots[f].getCorrespondingResource().getFullPath().append(relativePath));
                        if (resolved.exists()) {
                            return resolved;
                        }
                    }
                    catch (Throwable throwable) {}
                    ++f;
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public IFile resolve(IFile file) {
        IProject project = file.getProject();
        IFile resolved = this.resolve(project, file);
        return resolved;
    }

    public String toString() {
        if (this.uriObject != null) {
            return this.uriObject.toString();
        }
        return "";
    }
}

