/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.widgets;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.ui.internal.listeners.DecorateAttributeListener;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributePropertyGroup;
import com.ibm.etools.annotations.ui.internal.registry.AnnotationAttributeInputContributorInfo;
import com.ibm.etools.annotations.ui.internal.registry.AnnotationUIExtensionRegistry;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.etools.annotations.ui.internal.widgets.SingleAnnotationArgumentPropertyUIWidget;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.ui.datastores.DynamicGenStore;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIFactory;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;

public class AnnotationAttributesUIWidget {
    protected PropertyUIFactory uiFactory_;
    protected PropertyUIComposite propertyUIComposite_;
    protected DecorateAttributeListener iListener_;
    protected DynamicGenStore dgStore_;
    protected Job populateProjectAnnotationJob_ = null;

    public AnnotationAttributesUIWidget(PropertyUIFactory uiFactory) {
        this(null, uiFactory);
    }

    public AnnotationAttributesUIWidget(DynamicGenStore dgStore, PropertyUIFactory uiFactory) {
        this.uiFactory_ = uiFactory;
        this.iListener_ = new DecorateAttributeListener();
        this.dgStore_ = dgStore;
    }

    public PropertyUIComposite displayAttributes(Composite parent, AnnotationInfo annoInfo) throws CoreException {
        String name = annoInfo.getName();
        BasePropertyGroup pg = new BasePropertyGroup(name, name, name);
        List attributes = annoInfo.getAllAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            AnnotationAttributePropertyGroup attrPG = new AnnotationAttributePropertyGroup(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES, AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES_DESC, null);
            pg.addProperty((IPropertyDescriptor)attrPG);
            ArrayList<IAnnotationAttributeProperty> attriList = AnnotationUIUtils.sortAttributeList(attributes);
            int i = 0;
            while (i < attriList.size()) {
                attrPG.addProperty((IPropertyDescriptor)attriList.get(i));
                ++i;
            }
        }
        return this.displayAttributes(parent, (IPropertyGroup)pg);
    }

    public PropertyUIComposite displayAttributes(Composite parent, IPropertyGroup pg) throws CoreException {
        if (this.propertyUIComposite_ != null || this.populateProjectAnnotationJob_ != null) {
            this.clearWidget();
        }
        IPropertyUIWidgetFactory factory = this.uiFactory_.getUIFactory();
        Label content = null;
        if (pg == null) {
            content = factory.createLabel(parent, "", 0);
        } else {
            Composite main = null;
            IPropertyDescriptor[] children = pg.getProperties();
            if (children == null || children.length < 1) {
                main = factory.createComposite(parent, 0);
                main.setLayout((Layout)new GridLayout());
                main.setLayoutData((Object)new GridData(1808));
                Section area = factory.createSection(main, 274);
                area.setText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES);
                area.setExpanded(true);
                GridData gd = new GridData(768);
                area.setLayoutData((Object)gd);
                Composite comp = factory.createComposite((Composite)area, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 2;
                layout.marginHeight = 2;
                comp.setLayout((Layout)layout);
                comp.setLayoutData((Object)new GridData(1808));
                comp.setFont(area.getFont());
                area.setClient((Control)comp);
                factory.createLabel(comp, AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_NO_ATTRIBUTES_DEFINED, 64);
            } else {
                this.assignCustomizedInfo(pg);
                this.propertyUIComposite_ = this.uiFactory_.generatePropertyUI(parent, pg);
                if (this.needToUpdatePropertyUIWidgets()) {
                    this.updatePropertyUIWidgets();
                }
                main = this.propertyUIComposite_.getComposite();
            }
            content = main;
        }
        if (content != null && parent instanceof ScrolledComposite) {
            ((ScrolledComposite)parent).setContent((Control)content);
            ((ScrolledComposite)parent).setMinSize(content.computeSize(-1, -1));
        }
        if (this.propertyUIComposite_ != null) {
            this.iListener_.setPropertyUIComposite(this.propertyUIComposite_);
        }
        return this.propertyUIComposite_;
    }

    protected void loadPropertyDefaultValue(String key) {
        if (this.dgStore_ != null && this.propertyUIComposite_ != null) {
            this.dgStore_.restoreFromStore(key, this.propertyUIComposite_.getUIWidgets(), this.propertyUIComposite_.getPropertyGroup());
        }
    }

    public void savePropertiesToStore(String key) {
        if (this.dgStore_ != null && this.propertyUIComposite_ != null) {
            this.dgStore_.storePropertyValues(key, this.propertyUIComposite_.getPropertyGroup());
        }
    }

    protected void assignCustomizedInfo(IPropertyGroup properties) throws CoreException {
        IPropertyDescriptor[] ipds = properties.getProperties();
        if (ipds != null && ipds.length > 0) {
            int i = 0;
            while (i < ipds.length) {
                if (ipds[i] instanceof IAnnotationAttributeProperty) {
                    AnnotationInfo annoInfo = ((IAnnotationAttributeProperty)ipds[i]).getParentAnnotation();
                    if (annoInfo != null) {
                        String pkgName = annoInfo.getCategorizationKey();
                        String tagName = annoInfo.getName();
                        String attribute = ipds[i].getName();
                        AnnotationAttributeInputContributorInfo info = AnnotationUIExtensionRegistry.instance().getAttributeInputContributor(pkgName, tagName, attribute);
                        if (info != null && "DEFAULT_PROPERTY_IDENTIFIER".equals(ipds[i].getID())) {
                            ipds[i].assignID(info.getAttributeInputContributorID());
                        }
                    }
                } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                    this.assignCustomizedInfo((IPropertyGroup)ipds[i]);
                }
                ++i;
            }
        }
    }

    protected boolean needToUpdatePropertyUIWidgets() {
        return true;
    }

    protected void updatePropertyUIWidgets() {
        ArrayList widgets = this.propertyUIComposite_.getUIWidgets();
        ArrayList<SingleAnnotationArgumentPropertyUIWidget> singleAnnotationWidgets = new ArrayList<SingleAnnotationArgumentPropertyUIWidget>();
        IJavaProject project = null;
        int i = 0;
        while (i < widgets.size()) {
            PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
            if (widget instanceof SingleAnnotationArgumentPropertyUIWidget) {
                singleAnnotationWidgets.add((SingleAnnotationArgumentPropertyUIWidget)widget);
                if (project == null) {
                    SingleAnnotationArgumentProperty saap = (SingleAnnotationArgumentProperty)((SingleAnnotationArgumentPropertyUIWidget)widget).getProperty();
                    JavaElementInfo jeInfo = InternalUtils.getParentJavaElementInfo4Attribute((IAnnotationAttributeProperty)saap);
                    IJavaElement je = null;
                    if (jeInfo != null) {
                        je = jeInfo.getJavaElement();
                    }
                    if (je != null) {
                        project = je.getJavaProject();
                    }
                }
            }
            ++i;
        }
        if (!singleAnnotationWidgets.isEmpty() && project != null) {
            this.updateSuggestionList(singleAnnotationWidgets, project);
        }
    }

    protected void updateSuggestionList(final ArrayList<SingleAnnotationArgumentPropertyUIWidget> singleAnnotationWidgets, final IJavaProject javaProject) {
        this.populateProjectAnnotationJob_ = new Job(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_POPULATE_PROJECT_ANNOTATIONS){

            protected IStatus run(IProgressMonitor monitor) {
                final ArrayList<String> suggestionList = new ArrayList<String>();
                List ais = new AnnotationUtils().parseAllAnnotationsOnClassPath(javaProject);
                if (ais != null && !ais.isEmpty()) {
                    int i = 0;
                    while (i < ais.size()) {
                        StringBuffer sb = new StringBuffer("@");
                        sb.append(AnnotationUIUtils.getAnnotationInfoLabel((AnnotationInfo)ais.get(i)));
                        suggestionList.add(sb.toString());
                        ++i;
                    }
                    if (!suggestionList.isEmpty()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                int i = 0;
                                while (i < singleAnnotationWidgets.size()) {
                                    SingleAnnotationArgumentPropertyUIWidget widget = (SingleAnnotationArgumentPropertyUIWidget)((Object)singleAnnotationWidgets.get(i));
                                    if (!widget.isDisposed()) {
                                        widget.setSuggestions(suggestionList);
                                    }
                                    ++i;
                                }
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.populateProjectAnnotationJob_.schedule(500L);
    }

    public void clearWidget() {
        if (this.populateProjectAnnotationJob_ != null) {
            this.populateProjectAnnotationJob_.cancel();
            this.populateProjectAnnotationJob_ = null;
        }
        if (this.iListener_ != null) {
            this.iListener_.clearListener();
        }
        if (this.propertyUIComposite_ != null) {
            this.propertyUIComposite_.dispose();
            this.propertyUIComposite_ = null;
        }
    }

    public void dispose() {
        if (this.propertyUIComposite_ != null || this.populateProjectAnnotationJob_ != null) {
            this.clearWidget();
        }
        if (this.iListener_ != null) {
            this.iListener_.dispose();
        }
    }
}

