/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.utils;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationViewOverlayInfo;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.propertygroup.ui.utilities.PropertyGroupUIHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class AnnotationUIUtils {
    public static final String NUMBER_SEPARATOR = "@#";
    protected static AnnotationViewOverlayInfo overlayConfig = new AnnotationViewOverlayInfo();

    public static void positionCursor(int sourceOffset) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorPart part2 = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        AnnotationUIUtils.positionCursor(sourceOffset, part2);
    }

    public static void positionCursor(int sourceOffset, IEditorPart part2) {
        try {
            AbstractTextEditor textEditor;
            ISelection selection;
            if (part2 instanceof AbstractTextEditor && (selection = (textEditor = (AbstractTextEditor)part2).getSelectionProvider().getSelection()) instanceof ITextSelection) {
                ITextSelection textSel = (ITextSelection)selection;
                textSel.getLength();
                if (textSel == null || sourceOffset < textSel.getOffset() || sourceOffset > textSel.getOffset() + textSel.getLength()) {
                    textEditor.selectAndReveal(sourceOffset, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IPath buildAnnotationKey(AnnotationInfo info) {
        Path keyPath = null;
        Object parentInfo = info.getParentElementInfo();
        if (parentInfo != null) {
            AnnotationInfo paInfo;
            if (parentInfo instanceof JavaElementInfo) {
                String name;
                IJavaElement javaElement = ((JavaElementInfo)parentInfo).getJavaElement();
                if (javaElement != null && (name = AnnotationUIUtils.getJavaElementName(javaElement)) != null) {
                    keyPath = AnnotationUIUtils.buildFullQualifiedPath(javaElement, name);
                }
            } else if (parentInfo instanceof IAnnotationAttributeProperty && (paInfo = ((IAnnotationAttributeProperty)parentInfo).getParentAnnotation()) != null && (keyPath = AnnotationUIUtils.buildAnnotationKey(paInfo)) != null) {
                keyPath = keyPath.append(AnnotationUIUtils.buildAnnotationSegmentName(paInfo)).append(((IAnnotationAttributeProperty)parentInfo).getName());
            }
        } else {
            IAnnotation anno = info.getAnnotation();
            if (anno instanceof Annotation) {
                ASTNode node = ((Annotation)anno).getParent();
                int nodeType = node.getNodeType();
                switch (nodeType) {
                    case 55: {
                        keyPath = AnnotationUIUtils.buildFullQualifiedPath(node, ((TypeDeclaration)node).getName().toString());
                        break;
                    }
                    case 31: {
                        MethodDeclaration mD = (MethodDeclaration)node;
                        StringBuffer signature = new StringBuffer(mD.getName().toString()).append("(");
                        List pars = mD.parameters();
                        int i = 0;
                        while (i < pars.size()) {
                            if (i > 0) {
                                signature.append(", ");
                            }
                            SingleVariableDeclaration svd = (SingleVariableDeclaration)pars.get(i);
                            signature.append(svd.getType().resolveBinding().getName());
                            ++i;
                        }
                        signature.append(")");
                        keyPath = AnnotationUIUtils.buildFullQualifiedPath(node, signature.toString());
                        break;
                    }
                    case 23: {
                        List ls = ((FieldDeclaration)node).fragments();
                        if (ls.size() <= 0) break;
                        keyPath = AnnotationUIUtils.buildFullQualifiedPath(node, ((VariableDeclarationFragment)ls.get(0)).getName().toString());
                    }
                }
            }
        }
        if (keyPath == null) {
            keyPath = new Path("");
        }
        return keyPath;
    }

    public static String buildAnnotationSegmentName(AnnotationInfo annoInfo) {
        StringBuffer pName = new StringBuffer(AnnotationUIUtils.getAnnotationInfoLabel(annoInfo));
        Object pInfo = annoInfo.getParentElementInfo();
        if (pInfo != null && pInfo instanceof ArrayAnnotationArgumentProperty) {
            int index = -1;
            Object[] values = ((ArrayAnnotationArgumentProperty)pInfo).getValues();
            int i = 0;
            while (i < values.length) {
                if (values[i] == annoInfo) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                pName.append(NUMBER_SEPARATOR).append(index);
            }
        }
        return pName.toString();
    }

    public static IPath buildFullQualifiedPath(ASTNode node, String name) {
        ArrayList<String> segments = new ArrayList<String>(6);
        segments.add(name);
        node = node.getParent();
        while (node != null && node.getNodeType() == 55) {
            segments.add(0, ((TypeDeclaration)node).getName().toString());
            node = node.getParent();
        }
        Path path = new Path((String)segments.get(0));
        int i = 1;
        while (i < segments.size()) {
            path = path.append((String)segments.get(i));
            ++i;
        }
        return path;
    }

    public static IPath buildFullQualifiedPath(IJavaElement element, String name) {
        ArrayList<String> segments = new ArrayList<String>(6);
        segments.add(name);
        element = element.getParent();
        while (element != null && element.getElementType() == 7) {
            segments.add(0, element.getElementName());
            element = element.getParent();
        }
        Path path = new Path((String)segments.get(0));
        int i = 1;
        while (i < segments.size()) {
            path = path.append((String)segments.get(i));
            ++i;
        }
        return path;
    }

    public static String getJavaElementName(IJavaElement je) {
        try {
            switch (je.getElementType()) {
                case 7: {
                    return je.getElementName();
                }
                case 9: {
                    IMethod method = (IMethod)je;
                    return Signature.toString((String)method.getSignature(), (String)method.getElementName(), null, (boolean)true, (boolean)false);
                }
                case 8: {
                    return ((IField)je).getElementName();
                }
                case 11: {
                    return ((IPackageDeclaration)je).getElementName();
                }
                case 16: {
                    return ((IAnnotation)je).getElementName();
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getAnnotationInfoLabel(AnnotationInfo info) {
        StringBuffer label = new StringBuffer(info.getName());
        label.append(" - ").append(AnnotationViewOverlayInfo.instance().getLabel(info.getCategorizationKey()));
        return label.toString();
    }

    public static void showExceptionMessage(Throwable e, Shell shell, String title, String msg) {
        if (shell != null) {
            String tit = title;
            if (tit == null) {
                tit = AnnotationsUIMessages.ANNOTATIONS_UI_ERROR;
            }
            PropertyGroupUIHelper.getDefault().showExceptionMessage((AbstractUIPlugin)Activator.getDefault(), e, shell, tit, msg);
        } else {
            String message = msg != null ? msg : e.toString();
            String pluginName = Activator.getDefault().getBundle().getSymbolicName();
            if (pluginName == null || pluginName.length() < 1) {
                pluginName = "";
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, pluginName, 4, message, e));
        }
    }

    public static ArrayList<IAnnotationAttributeProperty> sortAttributeList(List<IAnnotationAttributeProperty> list) {
        ArrayList<IAnnotationAttributeProperty> newList = new ArrayList<IAnnotationAttributeProperty>();
        ArrayList<IAnnotationAttributeProperty> newList1 = new ArrayList<IAnnotationAttributeProperty>();
        int index = 0;
        int i = 0;
        while (i < list.size()) {
            IAnnotationAttributeProperty attribute = list.get(i);
            if (attribute.getName().equalsIgnoreCase("name")) {
                newList.add(0, attribute);
                ++index;
            } else if (attribute.getName().equalsIgnoreCase("description")) {
                newList.add(index++, attribute);
            } else if (attribute instanceof SingleValueArgumentProperty) {
                newList.add(attribute);
            } else {
                newList1.add(attribute);
            }
            ++i;
        }
        newList.addAll(newList1);
        return newList;
    }
}

