/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.utils;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.AnnotationParser;
import com.ibm.etools.annotations.core.internal.utils.InternalUtils;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.annotations.ui.internal.data.AnnotationAttributeChangedInfo;
import com.ibm.propertygroup.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class AnnotationSourceModifier {
    public static final String PROPERTY_ANNOTATION_CHANGED = "ANNOTATION_MODIFIER_ANNOTATION_CHANGED";
    protected UpdateAnnotationEvent delayedTask_ = null;
    protected ICompilationUnit cUnit_;
    protected AnnotationParser aParser_;
    protected PropertyChangeSupport changeSupport_;
    protected boolean sourceIsChanging_ = false;
    protected AnnotationSourceChangeListener sourceChangeListener_ = new AnnotationSourceChangeListener();
    protected boolean performReconcile_;

    public void setModificationInfo(ICompilationUnit unit, AnnotationParser parser) {
        this.setModificationInfo(unit, parser, false);
    }

    public void setModificationInfo(ICompilationUnit unit, AnnotationParser parser, boolean performReconcile) {
        if (unit != null) {
            if (!unit.equals(this.cUnit_)) {
                this.cancelTask();
                this.cUnit_ = unit;
            }
        } else if (this.cUnit_ != null) {
            this.cancelTask();
            this.cUnit_ = unit;
        }
        this.aParser_ = parser;
        this.performReconcile_ = performReconcile;
    }

    public void setPerformReconcile(boolean perform) {
        this.performReconcile_ = perform;
    }

    public void performModifyAttributes(AnnotationAttributeChangedInfo[] aacInfos) {
        this.performModifyAttributes(1000, aacInfos);
    }

    public void performModifyAttributes(final int milliseconds, final AnnotationAttributeChangedInfo[] aacInfos) {
        if (this.cUnit_ == null) {
            return;
        }
        if (this.aParser_ == null) {
            this.aParser_ = new AnnotationParser();
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (AnnotationSourceModifier.this.delayedTask_ == null) {
                    AnnotationSourceModifier.this.delayedTask_ = new UpdateAnnotationEvent(aacInfos);
                } else {
                    AnnotationSourceModifier.this.delayedTask_.addAllAttributeChangedInfo(aacInfos);
                }
                Display.getDefault().timerExec(milliseconds, (Runnable)AnnotationSourceModifier.this.delayedTask_);
            }
        });
    }

    public void performModifyAttribute(PropertyChangeEvent evt, IAnnotationAttributeProperty aap) {
        this.performModifyAttribute(100, evt, aap);
    }

    public void performModifyAttribute(int milliseconds, PropertyChangeEvent evt, IAnnotationAttributeProperty aap) {
        if (this.cUnit_ == null) {
            return;
        }
        if (this.aParser_ == null) {
            this.aParser_ = new AnnotationParser();
        }
        if (this.delayedTask_ == null) {
            this.delayedTask_ = new UpdateAnnotationEvent(evt, aap);
            this.sourceIsChanging_ = false;
        } else {
            this.delayedTask_.addAttributeChangedInfo(evt, aap);
        }
        if (!this.sourceIsChanging_) {
            this.sourceChangeListener_.timer_ = milliseconds;
            Display.getDefault().timerExec(milliseconds, (Runnable)this.delayedTask_);
        }
    }

    protected void modifyAnnotation(final ArrayList<AnnotationAttributeChangedInfo> attributesInfo) {
        if (attributesInfo != null && !attributesInfo.isEmpty()) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ArrayList<AnnotationInfo> anInfoList = new ArrayList<AnnotationInfo>(2);
                    ArrayList<AnnotationInfo> nestedAnnoInfoList = new ArrayList<AnnotationInfo>(2);
                    int i = 0;
                    while (i < attributesInfo.size()) {
                        IAnnotationAttributeProperty attribute = ((AnnotationAttributeChangedInfo)attributesInfo.get(i)).getAttribute();
                        AnnotationInfo info = attribute.getParentAnnotation();
                        List declaredAttributes = info.getDeclaredAttributes();
                        if (!declaredAttributes.contains(attribute)) {
                            declaredAttributes.add(attribute);
                        }
                        if (!info.modifyModelOnly()) {
                            AnnotationInfo ai;
                            PropertyChangeEvent event;
                            if ((attribute instanceof SingleAnnotationArgumentProperty || attribute instanceof ArrayAnnotationArgumentProperty) && (event = ((AnnotationAttributeChangedInfo)attributesInfo.get(i)).getEvent()).getNewValue() != null && !nestedAnnoInfoList.contains(ai = (AnnotationInfo)event.getNewValue())) {
                                nestedAnnoInfoList.add(ai);
                            }
                            if (!anInfoList.contains(info)) {
                                anInfoList.add(info);
                            }
                        }
                        ++i;
                    }
                    if (!anInfoList.isEmpty() || !nestedAnnoInfoList.isEmpty()) {
                        AnnotationSourceModifier.this.sourceIsChanging_ = true;
                        JavaCore.removeElementChangedListener((IElementChangedListener)AnnotationSourceModifier.this.sourceChangeListener_);
                        JavaCore.addElementChangedListener((IElementChangedListener)AnnotationSourceModifier.this.sourceChangeListener_, (int)4);
                    }
                    AnnotationInfo info = null;
                    int i2 = 0;
                    while (i2 < anInfoList.size()) {
                        info = (AnnotationInfo)anInfoList.get(i2);
                        if (AnnotationSourceModifier.this.changeSupport_ != null) {
                            AnnotationSourceModifier.this.changeSupport_.firePropertyChange(AnnotationSourceModifier.PROPERTY_ANNOTATION_CHANGED, info, null);
                        }
                        if (!info.isImpliedAnnotation()) {
                            AnnotationSourceModifier.this.aParser_.modifyAnnotation(AnnotationSourceModifier.this.cUnit_, info, false, AnnotationSourceModifier.this.performReconcile_);
                        } else {
                            JavaElementInfo parentInfo = InternalUtils.getParentJavaElementInfo4Annotation((AnnotationInfo)info);
                            IJavaElement je = null;
                            if (parentInfo != null) {
                                je = parentInfo.getJavaElement();
                            }
                            if (je != null) {
                                AnnotationSourceModifier.this.aParser_.addAnnotationToCU(AnnotationSourceModifier.this.cUnit_, info, je, false, AnnotationSourceModifier.this.performReconcile_);
                                info.setIsImpliedAnnotation(false);
                            }
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < nestedAnnoInfoList.size()) {
                        InternalUtils.addImportStatement((ICompilationUnit)AnnotationSourceModifier.this.cUnit_, (AnnotationInfo)((AnnotationInfo)nestedAnnoInfoList.get(i2)));
                        ++i2;
                    }
                }
            });
        }
    }

    public void clearModifier() {
        this.cancelTask();
        this.aParser_ = null;
        this.cUnit_ = null;
    }

    public void cancelTask() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.sourceChangeListener_);
        this.sourceIsChanging_ = false;
        if (this.delayedTask_ != null) {
            this.delayedTask_.setCancel(true);
            this.delayedTask_ = null;
        }
    }

    public void dispose() {
        this.clearModifier();
        this.changeSupport_ = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport_ == null) {
            this.changeSupport_ = new PropertyChangeSupport(this);
        }
        this.changeSupport_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport_ != null) {
            this.changeSupport_.removePropertyChangeListener(listener);
            if (this.changeSupport_.getPropertyChangeListeners().length == 0) {
                this.changeSupport_ = null;
            }
        }
    }

    protected class AnnotationSourceChangeListener
    implements IElementChangedListener {
        protected int timer_ = 0;

        protected AnnotationSourceChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            AnnotationSourceModifier.this.sourceIsChanging_ = false;
            if (AnnotationSourceModifier.this.delayedTask_ != null) {
                final Display display = Display.getDefault();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        display.timerExec(AnnotationSourceChangeListener.this.timer_, (Runnable)((AnnotationSourceChangeListener)AnnotationSourceChangeListener.this).AnnotationSourceModifier.this.delayedTask_);
                    }
                });
            }
        }
    }

    protected class ResetFlagThread
    extends Thread {
        protected ResetFlagThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ResetFlagThread resetFlagThread = this;
                synchronized (resetFlagThread) {
                    this.wait(2500L);
                }
            }
            catch (InterruptedException interruptedException) {}
            if (AnnotationSourceModifier.this.sourceIsChanging_ && AnnotationSourceModifier.this.changeSupport_ != null) {
                AnnotationSourceModifier.this.changeSupport_.firePropertyChange(AnnotationSourceModifier.PROPERTY_ANNOTATION_CHANGED, null, null);
            }
            AnnotationSourceModifier.this.sourceIsChanging_ = false;
        }
    }

    protected class UpdateAnnotationEvent
    implements Runnable {
        protected boolean cancelEvent_ = false;
        protected ArrayList<AnnotationAttributeChangedInfo> attributes_ = new ArrayList(3);

        public UpdateAnnotationEvent() {
        }

        public UpdateAnnotationEvent(PropertyChangeEvent evt, IAnnotationAttributeProperty attribute) {
            this.addAttributeChangedInfo(evt, attribute);
        }

        public UpdateAnnotationEvent(AnnotationAttributeChangedInfo aacInfo) {
            this.addAttributeChangedInfo(aacInfo);
        }

        public UpdateAnnotationEvent(AnnotationAttributeChangedInfo[] aacInfos) {
            this.addAllAttributeChangedInfo(aacInfos);
        }

        public void addAttributeChangedInfo(PropertyChangeEvent evt, IAnnotationAttributeProperty attribute) {
            AnnotationAttributeChangedInfo newInfo = new AnnotationAttributeChangedInfo(evt, attribute);
            if (!this.attributes_.contains(newInfo)) {
                this.attributes_.add(newInfo);
            }
        }

        public void addAttributeChangedInfo(AnnotationAttributeChangedInfo newInfo) {
            if (!this.attributes_.contains(newInfo)) {
                this.attributes_.add(newInfo);
            }
        }

        public void addAllAttributeChangedInfo(AnnotationAttributeChangedInfo[] newInfos) {
            int i = 0;
            while (i < newInfos.length) {
                if (!this.attributes_.contains(newInfos[i])) {
                    this.attributes_.add(newInfos[i]);
                }
                ++i;
            }
        }

        @Override
        public void run() {
            if (AnnotationSourceModifier.this.delayedTask_ == this) {
                AnnotationSourceModifier.this.delayedTask_ = null;
            }
            if (!this.cancelEvent_) {
                AnnotationSourceModifier.this.modifyAnnotation(this.attributes_);
            }
        }

        public void setCancel(boolean flag) {
            this.cancelEvent_ = flag;
        }
    }
}

