/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.utils;

import com.ibm.etools.annotations.core.internal.AnnotationConfigElem;
import com.ibm.etools.annotations.core.internal.AnnotationConfigInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.core.utils.ResourceUtils;
import com.ibm.etools.annotations.ui.AnnotationUIContextHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AdvancedAnnotationProposalProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static ICompilationUnit cu_ = null;
    private static IJavaElement jContext_ = null;
    private static IWorkspaceRoot root_ = null;
    private static IWorkspace workspace_ = null;

    public IJavaElement getContext() {
        return jContext_;
    }

    public ICompilationUnit getCompilationUnit() {
        return cu_;
    }

    public IJavaProject getProject() {
        IJavaElement jelm = this.getContext();
        return jelm.getJavaProject();
    }

    public void setContext(IJavaElement context) {
        jContext_ = context;
    }

    public void setCompilationUnit(ICompilationUnit cunit) {
        cu_ = cunit;
    }

    public List makeUnique(List suggestions) {
        HashSet<Proposal> seenAlready = new HashSet<Proposal>();
        ArrayList<Proposal> uniqueSuggestions = new ArrayList<Proposal>();
        for (Proposal suggestion : suggestions) {
            if (seenAlready.contains(suggestion)) continue;
            seenAlready.add(suggestion);
            uniqueSuggestions.add(suggestion);
        }
        this.dumpProposals(uniqueSuggestions);
        return uniqueSuggestions;
    }

    private ICompletionProposal createProposal(String tag, String string, String prefix, int offset, String info, String icon, String pName, String pDesc) {
        return new Proposal(tag, string, prefix, offset, info, icon, pName, pDesc);
    }

    private ICompletionProposal createProposal(String tag, String string, String prefix, int offset, String info, String icon, String pName, String pDesc, ArrayList pImports) {
        return new Proposal(tag, string, prefix, offset, info, icon, pName, pDesc, pImports);
    }

    private static int getPackageStatementOffset() {
        if (cu_ != null) {
            try {
                IPackageDeclaration[] pks = cu_.getPackageDeclarations();
                int i = 0;
                if (i < pks.length) {
                    return pks[0].getSourceRange().getLength() + pks[0].getSourceRange().getOffset();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return 0;
    }

    private static String getPackageStatement() {
        if (cu_ != null) {
            try {
                IPackageDeclaration[] pks = cu_.getPackageDeclarations();
                int i = 0;
                if (i < pks.length) {
                    return pks[0].getSource();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return "";
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        int linelength = doc.getLineLength(doc.getLineOfOffset(offset));
        while (--offset >= 0 && Character.isJavaIdentifierPart(doc.getChar(offset))) {
            ++length;
        }
        String prefix = null;
        if (length == 0) {
            prefix = doc.get(offset, linelength);
            if (prefix.startsWith("@")) {
                return "@";
            }
            return null;
        }
        prefix = doc.get(offset, length + 1);
        return prefix;
    }

    public void dumpProposals(ArrayList list) {
        AnnotationConstants.debug((Object)list.size());
        int i = 0;
        while (i < list.size()) {
            Proposal prop = (Proposal)list.get(i);
            AnnotationConstants.debug((Object)i);
            if (prop != null) {
                AnnotationConstants.debug((Object)(String.valueOf(i) + ":" + prop.fIcon));
                AnnotationConstants.debug((Object)(String.valueOf(i) + ":" + prop.fInfo));
                AnnotationConstants.debug((Object)(String.valueOf(i) + ":" + prop.fDescription));
                AnnotationConstants.debug((Object)(String.valueOf(i) + ":" + prop.fString));
                AnnotationConstants.debug((Object)(String.valueOf(i) + ":" + prop.fPackage));
            }
            ++i;
        }
    }

    public ArrayList processConfigElmFromExtensionPoint(ICompilationUnit cu, int offset) {
        ArrayList configList = new ArrayList();
        try {
            configList = AnnotationConfigInfo.instance().getAnnotationConfigFromExtensionPointInfo(cu, offset);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return configList;
    }

    public String getCurrentScope(int offset) {
        IJavaElement javaElem = AnnotationUIContextHelper.getContextForContentAssist(this.getCompilationUnit(), offset);
        return AnnotationUtils.scopeAsString((IJavaElement)javaElem);
    }

    public String getSpecificType(IJavaElement elm) {
        block4: {
            block5: {
                if (!(elm instanceof IType) || ((IType)elm).getClassFile() == null) break block4;
                if (!((IType)elm).getClassFile().isInterface()) break block5;
                return "INTERFACE";
            }
            try {
                if (((IType)elm).getClassFile().isClass()) {
                    return "CLASS";
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return "CLASS";
    }

    public String enclosingScope(ICompilationUnit cu, int offset) {
        IJavaElement elm;
        block7: {
            block8: {
                elm = cu.getElementAt(offset);
                if (!(elm instanceof IType) || ((IType)elm).getClassFile() == null) break block7;
                if (!((IType)elm).getClassFile().isInterface()) break block8;
                return "INTERFACE";
            }
            if (!((IType)elm).getClassFile().isClass()) break block7;
            return "CLASS";
        }
        try {
            IJavaElement jp;
            if (elm instanceof SourceMethod && (jp = elm.getParent().getParent().getPrimaryElement()) instanceof ICompilationUnit) {
                IType[] elm2 = ((ICompilationUnit)jp).getTypes();
                int k = 0;
                while (k < elm2.length) {
                    if (elm2[k] instanceof IType) {
                        return this.getSpecificType((IJavaElement)elm2[k]);
                    }
                    ++k;
                }
            }
            boolean cfr_ignored_0 = elm instanceof IField;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return "CLASS";
    }

    public ArrayList createSuggestionsFromExtensionPoint(ITextViewer viewer, int offset, String prefix) {
        ArrayList<Proposal> mysuggest = new ArrayList<Proposal>();
        ArrayList configList = this.processConfigElmFromExtensionPoint(cu_, offset);
        try {
            int i = 0;
            while (i < configList.size()) {
                AnnotationConfigElem configElem = (AnnotationConfigElem)configList.get(i);
                String aName = null;
                aName = String.valueOf(configElem.getAnnotationName()) + configElem.getCategoryString();
                String currentScope = this.getCurrentScope(offset);
                ArrayList scopeLists = configElem.getScopeList();
                boolean validScope = false;
                boolean supportClassScope = false;
                boolean supportInterfaceScope = false;
                if (scopeLists != null) {
                    Proposal aProposalWithInitialAtributeVal;
                    if (scopeLists.contains("INTERFACE")) {
                        supportInterfaceScope = true;
                    }
                    if (scopeLists.contains("CLASS")) {
                        supportClassScope = true;
                    }
                    int j = 0;
                    while (j < scopeLists.size()) {
                        if (currentScope.toUpperCase().equals(scopeLists.get(j).toString())) {
                            if (currentScope.toUpperCase().equals("FIELD") || currentScope.toUpperCase().equals("METHOD")) {
                                if (supportInterfaceScope && supportClassScope) {
                                    validScope = true;
                                    j = scopeLists.size();
                                } else if (!supportInterfaceScope && !supportClassScope) {
                                    validScope = true;
                                    j = scopeLists.size();
                                } else if (supportClassScope && !supportInterfaceScope) {
                                    if (this.enclosingScope(cu_, offset).equals("CLASS")) {
                                        validScope = true;
                                        j = scopeLists.size();
                                    }
                                } else if (supportInterfaceScope && !supportClassScope && this.enclosingScope(cu_, offset).equals("INTERFACE")) {
                                    validScope = true;
                                    j = scopeLists.size();
                                }
                                validScope = true;
                                j = scopeLists.size();
                            }
                            validScope = true;
                            j = scopeLists.size();
                        }
                        ++j;
                    }
                    String phrase = configElem.getAnnotationWithDefaultsDesc().toLowerCase();
                    String prefix1 = prefix.toLowerCase();
                    if (prefix1.length() > phrase.length() && prefix1.startsWith(phrase)) {
                        aProposalWithInitialAtributeVal = null;
                        if (configElem.hasDefault()) {
                            aProposalWithInitialAtributeVal = new Proposal(configElem.getAnnotationName(), prefix1, aName, configElem.getAnnotationWithDefaultsDesc(), configElem.getIcon(), configElem.getAnnoPackage(), configElem.getAnnotationDesc(), configElem.getAttributeImports());
                        }
                        if (validScope && aProposalWithInitialAtributeVal != null) {
                            mysuggest.add(aProposalWithInitialAtributeVal);
                        }
                    } else if (prefix1.length() <= phrase.length() && phrase.startsWith(prefix1)) {
                        aProposalWithInitialAtributeVal = null;
                        if (configElem.hasDefault()) {
                            aProposalWithInitialAtributeVal = new Proposal(configElem.getAnnotationName(), prefix, aName, configElem.getAnnotationWithDefaultsDesc(), configElem.getIcon(), configElem.getAnnoPackage(), configElem.getAnnotationDesc(), configElem.getAttributeImports());
                        }
                        if (validScope && aProposalWithInitialAtributeVal != null) {
                            mysuggest.add(aProposalWithInitialAtributeVal);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        AnnotationConstants.debug((Object)("suggestions=" + mysuggest.size()));
        this.dumpProposals(mysuggest);
        return mysuggest;
    }

    private List getSuggestions(ITextViewer viewer, int offset, String prefix) throws BadLocationException {
        ArrayList suggestions = this.createSuggestionsFromExtensionPoint(viewer, offset, prefix);
        suggestions.add(new Proposal(prefix, prefix));
        List uniqueSuggestions = this.makeUnique(suggestions);
        return uniqueSuggestions;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            String prefix = this.getPrefix(viewer, offset);
            if (prefix == null || prefix.length() == 0) {
                return NO_PROPOSALS;
            }
            List suggestions = this.getSuggestions(viewer, offset, prefix);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (Proposal proposal : suggestions) {
                if (proposal.fString.length() <= 0) continue;
                if (proposal.fImports == null || proposal.fImports.isEmpty()) {
                    result.add(this.createProposal(proposal.fTag, proposal.fString, proposal.fPrefix, offset, proposal.fInfo, proposal.fIcon, proposal.fPackage, proposal.fDescription));
                    continue;
                }
                result.add(this.createProposal(proposal.fTag, proposal.fString, proposal.fPrefix, offset, proposal.fInfo, proposal.fIcon, proposal.fPackage, proposal.fDescription, proposal.getFImports()));
            }
            ICompletionProposal[] toArray = result.toArray(new ICompletionProposal[result.size()]);
            return toArray;
        }
        catch (BadLocationException badLocationException) {
            return NO_PROPOSALS;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        if (root_ == null) {
            root_ = ResourcesPlugin.getWorkspace().getRoot();
        }
        return root_;
    }

    public static IWorkspace getWorkspace() {
        if (workspace_ == null) {
            if (root_ == null) {
                root_ = ResourcesPlugin.getWorkspace().getRoot();
            }
            workspace_ = root_.getWorkspace();
        }
        return workspace_;
    }

    public boolean isJavaProject() {
        IJavaProject proj = this.getProject();
        if (proj != null) {
            return ResourceUtils.isTrueJavaProject((IProject)proj.getProject());
        }
        return false;
    }

    private static final class Proposal
    implements IJavaCompletionProposal,
    ICompletionProposal,
    ICompletionProposalExtension,
    ICompletionProposalExtension2,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4 {
        private final String fTag;
        private final String fString;
        private final String fPrefix;
        private final int fOffset;
        private final String fInfo;
        private final String fIcon;
        private final String fPackage;
        private ArrayList fImports;
        private final String fDescription;
        private ArrayList fScopes;

        public Proposal(String tag, String prefix) {
            this.fTag = tag;
            this.fString = "";
            this.fInfo = "";
            this.fOffset = 0;
            this.fPrefix = prefix;
            this.fPackage = "";
            this.fDescription = "";
            this.fIcon = "org.eclipse.jdt.ui.annotation_obj.gif";
            this.fScopes = new ArrayList();
            this.fImports = new ArrayList();
        }

        public Proposal(String tag, String prefix, String string, String additionalInfo, String icon, String pName, String description) {
            this.fTag = tag;
            this.fString = string;
            this.fInfo = additionalInfo;
            this.fOffset = 0;
            this.fPrefix = prefix;
            this.fIcon = icon;
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
        }

        public Proposal(String tag, String prefix, String string, String additionalInfo, String icon, String pName, String description, ArrayList importClasses) {
            this.fTag = tag;
            this.fString = string;
            this.fInfo = additionalInfo;
            this.fOffset = 0;
            this.fPrefix = prefix;
            this.fIcon = icon;
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
            this.fImports = importClasses;
        }

        public Proposal(String tag, String prefix, String string, String additionalInfo, String pName, String description) {
            this.fTag = tag;
            this.fString = string;
            this.fInfo = additionalInfo;
            this.fOffset = 0;
            this.fPrefix = prefix;
            this.fIcon = "org.eclipse.jdt.ui.annotation_obj.gif";
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
            this.fImports = new ArrayList();
        }

        public Proposal(String tag, String string, String prefix, int offset, String additionalInfo, String icon, String pName, String description) {
            this.fTag = tag;
            this.fString = string;
            this.fPrefix = prefix;
            this.fOffset = offset;
            this.fInfo = additionalInfo;
            this.fIcon = icon;
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
        }

        public Proposal(String tag, String string, String prefix, int offset, String additionalInfo, String pName, String description) {
            this.fTag = tag;
            this.fString = string;
            this.fPrefix = prefix;
            this.fOffset = offset;
            this.fInfo = additionalInfo;
            this.fIcon = "org.eclipse.jdt.ui.annotation_obj.gif";
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
        }

        public Proposal(String tag, String string, String prefix, int offset, String additionalInfo, String pName, String description, ArrayList pImports) {
            this.fTag = tag;
            this.fString = string;
            this.fPrefix = prefix;
            this.fOffset = offset;
            this.fInfo = additionalInfo;
            this.fIcon = "org.eclipse.jdt.ui.annotation_obj.gif";
            this.fPackage = pName;
            this.fScopes = new ArrayList();
            this.fDescription = description;
            this.fImports = (ArrayList)pImports.clone();
        }

        public Proposal(String tag, String string, String prefix, int offset, String info, String icon, String name, String desc, ArrayList imports) {
            this.fTag = tag;
            this.fString = string;
            this.fPrefix = prefix;
            this.fOffset = offset;
            this.fInfo = info;
            this.fIcon = "org.eclipse.jdt.ui.annotation_obj.gif";
            this.fPackage = name;
            this.fScopes = new ArrayList();
            this.fDescription = desc;
            this.fImports = (ArrayList)imports.clone();
        }

        public void setScope(ArrayList scopes) {
            if (scopes != null) {
                this.fScopes = new ArrayList();
                int i = 0;
                while (i < scopes.size()) {
                    this.fScopes.add(scopes.get(i));
                    ++i;
                }
            }
        }

        public void apply(IDocument document) {
            this.apply(null, '\u0000', 0, this.fOffset);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fOffset + this.fString.length(), 0);
        }

        public String getAdditionalProposalInfo() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.fInfo);
            buf.append("\n");
            buf.append("<br>");
            if (this.fDescription != null) {
                buf.append(this.fDescription);
            }
            buf.append("\n");
            return buf.toString();
        }

        public String getProposalDescriptionInfo() {
            return String.valueOf(this.fInfo) + "\n" + " --- " + this.fDescription;
        }

        public String getDisplayString() {
            return String.valueOf(this.fString) + " - " + this.fPackage;
        }

        public Image getImage() {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean importAlreadyExist(String pkgName, String tag) {
            if (cu_ == null) return false;
            try {
                IImportDeclaration[] pks = cu_.getImports();
                if (pks == null) return false;
                int i = 0;
                while (true) {
                    if (i >= pks.length) {
                        return false;
                    }
                    StringBuffer fPackageImport = new StringBuffer(this.fPackage);
                    fPackageImport.append(".");
                    fPackageImport.append(tag);
                    if (fPackageImport.toString().equals(pks[i].getElementName())) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean importAlreadyExist(String importClass) {
            if (cu_ == null) return false;
            try {
                IImportDeclaration[] pks = cu_.getImports();
                if (pks == null) return false;
                int i = 0;
                while (true) {
                    if (i >= pks.length) {
                        return false;
                    }
                    if (importClass.equals(pks[i].getElementName())) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            return false;
        }

        public void apply(IDocument document, char trigger, int offset) {
            if (!this.isValidFor(document, offset)) {
                return;
            }
            int pkPos = AdvancedAnnotationProposalProcessor.getPackageStatementOffset();
            String pkStatement = AdvancedAnnotationProposalProcessor.getPackageStatement();
            int prefixIndexStart = this.getPrefixCompletionStart(document, offset);
            try {
                if (!this.fPrefix.contentEquals(new StringBuffer(this.fInfo))) {
                    String replacement;
                    if (offset == this.fOffset) {
                        replacement = this.fInfo.substring(offset - this.fOffset);
                        document.replace(prefixIndexStart, this.fPrefix.length(), replacement);
                    } else {
                        replacement = this.fInfo.substring(offset - this.fOffset);
                        document.replace(prefixIndexStart + (offset - this.fOffset), this.fPrefix.length(), replacement);
                    }
                    StringBuffer importBuf = new StringBuffer();
                    importBuf.append(pkStatement);
                    if (this.fImports != null) {
                        int k = 0;
                        while (k < this.fImports.size()) {
                            String thisImport = (String)this.fImports.get(k);
                            if (thisImport != null && !this.importAlreadyExist(thisImport)) {
                                if (k == 0) {
                                    importBuf.append("\n");
                                }
                                importBuf.append("import ");
                                importBuf.append(thisImport);
                                importBuf.append(";");
                                importBuf.append("\n");
                            }
                            ++k;
                        }
                    }
                    if (!this.importAlreadyExist(this.fPackage, this.fTag)) {
                        importBuf.append("\n");
                        importBuf.append("import ");
                        importBuf.append(this.fPackage);
                        importBuf.append(".");
                        importBuf.append(this.fTag);
                        importBuf.append(";");
                        importBuf.append("\n");
                    }
                    if (importBuf != null && importBuf.length() > 0) {
                        document.replace(0, pkPos, importBuf.toString());
                    }
                }
            }
            catch (BadLocationException x) {
                x.printStackTrace();
            }
        }

        public boolean isValidFor(IDocument document, int offset) {
            return this.validate(document, offset, null);
        }

        public char[] getTriggerCharacters() {
            return new char[64];
        }

        public int getContextInformationPosition() {
            return 0;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            this.apply(viewer.getDocument(), trigger, offset);
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            try {
                String tempstr2;
                int prefixStart = this.fOffset - this.fPrefix.length();
                AnnotationConstants.debug((Object)("validate :" + offset + "  fOffset:" + this.fOffset + ":"));
                AnnotationConstants.debug((Object)("str1=" + document.get(prefixStart, offset - prefixStart)));
                AnnotationConstants.isDebug_ = false;
                String tempstr1 = document.get(prefixStart, offset - prefixStart);
                if (tempstr1 != null) {
                    tempstr1 = tempstr1.substring(1).toLowerCase();
                }
                if ((tempstr2 = this.fString) != null) {
                    tempstr2 = tempstr2.toLowerCase();
                }
                return offset >= this.fOffset && offset < this.fOffset + this.fString.length() && tempstr2.startsWith(tempstr1);
            }
            catch (BadLocationException x) {
                x.printStackTrace();
                return false;
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return this.fOffset - this.fPrefix.length();
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            if (this.fString.startsWith(this.fPrefix)) {
                return String.valueOf(this.fString) + " - " + this.fPackage;
            }
            return null;
        }

        public int getRelevance() {
            return 0;
        }

        public static IProject getProjectOf(String projectName) {
            if (projectName != null) {
                return AdvancedAnnotationProposalProcessor.getWorkspaceRoot().getProject(projectName);
            }
            return null;
        }

        public ArrayList getFImports() {
            return this.fImports;
        }
    }
}

