/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.uiextensions;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationViewOverlayInfo;
import com.ibm.etools.annotations.ui.internal.listeners.DecorateAttributeListener;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributePropertyGroup;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AttributeTreeProperty;
import com.ibm.etools.annotations.ui.internal.properties.JavaElementNodeProperty;
import com.ibm.etools.annotations.ui.internal.registry.AnnotationAttributeInputContributorInfo;
import com.ibm.etools.annotations.ui.internal.registry.AnnotationUIExtensionRegistry;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.ITreeProperty;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.utilities.IPropertyUIWidgetFactory;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetTree;
import com.ibm.propertygroup.ui.listener.IPropertyUIChangeListener;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import com.ibm.propertygroup.ui.widgets.PropertyUIScrollableComposite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.widgets.PropertySheetWidgetFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AnnotationTreePropertyUIWidget
extends PropertyUIWidgetTree {
    protected Image attributesImage_ = Activator.getImageDescriptor("icons/obj16/attribute_list.gif").createImage();
    protected Image jpaDetailsImage_ = Activator.getImageDescriptor("icons/obj16/jpa_details.gif").createImage();
    protected TabFolder tabFolder_ = null;
    protected DecorateAttributeListener iListener_;
    protected Composite javaElementInfoArea_;

    public AnnotationTreePropertyUIWidget(IPropertyDescriptor property, IPropertyUIWidgetFactory factory) {
        super(property, factory);
    }

    public AnnotationTreePropertyUIWidget(IPropertyDescriptor property, IPropertyUIWidgetFactory factory, int columnNo) {
        super(property, factory);
    }

    protected void createContainers(Composite parent) {
        int orientation = 256;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM) {
            orientation = 512;
        }
        this.sashForm_ = this.factory_.createSashForm(parent, orientation);
        Composite treeComposite = this.factory_.createComposite((Composite)this.sashForm_, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM && ((ITreeProperty)this.property_).isSelectableTree()) {
            layout.numColumns = 2;
        }
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)new GridData(1808));
        Composite comp = this.factory_.createComposite((Composite)this.sashForm_, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        if (this.propertiesShowingPosition_ == PROPERTIES_AREA_SHOWING_POSITION_BOTTOM && ((ITreeProperty)this.property_).isSelectableTree()) {
            layout.numColumns = 2;
        }
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        Composite group = this.factory_.createComposite(comp, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        this.iListener_ = new DecorateAttributeListener();
    }

    protected void displayProperties(final IPropertyGroup properties, TreeItem oldItem, final TreeItem newItem) {
        this.propertiesArea_.setContent(null);
        if (this.propertyUIComposite_ != null) {
            this.propertyUIComposite_.dispose();
            this.propertyUIComposite_ = null;
        }
        if (this.tabFolder_ != null && !this.tabFolder_.isDisposed()) {
            int i = 0;
            while (i < this.tabFolder_.getItemCount()) {
                Control control = this.tabFolder_.getItem(i).getControl();
                if (control != null && !control.isDisposed()) {
                    control.dispose();
                }
                ++i;
            }
            this.tabFolder_.dispose();
            this.tabFolder_ = null;
        }
        if (this.javaElementInfoArea_ != null) {
            this.javaElementInfoArea_.dispose();
            this.javaElementInfoArea_ = null;
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] jpaData = null;
                if (newItem != null) {
                    jpaData = AnnotationTreePropertyUIWidget.this.getJPAData(newItem.getData());
                }
                if (properties == null) {
                    if (jpaData == null) {
                        Label content;
                        if (newItem != null && newItem.getData() instanceof JavaElementNodeProperty) {
                            AnnotationTreePropertyUIWidget.this.javaElementInfoArea_ = AnnotationTreePropertyUIWidget.this.createJavaElementInfoArea((Composite)AnnotationTreePropertyUIWidget.this.propertiesArea_, newItem);
                            content = AnnotationTreePropertyUIWidget.this.javaElementInfoArea_;
                        } else {
                            Control control = AnnotationTreePropertyUIWidget.this.propertiesArea_.getContent();
                            if (control != null && !control.equals(AnnotationTreePropertyUIWidget.this.noProperties_)) {
                                control.dispose();
                            }
                            content = AnnotationTreePropertyUIWidget.this.noProperties_;
                        }
                        AnnotationTreePropertyUIWidget.this.propertiesArea_.setContent((Control)content);
                        AnnotationTreePropertyUIWidget.this.propertiesArea_.setMinSize(content.computeSize(-1, -1));
                    } else if (newItem != null && newItem.getData() instanceof JavaElementNodeProperty) {
                        AnnotationTreePropertyUIWidget.this.javaElementInfoArea_ = AnnotationTreePropertyUIWidget.this.createJavaElementInfoArea((Composite)AnnotationTreePropertyUIWidget.this.propertiesArea_, newItem);
                        AnnotationTreePropertyUIWidget.this.propertiesArea_.setContent((Control)AnnotationTreePropertyUIWidget.this.javaElementInfoArea_);
                        AnnotationTreePropertyUIWidget.this.propertiesArea_.setMinSize(AnnotationTreePropertyUIWidget.this.javaElementInfoArea_.computeSize(-1, -1));
                    } else {
                        JpaStructureNode contentNode = (JpaStructureNode)jpaData[0];
                        JpaDetailsProvider provider = (JpaDetailsProvider)jpaData[1];
                        Composite container = ((PropertyUIWidget)AnnotationTreePropertyUIWidget.this).factory_.createComposite((Composite)AnnotationTreePropertyUIWidget.this.propertiesArea_, 0);
                        container.setLayout((Layout)new FillLayout(512));
                        JpaDetailsPage page = provider.buildDetailsPage(container, (Object)contentNode.getId(), (WidgetFactory)new PropertySheetWidgetFactory(new TabbedPropertySheetWidgetFactory()));
                        if (page != null) {
                            page.setSubject(contentNode);
                        } else {
                            ((PropertyUIWidget)AnnotationTreePropertyUIWidget.this).factory_.createLabel(container, AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_JPA_DEFAULT, 64);
                        }
                        AnnotationTreePropertyUIWidget.this.propertiesArea_.setContent((Control)container);
                    }
                } else if (jpaData == null) {
                    AnnotationTreePropertyUIWidget.this.generateOriginalLayout(properties, newItem);
                } else {
                    AnnotationTreePropertyUIWidget.this.tabFolder_ = AnnotationTreePropertyUIWidget.this.createTabContainers((Composite)AnnotationTreePropertyUIWidget.this.propertiesArea_);
                    PropertyUIScrollableComposite comp = (PropertyUIScrollableComposite)AnnotationTreePropertyUIWidget.this.tabFolder_.getItem(1).getControl();
                    AnnotationTreePropertyUIWidget.this.generatePropertyGroupLayout((Composite)comp, properties, newItem);
                    comp.setContent((Control)AnnotationTreePropertyUIWidget.this.propertyUIComposite_.getComposite());
                    JpaStructureNode contentNode = (JpaStructureNode)jpaData[0];
                    JpaDetailsProvider provider = (JpaDetailsProvider)jpaData[1];
                    Composite container = (Composite)AnnotationTreePropertyUIWidget.this.tabFolder_.getItem(0).getControl();
                    JpaDetailsPage page = provider.buildDetailsPage(container, (Object)contentNode.getId(), (WidgetFactory)new PropertySheetWidgetFactory(new TabbedPropertySheetWidgetFactory()));
                    if (page != null) {
                        page.setSubject(contentNode);
                    } else {
                        ((PropertyUIWidget)AnnotationTreePropertyUIWidget.this).factory_.createLabel(container, AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_JPA_DEFAULT, 64);
                    }
                    AnnotationTreePropertyUIWidget.this.propertiesArea_.setContent((Control)AnnotationTreePropertyUIWidget.this.tabFolder_);
                }
                if (AnnotationTreePropertyUIWidget.this.propertyUIComposite_ != null) {
                    AnnotationTreePropertyUIWidget.this.iListener_.setPropertyUIComposite(AnnotationTreePropertyUIWidget.this.propertyUIComposite_);
                }
            }
        });
    }

    protected Object[] getJPAData(Object nodeData) {
        int offset;
        if (nodeData instanceof AnnotationNodeProperty) {
            AnnotationInfo info = ((AnnotationNodeProperty)((Object)nodeData)).getAnnotationInfo();
            if (info.getCategorizationKey() != null && info.getCategorizationKey().equals("javax.persistence") && info.getOffset() > -1) {
                return this.getJPAData((IFile)((AttributeTreeProperty)this.getProperty()).getCompilationUnit().getResource(), info.getOffset());
            }
        } else if (nodeData instanceof JavaElementNodeProperty && (offset = ((JavaElementNodeProperty)((Object)nodeData)).getJavaElementOffset()) > 0) {
            return this.getJPAData((IFile)((AttributeTreeProperty)this.getProperty()).getCompilationUnit().getResource(), offset);
        }
        return null;
    }

    protected Object[] getJPAData(IFile file, int offset) {
        JpaStructureNode contentNode = null;
        JpaDetailsProvider provider = null;
        JpaFile jpaFile = JptCorePlugin.getJpaFile((IFile)file);
        if (jpaFile != null) {
            contentNode = jpaFile.getStructureNode(offset);
            String platformId = contentNode.getJpaProject().getJpaPlatform().getId();
            provider = JpaPlatformUiRegistry.instance().jpaPlatform(platformId).detailsProvider(contentNode);
        }
        if (contentNode != null && provider != null) {
            return new Object[]{contentNode, provider};
        }
        return null;
    }

    protected Composite createJavaElementInfoArea(Composite parent, TreeItem treeItem) {
        Composite container = this.factory_.createComposite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Section area = this.factory_.createSection(container, 274);
        area.setText("Annotation summary");
        area.setExpanded(true);
        area.setLayoutData((Object)new GridData(1808));
        area.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AnnotationTreePropertyUIWidget.this.relayoutParents((Composite)((ExpandableComposite)e.getSource()));
            }
        });
        Composite comp = this.factory_.createComposite((Composite)area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        area.setClient((Control)comp);
        Label label = this.factory_.createLabel(comp, 64);
        StringBuffer desc = new StringBuffer("'").append(treeItem.getText()).append("'").append(" - ");
        ArrayList<TreeItem> annotions = new ArrayList<TreeItem>();
        this.treeViewer_.expandToLevel(treeItem.getData(), 1);
        TreeItem[] children = treeItem.getItems();
        int i = 0;
        while (i < treeItem.getItemCount()) {
            if (children[i].getData() instanceof AnnotationNodeProperty) {
                annotions.add(children[i]);
            }
            ++i;
        }
        int apNo = annotions.size();
        if (apNo < 2) {
            desc.append(apNo).append(" annotation.");
        } else {
            desc.append(apNo).append(" annotations.");
        }
        label.setText(desc.toString());
        int i2 = 0;
        while (i2 < apNo) {
            final TreeItem item = (TreeItem)annotions.get(i2);
            final Hyperlink link = new Hyperlink(comp, 0);
            link.setUnderlined(true);
            link.setText(item.getText());
            GridData gd = new GridData(768);
            gd.horizontalIndent = 13;
            link.setLayoutData((Object)gd);
            link.setForeground(comp.getDisplay().getSystemColor(10));
            link.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                    link.setForeground(link.getDisplay().getSystemColor(9));
                }

                public void linkExited(HyperlinkEvent e) {
                    link.setForeground(link.getDisplay().getSystemColor(10));
                }

                public void linkActivated(HyperlinkEvent e) {
                    AnnotationTreePropertyUIWidget.this.treeViewer_.setSelection((ISelection)new StructuredSelection(item.getData()), true);
                    AnnotationTreePropertyUIWidget.this.treeViewer_.getTree().setFocus();
                }
            });
            ++i2;
        }
        return container;
    }

    protected void relayoutParents(Composite comp) {
        if (comp == null || comp.isDisposed()) {
            return;
        }
        comp.layout();
        Composite parent = comp.getParent();
        if (parent != null) {
            if (parent instanceof PropertyUIScrollableComposite) {
                ((PropertyUIScrollableComposite)parent).reflow(true);
            } else if (parent instanceof ScrolledComposite) {
                Point p = comp.computeSize(-1, -1);
                comp.setSize(p.x, p.y);
                ((ScrolledComposite)parent).setMinSize(p);
                parent.layout();
            } else {
                this.relayoutParents(parent);
            }
        }
    }

    protected void generatePropertyGroupLayout(Composite parent, IPropertyGroup properties, TreeItem newItem) {
        List<IAnnotationAttributeProperty> pl = this.removePropertyChangeListeners(properties);
        this.propertyUIComposite_ = this.uiFactory_.generatePropertyUI(parent, properties);
        this.addPropertyChangeListeners(pl);
        Control[] children = this.propertyUIComposite_.getPrimaryArea().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Section) {
                GridLayout layout = (GridLayout)((Composite)((Section)children[i]).getClient()).getLayout();
                layout.marginWidth = 5;
            }
            ++i;
        }
        if (this.propertyUIChangeListener_ == null) {
            this.propertyUIChangeListener_ = new PropertyUIWidgetTree.PropertyUIChangeListenerImpl((PropertyUIWidgetTree)this);
        }
        this.propertyUIChangeListener_.setTreeNode((INodeProperty)newItem.getData());
        this.propertyUIComposite_.addPropertyUIChangeListener((IPropertyUIChangeListener)this.propertyUIChangeListener_);
    }

    protected List<IAnnotationAttributeProperty> removePropertyChangeListeners(IPropertyGroup properties) {
        ArrayList<IAnnotationAttributeProperty> pls = new ArrayList<IAnnotationAttributeProperty>();
        IPropertyDescriptor[] ipds = properties.getProperties();
        if (ipds != null) {
            int i = 0;
            while (i < ipds.length) {
                if (ipds[i] instanceof SingleValueArgumentProperty) {
                    List<IPropertyChangeListener> listeners;
                    IPropertyDescriptor parent;
                    Object[] validValues = ((SingleValueArgumentProperty)ipds[i]).getPropertyType().getValidValues();
                    if (validValues != null && validValues.length > 0 && (parent = ipds[i].getParent()) != null && parent instanceof AnnotationAttributePropertyGroup && (listeners = ((AnnotationAttributePropertyGroup)parent).getAttributeListeners()) != null) {
                        int j = 0;
                        while (j < listeners.size()) {
                            IPropertyChangeListener lst = listeners.get(j);
                            ipds[i].removePropertyChangeListener(lst);
                            pls.add((IAnnotationAttributeProperty)ipds[i]);
                            ++j;
                        }
                    }
                } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                    List<IAnnotationAttributeProperty> subPLs = this.removePropertyChangeListeners((IPropertyGroup)ipds[i]);
                    pls.addAll(subPLs);
                }
                ++i;
            }
        }
        return pls;
    }

    protected void addPropertyChangeListeners(List<IAnnotationAttributeProperty> properties) {
        int i = 0;
        while (i < properties.size()) {
            IAnnotationAttributeProperty iaap = properties.get(i);
            AnnotationAttributePropertyGroup parent = (AnnotationAttributePropertyGroup)iaap.getParent();
            List<IPropertyChangeListener> listeners = parent.getAttributeListeners();
            if (listeners != null) {
                int j = 0;
                while (j < listeners.size()) {
                    IPropertyChangeListener lst = listeners.get(j);
                    iaap.addPropertyChangeListener(lst);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void generateOriginalLayout(IPropertyGroup properties, TreeItem newItem) {
        Composite main = null;
        IPropertyDescriptor[] children = null;
        if (properties != null) {
            children = properties.getProperties();
        }
        if (children == null || children.length < 1) {
            main = this.factory_.createComposite((Composite)this.propertiesArea_, 0);
            main.setLayout((Layout)new GridLayout());
            main.setLayoutData((Object)new GridData(1808));
            Section area = this.factory_.createSection(main, 274);
            area.setText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES);
            area.setExpanded(true);
            GridData gd = new GridData(768);
            area.setLayoutData((Object)gd);
            Composite comp = this.factory_.createComposite((Composite)area, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 2;
            layout.marginHeight = 2;
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(1808));
            comp.setFont(area.getFont());
            area.setClient((Control)comp);
            this.factory_.createLabel(comp, AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_NO_ATTRIBUTES_DEFINED, 64);
        } else {
            this.assignCustomizedInfo(properties);
            this.generatePropertyGroupLayout((Composite)this.propertiesArea_, properties, newItem);
            main = this.propertyUIComposite_.getComposite();
        }
        this.propertiesArea_.setContent((Control)main);
        Point p = main.computeSize(-1, -1);
        main.setSize(p.x, p.y);
        this.propertiesArea_.setMinSize(p);
    }

    protected void assignCustomizedInfo(IPropertyGroup properties) {
        IPropertyDescriptor[] ipds = properties.getProperties();
        if (ipds != null && ipds.length > 0) {
            int i = 0;
            while (i < ipds.length) {
                if (ipds[i] instanceof IAnnotationAttributeProperty) {
                    AnnotationInfo annoInfo = ((IAnnotationAttributeProperty)ipds[i]).getParentAnnotation();
                    if (annoInfo != null) {
                        String pkgName = annoInfo.getCategorizationKey();
                        String tagName = annoInfo.getName();
                        String attribute = ipds[i].getName();
                        AnnotationAttributeInputContributorInfo info = AnnotationUIExtensionRegistry.instance().getAttributeInputContributor(pkgName, tagName, attribute);
                        if (info != null && "DEFAULT_PROPERTY_IDENTIFIER".equals(ipds[i].getID())) {
                            try {
                                ipds[i].assignID(info.getAttributeInputContributorID());
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else if (PropertyHelper.isPropertyGroup((IPropertyDescriptor)ipds[i])) {
                    this.assignCustomizedInfo((IPropertyGroup)ipds[i]);
                }
                ++i;
            }
        }
    }

    protected TabFolder createTabContainers(Composite parent) {
        TabFolder tabFolder = this.factory_.createTabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem item = this.factory_.createTabItem(tabFolder, 0, 0);
        item.setText(AnnotationsUIMessages.ANNOTATIONS_UI_TAB_JPA_DETAILS);
        item.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_TAB_JPA_DETAILS_DESC);
        String path = AnnotationViewOverlayInfo.instance().getIcon("javax.persistence");
        if (path != null) {
            this.jpaDetailsImage_ = Activator.getImageDescriptor(path).createImage();
        }
        item.setImage(this.jpaDetailsImage_);
        Composite subContainer = this.factory_.createComposite((Composite)tabFolder, 0);
        subContainer.setLayout((Layout)new FillLayout(512));
        item.setControl((Control)subContainer);
        item = this.factory_.createTabItem(tabFolder, 0, 1);
        item.setText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES);
        item.setToolTipText(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES_DESC);
        item.setImage(this.attributesImage_);
        PropertyUIScrollableComposite container = this.factory_.createPropertyUIScrollableComposite((Composite)tabFolder, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        item.setControl((Control)container);
        return tabFolder;
    }

    public void dispose() {
        super.dispose();
        if (!this.attributesImage_.isDisposed()) {
            this.attributesImage_.dispose();
        }
        if (!this.jpaDetailsImage_.isDisposed()) {
            this.jpaDetailsImage_.dispose();
        }
        if (this.iListener_ != null) {
            this.iListener_.dispose();
        }
    }
}

