/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.providers;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationCategoryElement;
import com.ibm.etools.annotations.ui.internal.data.AnnotationViewOverlayInfo;
import com.ibm.etools.annotations.ui.internal.providers.AnnotationUIDecorator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AnnotationLabelProvider
extends LabelProvider {
    private Hashtable<String, Image> allocatedImages_ = new Hashtable();
    private AnnotationUIDecorator decorator_ = new AnnotationUIDecorator();

    public Image getImage(Object element) {
        if (element instanceof AnnotationCategoryElement) {
            String pkgName = ((AnnotationCategoryElement)element).getName();
            String iconPath = AnnotationViewOverlayInfo.instance().getIconFromPackage(pkgName);
            if (iconPath != null) {
                return this.getImageFromFile(iconPath);
            }
            iconPath = AnnotationViewOverlayInfo.instance().getIconFromLabel(pkgName);
            if (iconPath != null) {
                return this.getImageFromFile(iconPath);
            }
            return this.getImageFromFile("icons/obj16/annotation_package.gif");
        }
        if (element instanceof AnnotationInfo) {
            String pkgName = ((AnnotationInfo)element).getPackageName();
            String annoovrPath = AnnotationViewOverlayInfo.instance().getAnnoIconFromPackage(pkgName);
            Image image = this.getImageFromFile("icons/obj16/annotation2.gif");
            if (((AnnotationInfo)element).isImpliedAnnotation()) {
                return this.decorator_.decorateImage(image, this.getImageFromFile("icons/ovr16/imply_ovr.gif"));
            }
            if (annoovrPath != null) {
                return this.decorator_.decorateImage(image, this.getImageFromFile(annoovrPath));
            }
            return image;
        }
        return null;
    }

    protected Image getImageFromFile(String imageFileName) {
        if (imageFileName != null) {
            Image im = this.allocatedImages_.get(imageFileName);
            if (im != null) {
                return im;
            }
            im = Activator.getImageDescriptor(imageFileName).createImage();
            this.allocatedImages_.put(imageFileName, im);
            return im;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof AnnotationCategoryElement) {
            return AnnotationViewOverlayInfo.instance().getLabel(((AnnotationCategoryElement)element).getName());
        }
        if (element instanceof AnnotationInfo) {
            return ((AnnotationInfo)element).getName();
        }
        return "";
    }

    public void dispose() {
        super.dispose();
        Enumeration<Image> ims = this.allocatedImages_.elements();
        while (ims.hasMoreElements()) {
            Image i = ims.nextElement();
            if (i.isDisposed()) continue;
            i.dispose();
        }
        this.allocatedImages_.clear();
        this.decorator_.dispose();
    }
}

