/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.properties;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.ArrayAnnotationArgumentProperty;
import com.ibm.etools.annotations.core.properties.SingleAnnotationArgumentProperty;
import com.ibm.etools.annotations.ui.internal.data.AnnotationAttributeNodeSynchronizer;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributeNodeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributePropertyGroup;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.propertygroup.INodeProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.IPropertyGroup;
import com.ibm.propertygroup.spi.BaseNodeProperty;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class AnnotationNodeProperty
extends BaseNodeProperty {
    protected AnnotationInfo info_;
    protected AnnotationAttributeNodeSynchronizer aaNodeSynchronizer_;

    public AnnotationNodeProperty(AnnotationInfo info, List<IPropertyChangeListener> listeners) throws CoreException {
        this(info, listeners, null);
    }

    public AnnotationNodeProperty(AnnotationInfo info, List<IPropertyChangeListener> listeners, AnnotationAttributeNodeSynchronizer synchronizer) throws CoreException {
        super(info.getName(), info.getName(), info.getName());
        this.info_ = info;
        this.aaNodeSynchronizer_ = synchronizer;
        this.initProperty(listeners);
    }

    protected void initProperty(List<IPropertyChangeListener> listener) throws CoreException {
        String name = this.info_.getName();
        ArrayList<IAnnotationAttributeProperty> annotationAttributes = new ArrayList<IAnnotationAttributeProperty>();
        BasePropertyGroup pg = new BasePropertyGroup(name, name, name);
        List attributes = this.info_.getAllAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            AnnotationAttributePropertyGroup attrPG = new AnnotationAttributePropertyGroup(AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES, AnnotationsUIMessages.ANNOTATIONS_UI_PROPERTYGROUP_ATTRIBUTES_DESC, listener);
            pg.addProperty((IPropertyDescriptor)attrPG);
            ArrayList<IAnnotationAttributeProperty> attriList = AnnotationUIUtils.sortAttributeList(attributes);
            int i = 0;
            while (i < attriList.size()) {
                IAnnotationAttributeProperty info = attriList.get(i);
                if (listener != null) {
                    int j = 0;
                    while (j < listener.size()) {
                        IPropertyChangeListener lst = listener.get(j);
                        info.removePropertyChangeListener(lst);
                        info.addPropertyChangeListener(lst);
                        ++j;
                    }
                }
                attrPG.addProperty((IPropertyDescriptor)info);
                if (info instanceof SingleAnnotationArgumentProperty || info instanceof ArrayAnnotationArgumentProperty) {
                    annotationAttributes.add(info);
                }
                ++i;
            }
        }
        this.setConfigurationParameters((IPropertyGroup)pg);
        this.applyConfigurationProperties((IPropertyGroup)pg);
        if (!annotationAttributes.isEmpty()) {
            int i = 0;
            while (i < annotationAttributes.size()) {
                AnnotationAttributeNodeProperty aanp = new AnnotationAttributeNodeProperty((IAnnotationAttributeProperty)annotationAttributes.get(i), listener);
                this.addChild((INodeProperty)aanp);
                if (this.aaNodeSynchronizer_ != null) {
                    this.aaNodeSynchronizer_.registerAttributeNode(aanp);
                }
                ++i;
            }
        }
    }

    public void removePropertyChangeListeners(List<IPropertyChangeListener> listeners) {
        IPropertyGroup pg = this.getActiveConfigurationProperties();
        if (pg != null) {
            if (pg instanceof AnnotationAttributePropertyGroup) {
                ((AnnotationAttributePropertyGroup)pg).removePropertyChangeListeners(listeners);
            }
            IPropertyDescriptor[] attriList = pg.getProperties();
            int i = 0;
            while (i < attriList.length) {
                int j = 0;
                while (j < listeners.size()) {
                    attriList[i].removePropertyChangeListener(listeners.get(j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public INodeProperty getDeclaredNodeProperty() {
        return this;
    }

    public INodeProperty getUnDeclaredNodeProperty() {
        return this;
    }

    public AnnotationInfo getAnnotationInfo() {
        return this.info_;
    }

    public String getAnnotationLabel() {
        return AnnotationUIUtils.getAnnotationInfoLabel(this.info_);
    }
}

