/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.override;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationOverrideInfo;
import com.ibm.etools.annotations.core.data.JavaElementInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigDDOverrideInfo;
import com.ibm.etools.annotations.core.internal.AnnotationParser;
import com.ibm.etools.annotations.core.utils.AnnotationOverrideHelper;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.override.DDOverrideAnnotationListener;
import com.ibm.etools.annotations.ui.internal.override.DDOverrideIndicator;
import com.ibm.propertygroup.IPropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public class DDOverrideIndicatorHelper {
    protected Hashtable<String, Annotation> aOverrideIndicatorLists;
    protected List list;
    protected static IAnnotationModel fDDAnnotationModel_;
    private static DDOverrideAnnotationListener ovrDDListener_;
    protected static Hashtable<String, AnnotationParser> annotationParsers;
    public static boolean debugflag;
    private static Hashtable<String, Annotation> aNewIndicatorList;
    private static Hashtable<String, Position> aNewIndicatorPositionList;
    private static Hashtable<ICompilationUnit, AnnotatedClassInfo> aAnnotatedModelList;
    private static boolean trackResource;
    private static ArrayList FilesICare;

    static {
        ovrDDListener_ = null;
        annotationParsers = new Hashtable();
        debugflag = false;
        trackResource = false;
        FilesICare = new ArrayList();
    }

    protected static void dumpStatic() {
        if (debugflag) {
            System.out.println("overrideListner=" + ovrDDListener_);
            System.out.println("hashtable:FilesICare=" + FilesICare);
            if (FilesICare != null) {
                System.out.println("hashtable:FilesICare.size()=" + FilesICare.size());
            }
            System.out.println("hashtable:aAnnotatedModelList=" + aAnnotatedModelList);
            if (aAnnotatedModelList != null) {
                System.out.println("hashtable:aAnnotatedModelList.size()=" + aAnnotatedModelList.size());
            }
            System.out.println("hashtable:aNewIndicatorPositionList=" + aNewIndicatorPositionList);
            if (aNewIndicatorPositionList != null) {
                System.out.println("hashtable:aNewIndicatorPositionList.size=" + aNewIndicatorPositionList.size());
            }
            System.out.println("hashtable: annotationParsers=" + annotationParsers);
            if (annotationParsers != null) {
                System.out.println("hashtable: annotationParsers.size=" + annotationParsers.size());
            }
        }
        debugflag = false;
    }

    protected static DDOverrideAnnotationListener getListenerInstance() {
        if (ovrDDListener_ == null) {
            ovrDDListener_ = DDOverrideAnnotationListener.getInstance();
        }
        return ovrDDListener_;
    }

    protected static void addListenerToFilesICare(String sourceResource) {
        if (!trackResource) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)DDOverrideIndicatorHelper.getListenerInstance(), 1);
            trackResource = true;
        }
        if (!FilesICare.contains(sourceResource)) {
            FilesICare.add(sourceResource);
        }
    }

    protected static void removeSourceOverrideFileListener() {
        if (!FilesICare.isEmpty()) {
            FilesICare.clear();
        }
        if (ovrDDListener_ != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)ovrDDListener_);
            ovrDDListener_ = null;
            trackResource = false;
        }
    }

    protected static void calculateAnnotationOverrides(List aInfo_, IProject project_) {
        aNewIndicatorList = new Hashtable();
        aNewIndicatorPositionList = new Hashtable();
        int i = 0;
        while (i < aInfo_.size()) {
            AnnotationOverrideInfo annoOverInfo;
            String currentFileName = null;
            AnnotationInfo aI = (AnnotationInfo)aInfo_.get(i);
            if (aI.getParentJavaElementInfo() != null && aI.getParentJavaElementInfo().getJavaElement() != null) {
                project_ = aI.getParentJavaElementInfo().getJavaElement().getJavaProject().getProject();
                currentFileName = aI.getParentJavaElementInfo().getJavaElement().getPath().toString();
                if (FilesICare != null && !FilesICare.contains(currentFileName)) {
                    FilesICare.add(currentFileName);
                }
            }
            IAnnotation aa = aI.getAnnotation();
            DDOverrideIndicatorHelper.debug("aa=" + aa + "project_=" + project_ + "name=" + aI.getName());
            DDOverrideIndicatorHelper.debug("offset=" + aI.getOffset());
            String pkName = aI.getPackageName();
            String annotationName = String.valueOf(pkName) + "." + aI.getName();
            String simpleName = aI.getName();
            int offset = aI.getOffset();
            String OverrideID = AnnotationConfigDDOverrideInfo.instance().hasRegisterOverrideId(pkName, simpleName);
            if (OverrideID != null && (annoOverInfo = AnnotationConfigDDOverrideInfo.instance().getOverrideValues(pkName, simpleName, project_, currentFileName, aI, offset)) != null) {
                DDOverrideIndicator annoMarker;
                String stringValues = AnnotationOverrideHelper.getStringOverrideValues((AnnotationOverrideInfo)annoOverInfo);
                StringBuffer key = new StringBuffer(annotationName);
                key.append(offset);
                String indicatorKey = key.toString();
                String description = null;
                boolean hasAttributes = true;
                if (stringValues == null || stringValues.isEmpty() || stringValues.equals("")) {
                    hasAttributes = false;
                }
                description = hasAttributes ? AnnotationConfigDDOverrideInfo.instance().getDescription(aI.getPackageName(), aI.getName(), project_) : AnnotationsUIMessages.ANNOTATION_DD_DEFINED;
                String OverrideFile = annoOverInfo.getSourceOverride();
                StringBuffer indicatorText = new StringBuffer("@");
                indicatorText.append(aI.getName());
                indicatorText.append(":");
                indicatorText.append(" \n");
                if (description != null) {
                    indicatorText.append(description);
                } else {
                    indicatorText.append(AnnotationsUIMessages.ANNOTATION_DD_VALUES);
                }
                indicatorText.append(" \n");
                if (OverrideFile != null) {
                    indicatorText.append(OverrideFile);
                    DDOverrideIndicatorHelper.addListenerToFilesICare(OverrideFile);
                }
                if (hasAttributes) {
                    indicatorText.append(" ---- @");
                    indicatorText.append(aI.getName());
                    indicatorText.append(stringValues);
                }
                if ((annoMarker = DDOverrideIndicatorHelper.createAnnotationDDIndicator(OverrideID, simpleName, project_, indicatorText.toString())) != null) {
                    int length = annoMarker.getText().length();
                    aNewIndicatorList.put(indicatorKey, annoMarker);
                    aNewIndicatorPositionList.put(indicatorKey, new Position(offset, length));
                }
            }
            ++i;
        }
    }

    private static DDOverrideIndicator createAnnotationDDIndicator(String OverrideID, String annotationName, IProject project, String indicatorText) {
        try {
            StringBuffer overrideIndicatorId = new StringBuffer("com.ibm.etools.annotations.ui.overrideDD");
            overrideIndicatorId.append(".");
            overrideIndicatorId.append(OverrideID);
            DDOverrideIndicator annoMarker = new DDOverrideIndicator(overrideIndicatorId.toString(), indicatorText.toString(), OverrideID, project);
            return annoMarker;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static AnnotatedClassInfo getAnnotatedModel(ICompilationUnit compUnit, DDOverrideAnnotationListener lis) {
        AnnotatedClassInfo model = null;
        if (compUnit != null) {
            try {
                if (aAnnotatedModelList == null) {
                    aAnnotatedModelList = new Hashtable();
                } else {
                    model = aAnnotatedModelList.get(compUnit);
                }
                DDOverrideIndicatorHelper.debug("existing model=" + model + " compuUnit=" + compUnit);
                if (model == null && (model = AnnotationUtils.getAnnotatedClassInfo((IJavaElement)compUnit)) != null) {
                    model.makeSourceListener(true);
                    model.removePropertyChangeListener((IPropertyChangeListener)lis);
                    model.addPropertyChangeListener((IPropertyChangeListener)lis);
                    DDOverrideIndicatorHelper.addModelChangedListener((JavaElementInfo)model, lis);
                    DDOverrideIndicatorHelper.debug("add New model=" + model + " compuUnit=" + compUnit);
                    aAnnotatedModelList.put(compUnit, model);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return model;
    }

    protected static void removeModelFromList(ICompilationUnit cu) {
        if (aAnnotatedModelList != null && cu != null) {
            aAnnotatedModelList.remove(cu);
        }
    }

    protected static void removeListeners(ICompilationUnit cu, DDOverrideAnnotationListener lis) {
        if (cu == null || aAnnotatedModelList == null || aAnnotatedModelList.isEmpty()) {
            return;
        }
        AnnotatedClassInfo model = aAnnotatedModelList.get(cu);
        if (model != null) {
            JavaElementInfo[] jeInfo = model.getJavaElementInfoObjects();
            if (jeInfo != null) {
                int i = 0;
                while (i < jeInfo.length) {
                    jeInfo[i].removePropertyChangeListener((IPropertyChangeListener)lis);
                    ++i;
                }
            }
            model.makeSourceListener(false);
            model.removePropertyChangeListener((IPropertyChangeListener)lis);
        }
    }

    protected void removeModelChangedListener(JavaElementInfo jei, DDOverrideAnnotationListener lis) {
        JavaElementInfo[] epa;
        AnnotationInfo[] ai;
        if (jei.getAnnotationInfoPG() != null) {
            jei.getAnnotationInfoPG().removePropertyChangeListener((IPropertyChangeListener)lis);
        }
        if (jei.getJavaElementInfoPG() != null) {
            jei.getJavaElementInfoPG().removePropertyChangeListener((IPropertyChangeListener)lis);
        }
        if ((ai = jei.getAnnotationInfoObjects()) != null) {
            int i = 0;
            while (i < ai.length) {
                ai[i].removePropertyChangeListener((IPropertyChangeListener)lis);
                ++i;
            }
        }
        if ((epa = jei.getJavaElementInfoObjects()) != null) {
            int i = 0;
            while (i < epa.length) {
                this.removeModelChangedListener(epa[i], lis);
                ++i;
            }
        }
    }

    protected static void addModelChangedListener(JavaElementInfo jei, DDOverrideAnnotationListener lis) {
        JavaElementInfo[] epa;
        AnnotationInfo[] ai;
        if (jei.getAnnotationInfoPG() != null) {
            jei.getAnnotationInfoPG().removePropertyChangeListener((IPropertyChangeListener)lis);
            jei.getAnnotationInfoPG().addPropertyChangeListener((IPropertyChangeListener)lis);
        }
        if (jei.getJavaElementInfoPG() != null) {
            jei.getJavaElementInfoPG().removePropertyChangeListener((IPropertyChangeListener)lis);
            jei.getJavaElementInfoPG().addPropertyChangeListener((IPropertyChangeListener)lis);
        }
        if ((ai = jei.getAnnotationInfoObjects()) != null) {
            int i = 0;
            while (i < ai.length) {
                ai[i].removePropertyChangeListener((IPropertyChangeListener)lis);
                ai[i].addPropertyChangeListener((IPropertyChangeListener)lis);
                ++i;
            }
        }
        if ((epa = jei.getJavaElementInfoObjects()) != null) {
            int i = 0;
            while (i < epa.length) {
                DDOverrideIndicatorHelper.addModelChangedListener(epa[i], lis);
                ++i;
            }
        }
    }

    protected static List getAnnotationInfos(ICompilationUnit compUnit, DDOverrideAnnotationListener lis) {
        try {
            AnnotatedClassInfo model = DDOverrideIndicatorHelper.getAnnotatedModel(compUnit, lis);
            if (model != null) {
                List alist = null;
                alist = AnnotationUtils.getAllAnnotationInfosUtilMethod((AnnotatedClassInfo)model);
                return alist;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected static List getAnnotationInfos(AnnotatedClassInfo model, DDOverrideAnnotationListener lis) {
        try {
            if (model != null) {
                model.makeSourceListener(true);
                model.removePropertyChangeListener((IPropertyChangeListener)lis);
                model.addPropertyChangeListener((IPropertyChangeListener)lis);
                DDOverrideIndicatorHelper.addModelChangedListener((JavaElementInfo)model, lis);
                List alist = null;
                alist = AnnotationUtils.getAllAnnotationInfosUtilMethod((AnnotatedClassInfo)model);
                return alist;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected static IEditorPart getEditorPart(IWorkbenchPage currentWorkbenchPage_) {
        if (currentWorkbenchPage_ == null) {
            return null;
        }
        IEditorPart editorPart0 = currentWorkbenchPage_.getActiveEditor();
        if (editorPart0 == null) {
            return null;
        }
        return editorPart0;
    }

    protected static ICompilationUnit getCompilationUnitFromEditor(IWorkbenchPage currentWorkbenchPage_) {
        IJavaElement javaElement;
        ICompilationUnit compUnit_ = null;
        if (currentWorkbenchPage_ == null) {
            return null;
        }
        IEditorPart editorPart0 = currentWorkbenchPage_.getActiveEditor();
        if (editorPart0 == null) {
            return null;
        }
        Object adapter = editorPart0.getEditorInput().getAdapter(IJavaElement.class);
        if (adapter != null && (javaElement = (IJavaElement)adapter) instanceof ICompilationUnit) {
            compUnit_ = (ICompilationUnit)javaElement;
        }
        return compUnit_;
    }

    protected static ICompilationUnit getCompilationUnitFromEditor(IEditorPart editorPart0) {
        IJavaElement javaElement;
        ICompilationUnit compUnit_ = null;
        Object adapter = editorPart0.getEditorInput().getAdapter(IJavaElement.class);
        if (adapter != null && (javaElement = (IJavaElement)adapter) instanceof ICompilationUnit) {
            compUnit_ = (ICompilationUnit)javaElement;
        }
        return compUnit_;
    }

    private static Object myReturn(String msg, Object obj) {
        DDOverrideIndicatorHelper.debug(msg);
        return obj;
    }

    protected static IAnnotationModel getDDAnnotationModel(IWorkbenchPage currentWorkbenchPage_) {
        if (currentWorkbenchPage_ == null) {
            return (IAnnotationModel)DDOverrideIndicatorHelper.myReturn("getDDAnnotationModel():currentworkbenchpage null", null);
        }
        IEditorPart editorPart0 = currentWorkbenchPage_.getActiveEditor();
        if (editorPart0 == null) {
            return (IAnnotationModel)DDOverrideIndicatorHelper.myReturn("getDDAnnotationModel():editorpart null", null);
        }
        IEditorInput input0 = editorPart0.getEditorInput();
        if (JavaUI.getDocumentProvider() != null) {
            fDDAnnotationModel_ = JavaUI.getDocumentProvider().getAnnotationModel((Object)input0);
            return fDDAnnotationModel_;
        }
        return null;
    }

    protected static IAnnotationModel getDDAnnotationModel(IEditorPart editorPart0) {
        IEditorInput input0 = editorPart0.getEditorInput();
        if (JavaUI.getDocumentProvider() != null) {
            fDDAnnotationModel_ = JavaUI.getDocumentProvider().getAnnotationModel((Object)input0);
            return fDDAnnotationModel_;
        }
        return null;
    }

    protected static void dumpandDeleteAllDDFromAnnotationsModel(IAnnotationModel model) {
        DDOverrideIndicatorHelper.debug("...............dumping model....");
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            int i = 0;
            if (it != null) {
                while (it.hasNext() && it != null) {
                    Annotation ann = (Annotation)it.next();
                    Position pos = model.getPosition(ann);
                    if (pos == null) continue;
                    int length = pos.getLength();
                    int offset = pos.getOffset();
                    if (ann.getType().contains("com.ibm.etools.annotations.ui.overrideDD")) {
                        DDOverrideIndicatorHelper.debug(String.valueOf(i) + " remove :" + ann + " isMarked deleted ?" + ann.isMarkedDeleted() + ":text=" + ann.getText() + " offset=" + offset + " length=" + length);
                        model.removeAnnotation(ann);
                    }
                    ++i;
                }
            }
            DDOverrideIndicatorHelper.debug("...............dumping model....");
        }
    }

    protected static void dumpandDeleteDDFromAnnotationsModel(IAnnotationModel model, String OverrideIndicatorId) {
        DDOverrideIndicatorHelper.debug("...............dumping model....");
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            int i = 0;
            if (it != null) {
                while (it.hasNext() && it != null) {
                    Annotation ann = (Annotation)it.next();
                    Position pos = model.getPosition(ann);
                    if (pos == null) continue;
                    int length = pos.getLength();
                    int offset = pos.getOffset();
                    if (ann.getType().equals(OverrideIndicatorId)) {
                        DDOverrideIndicatorHelper.debug(String.valueOf(i) + " remove :" + ann + " isMarked deleted ?" + ann.isMarkedDeleted() + ":text=" + ann.getText() + " offset=" + offset + " length=" + length);
                        model.removeAnnotation(ann);
                    }
                    ++i;
                }
            }
            DDOverrideIndicatorHelper.debug("...............dumping model....");
        }
    }

    protected static void dumpAnnotationsModel(IAnnotationModel model) {
        DDOverrideIndicatorHelper.debug("...............dumping model....");
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            int i = 0;
            if (it != null) {
                while (it.hasNext() && it != null) {
                    Annotation ann = (Annotation)it.next();
                    Position pos = model.getPosition(ann);
                    if (pos == null) continue;
                    int length = pos.getLength();
                    int offset = pos.getOffset();
                    DDOverrideIndicatorHelper.debug(String.valueOf(i) + ":" + ann + ":text=" + ann.getText() + " offset=" + offset + " length=" + length);
                    ++i;
                }
            }
            DDOverrideIndicatorHelper.debug("...............dumping model....");
        }
    }

    protected static void dumpAnnotationInfoList(AnnotationInfo[] lists) {
        int k = 0;
        while (k < lists.length) {
            AnnotationInfo aInfo = lists[k];
            DDOverrideIndicatorHelper.debug(String.valueOf(k) + ":" + aInfo.getName());
            ++k;
        }
    }

    protected static void dumpAnnotationInfoList(List lists) {
        int k = 0;
        while (k < lists.size()) {
            AnnotationInfo aInfo = (AnnotationInfo)lists.get(k);
            DDOverrideIndicatorHelper.debug(String.valueOf(k) + ":" + aInfo.getName());
            ++k;
        }
    }

    protected static void debug(Object msg) {
        DDOverrideIndicatorHelper.debug(msg, debugflag);
    }

    protected static void debug(Object msg, boolean dump) {
        if (dump) {
            System.out.println(msg);
        }
    }

    protected static Hashtable<String, Annotation> getANewIndicatorList() {
        return aNewIndicatorList;
    }

    protected static Hashtable<String, Position> getANewIndicatorPositionList() {
        return aNewIndicatorPositionList;
    }

    protected static AnnotatedClassInfo getAAnnotatedModelList(ICompilationUnit cu) {
        return aAnnotatedModelList.get(cu);
    }

    protected static void setAAnnotatedModelList(ICompilationUnit cu, AnnotatedClassInfo annotatedModelList) {
        aAnnotatedModelList.put(cu, annotatedModelList);
    }

    protected static ArrayList getFilesICare() {
        return FilesICare;
    }
}

