/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.override;

import com.ibm.etools.annotations.core.internal.AnnotationConfigDDOverrideInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class DDOverrideIndicator
extends Annotation {
    private IFile fOverrideSourceFile;
    private IProject fProject;
    private String fId;
    private String foId;
    private static final String EJBDD = "EJBOverride";

    DDOverrideIndicator(String id, String text, String oid, IProject project) {
        super(id, false, text);
        this.fId = id;
        this.foId = oid;
        this.fProject = project;
    }

    public boolean isEJBOverride() {
        return this.fId.equals("com.ibm.etools.annotations.ui.overrideDD.EJBOverride");
    }

    public void open() {
        AnnotationConstants.debug((Object)("open:" + this.fProject));
        try {
            String srcFile = AnnotationConfigDDOverrideInfo.instance().getSourceOverride(this.foId);
            if (srcFile == null) {
                return;
            }
            AnnotationConstants.debug((Object)("srcFile=" + srcFile));
            this.fOverrideSourceFile = this.fProject.getFile(srcFile);
            IPath DDpath = this.fOverrideSourceFile.getFullPath();
            if (DDpath != null) {
                AnnotationConstants.debug((Object)("opening..." + DDpath.toString()));
            } else {
                AnnotationConstants.debug((Object)"cannot find file");
            }
            Workspace curWS = (Workspace)JavaPlugin.getWorkspace();
            Resource curRes = curWS.newResource(DDpath, 1);
            IWorkbenchPage page = JavaPlugin.getActivePage();
            FileEditorInput curFile = new FileEditorInput((IFile)curRes);
            page.openEditor((IEditorInput)curFile, "org.eclipse.ui.DefaultTextEditor", true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
    }

    public String getFId() {
        return this.fId;
    }

    public void setFId(String id) {
        this.fId = id;
    }
}

