/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.override;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.utils.ResourceUtils;
import com.ibm.etools.annotations.ui.internal.override.DDOverrideIndicatorHelper;
import com.ibm.etools.annotations.ui.internal.override.DDOverrideModelManager;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

public class DDOverrideAnnotationListener
implements IPartListener2,
IPropertyChangeListener,
IResourceChangeListener {
    private static DDOverrideAnnotationListener instance_;
    private boolean dump = false;
    public DDOverrideModelManager oMmanager_;
    private static ICompilationUnit fcurrentCU;
    private static IEditorPart fePart;
    private boolean refreshModel = false;

    private boolean isJavaEditor(IWorkbenchPartReference ref) {
        if (ref == null) {
            return false;
        }
        String id = ref.getId();
        return "org.eclipse.jdt.ui.ClassFileEditor".equals(id) || "org.eclipse.jdt.ui.CompilationUnitEditor".equals(id);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.refreshModel = false;
        IResource res = event.getResource();
        switch (event.getType()) {
            case 1: {
                if (res != null) {
                    this.debug("res=" + res.getFullPath() + ":" + res.getName());
                }
                if (event.getDelta() == null) break;
                try {
                    class DeltaRes
                    implements IResourceDeltaVisitor {
                        DeltaRes() {
                        }

                        public boolean visit(IResourceDelta delta) {
                            IResource res = delta.getResource();
                            switch (delta.getKind()) {
                                case 4: {
                                    String changedResource;
                                    DDOverrideAnnotationListener.this.debug("Resource " + res.getFullPath() + "has changed ");
                                    if (res == null || res.getFullPath() == null || (changedResource = res.getFullPath().toString()) == null) break;
                                    if (changedResource.endsWith("ejb-jar.xml")) {
                                        DDOverrideAnnotationListener.this.refreshModel = true;
                                        break;
                                    }
                                    ArrayList list = DDOverrideIndicatorHelper.getFilesICare();
                                    if (list == null || !list.contains(changedResource)) break;
                                    DDOverrideAnnotationListener.this.debug("refreshModel...");
                                    DDOverrideAnnotationListener.this.refreshModel = true;
                                }
                            }
                            return true;
                        }
                    }
                    event.getDelta().accept((IResourceDeltaVisitor)new DeltaRes());
                    break;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        this.debug("refresh Model" + this.refreshModel);
        if (this.refreshModel) {
            IProject project = fcurrentCU.getJavaProject().getProject();
            List aInfo = DDOverrideIndicatorHelper.getAnnotationInfos(fcurrentCU, this);
            this.handleDDOverrideChangeEvent(fePart, aInfo, project);
        }
    }

    public void partActivated(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref)) {
            this.handleDDOverridePopulateEvent(ref, "partActivated");
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference ref) {
    }

    public void partVisible(IWorkbenchPartReference ref) {
    }

    public void partHidden(IWorkbenchPartReference ref) {
    }

    public void partInputChanged(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref)) {
            this.debug("..begin partInputChanged");
            this.handleDDOverridePopulateEvent(ref, "partInputChanged");
            this.debug("..end partInputChanged");
        }
    }

    public void partClosed(IWorkbenchPartReference ref) {
        if (this.isJavaEditor(ref)) {
            this.debug("begin partClosed");
            IEditorPart ePart = null;
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && part instanceof IEditorPart) {
                ePart = (IEditorPart)part;
            }
            ICompilationUnit cu = null;
            if (ePart != null) {
                cu = DDOverrideIndicatorHelper.getCompilationUnitFromEditor(ePart);
            }
            if (cu == null && fcurrentCU == null) {
                this.debug("null cu");
                return;
            }
            this.debug("remove Listeners for cu:" + cu + " saved CU" + fcurrentCU);
            if (cu == null) {
                cu = fcurrentCU;
            }
            this.debug("remove Listeners");
            DDOverrideIndicatorHelper.removeListeners(cu, this);
            DDOverrideIndicatorHelper.removeModelFromList(cu);
            DDOverrideIndicatorHelper.removeSourceOverrideFileListener();
            if (ePart != null && fePart == ePart) {
                fePart = null;
            }
            if (cu == fcurrentCU) {
                fcurrentCU = null;
            }
            this.debug("end partIClosed");
        }
    }

    public void partDeactivated(IWorkbenchPartReference ref) {
    }

    protected void handleDDOverrideChangeEvent(IEditorPart ePart, List aInfo, IProject project) {
        if (aInfo == null || project == null || ePart == null) {
            return;
        }
        DDOverrideIndicatorHelper.calculateAnnotationOverrides(aInfo, project);
        this.oMmanager_ = new DDOverrideModelManager(fePart, aInfo, project);
    }

    protected void PopulateDDOverride(IWorkbenchPartReference ref, String event, boolean reload) {
        if (ref == null || ref.getPage() == null) {
            return;
        }
        IEditorPart ePart = DDOverrideIndicatorHelper.getEditorPart(ref.getPage());
        if (ePart == null) {
            return;
        }
        IAnnotationModel iModel_ = null;
        IProject project_ = null;
        List aInfo_ = null;
        if (ref.getPage().getWorkbenchWindow() == null) {
            return;
        }
        ICompilationUnit cu = DDOverrideIndicatorHelper.getCompilationUnitFromEditor(ePart);
        if (cu == null) {
            return;
        }
        if (cu.getJavaProject() != null) {
            this.debug(cu.toString());
            project_ = cu.getJavaProject().getProject();
            this.debug(String.valueOf(event) + ": in-cu=" + cu + " last:" + fcurrentCU);
            if (!ResourceUtils.isEJBProject((IProject)project_)) {
                return;
            }
            if (cu.equals(fcurrentCU)) {
                this.debug("same cu");
            } else {
                fcurrentCU = cu;
            }
            aInfo_ = DDOverrideIndicatorHelper.getAnnotationInfos(cu, this);
            if (aInfo_ != null) {
                DDOverrideIndicatorHelper.dumpAnnotationInfoList(aInfo_);
                DDOverrideIndicatorHelper.calculateAnnotationOverrides(aInfo_, project_);
                fePart = ePart;
                this.oMmanager_ = new DDOverrideModelManager(ePart, aInfo_, project_);
                if (iModel_ != null) {
                    DDOverrideIndicatorHelper.dumpAnnotationsModel(iModel_);
                }
            }
        }
    }

    protected void handleDDOverridePopulateEvent(IWorkbenchPartReference ref, String msg) {
        if (ref != null && ref.getPage() != null) {
            this.debug("active part=" + ref.getPage().getActivePart());
            this.debug("active editor=" + ref.getPage().getActiveEditor());
            this.PopulateDDOverride(ref, msg, true);
        }
    }

    public void partOpened(IWorkbenchPartReference ref) {
        this.debug("partOpened... begin");
        if (this.isJavaEditor(ref)) {
            this.handleDDOverridePopulateEvent(ref, "partOpened");
        }
        this.debug("end partOpened... end");
    }

    public DDOverrideAnnotationListener() {
        if (instance_ == null) {
            instance_ = this;
        }
    }

    public static DDOverrideAnnotationListener getInstance() {
        if (instance_ == null) {
            instance_ = new DDOverrideAnnotationListener();
        }
        return instance_;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        AnnotatedClassInfo model;
        if (evt.getSource() instanceof AnnotatedClassInfo && (model = (AnnotatedClassInfo)evt.getSource()) != null) {
            DDOverrideIndicatorHelper.setAAnnotatedModelList(fcurrentCU, model);
            List aInfo = DDOverrideIndicatorHelper.getAnnotationInfos(model, this);
            if (aInfo != null) {
                IProject project = fcurrentCU.getJavaProject().getProject();
                this.handleDDOverrideChangeEvent(fePart, aInfo, project);
            }
        }
    }

    protected void debug(Object msg) {
        DDOverrideIndicatorHelper.debug(msg, this.dump);
    }
}

