/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.override;

import com.ibm.etools.annotations.core.data.AnnotationOverrideInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigDDOverrideInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.core.utils.AnnotationOverrideHelper;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.override.JavaWordFinder;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class AnnotationOverrideHover
implements IJavaEditorTextHover {
    Hashtable<String, Annotation> aMarkerLists = new Hashtable();
    private IEditorPart fEditor;
    private String fileName;
    private final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_FLAGS = this.LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion == null) {
            return null;
        }
        if (hoverRegion.getLength() == 0) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        this.fileName = this.getCurrentFile();
        if (resolve != null) {
            IJavaElement[] result;
            block7: {
                result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                if (result != null) break block7;
                return null;
            }
            try {
                int nResults = result.length;
                if (nResults > 0) {
                    AnnotationConstants.debug((Object)("result.length=" + nResults + " " + result[0].getElementName() + ":" + result[0].getElementType()));
                    return this.getHoverInfo(result, hoverRegion.getOffset());
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return null;
    }

    protected String getCurrentFile() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            if (manager != null) {
                if (manager.getWorkingCopy(input, false) == null) {
                    return null;
                }
                IPath thispath = manager.getWorkingCopy(input, false).getPath();
                if (thispath != null) {
                    try {
                        return thispath.toString();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
        return null;
    }

    private String getHoverInfo(IJavaElement[] result, int offset) {
        String annotationName = null;
        String attributeName = null;
        IJavaElement je = result[0];
        String tempString = null;
        String description = null;
        String overrideVals = null;
        String OverrideFile = null;
        AnnotationConstants.debug((Object)(String.valueOf(je.getElementName()) + ":" + je.getClass().getCanonicalName()));
        IProject project = null;
        if (je != null && je.getJavaProject() != null) {
            project = je.getJavaProject().getProject();
        }
        if (je.getElementType() == 7 && je.getClass().getCanonicalName().equals("org.eclipse.jdt.internal.core.ResolvedBinaryType")) {
            annotationName = this.getInfoText(je);
        }
        if (je.getElementType() == 9 && je.getClass().getCanonicalName().equals("org.eclipse.jdt.internal.core.ResolvedBinaryMethod")) {
            annotationName = this.getAnnotation(je, offset);
            attributeName = je.getElementName();
        }
        AnnotationConstants.debug((Object)("trying code=" + annotationName + ":" + attributeName + ":" + offset));
        if (annotationName != null) {
            String overrideId = AnnotationConfigDDOverrideInfo.instance().hasRegisterOverrideId(null, annotationName);
            if (overrideId == null) {
                return null;
            }
            if (!AnnotationConfigDDOverrideInfo.instance().enableHover(overrideId)) {
                AnnotationConstants.debug((Object)(String.valueOf(annotationName) + ": not enable hover.."));
                return null;
            }
            AnnotationOverrideInfo overrideInfo = AnnotationConfigDDOverrideInfo.instance().getOverrideValues(null, annotationName, project, this.fileName, null, offset);
            if (overrideInfo == null) {
                return null;
            }
            if ((annotationName.equals("javax.ejb.Stateful") || annotationName.equals("javax.ejb.MessageDriven") || annotationName.equals("javax.ejb.Stateless")) && attributeName != null && attributeName.equals("name")) {
                return null;
            }
            OverrideFile = overrideInfo.getSourceOverride();
            overrideVals = attributeName == null ? AnnotationOverrideHelper.getStringOverrideValues((AnnotationOverrideInfo)overrideInfo) : AnnotationOverrideHelper.getOverrideValue((AnnotationOverrideInfo)overrideInfo, (String)attributeName);
            StringBuffer buf = new StringBuffer();
            boolean hasAttributes = true;
            if (overrideVals == null || overrideVals.isEmpty() || overrideVals.equals("")) {
                hasAttributes = false;
            }
            if (!hasAttributes) {
                buf.append(annotationName);
                buf.append(" ");
                description = AnnotationsUIMessages.ANNOTATION_DD_DEFINED;
            } else if (attributeName != null) {
                buf.append("[");
                buf.append(attributeName);
                buf.append("] ");
                description = AnnotationConfigDDOverrideInfo.instance().getDescription(null, annotationName, project);
            } else {
                description = AnnotationsUIMessages.ANNOTATION_DD_DETECTED;
            }
            if (description != null) {
                buf.append(description);
            } else {
                buf.append(AnnotationsUIMessages.ANNOTATION_DD_VALUES);
            }
            buf.append(" \n");
            buf.append("<br>");
            if (OverrideFile != null) {
                buf.append(OverrideFile);
                buf.append("<br>");
            } else {
                buf.append("<br>");
            }
            if (hasAttributes) {
                buf.append("<br>@");
                buf.append(annotationName);
                if (attributeName == null) {
                    buf.append(overrideVals);
                } else {
                    buf.append("<br>");
                    buf.append("[");
                    buf.append(attributeName);
                    buf.append("] has value");
                    buf.append(" ");
                    buf.append(overrideVals).toString();
                }
            }
            tempString = buf.toString();
        }
        AnnotationConstants.debug((Object)("return" + overrideVals));
        if (overrideVals != null) {
            return tempString;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    protected String formatSingleMessage(String message) {
        return message;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected String getAnnotation(IJavaElement elm, int offset) {
        if (elm != null && elm instanceof ResolvedBinaryMethod) {
            if (elm.getElementType() == 9 && elm.getParent() != null) {
                AnnotationConstants.debug((Object)(String.valueOf(elm.getParent().getElementType()) + ":" + elm.getParent().getElementName()));
                if (elm.getParent().getElementType() == 7) {
                    return this.getInfoText(elm.getParent());
                }
            }
            return null;
        }
        return elm.getElementName();
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
            if (manager != null && input != null) {
                return manager.getWorkingCopy(input);
            }
        }
        return null;
    }

    private String getInfoText(IJavaElement member) {
        long flags = member.getElementType() == 14 ? this.LOCAL_VARIABLE_FLAGS : this.LABEL_FLAGS;
        String label = JavaElementLabels.getElementLabel((IJavaElement)member, (long)flags);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < label.length()) {
            char ch = label.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

