/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.listeners;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigDDOverrideInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.core.properties.SingleValueArgumentProperty;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.propertygroup.IMultiValuedProperty;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.IPropertyDescriptor;
import com.ibm.propertygroup.ISingleValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.PropertyHelper;
import com.ibm.propertygroup.ui.internal.utilities.PropertyUIHelper;
import com.ibm.propertygroup.ui.internal.widgets.PropertyUIWidgetText_Base;
import com.ibm.propertygroup.ui.utilities.PropertyUIComposite;
import com.ibm.propertygroup.ui.utilities.PropertyUIWidget;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DecorateAttributeListener
implements IPropertyChangeListener {
    protected PropertyUIComposite uiComposite_;
    protected Image implyImage_ = Activator.getImageDescriptor("icons/ovr16/imply_ovr.gif").createImage();
    protected Image defaultImage_ = Activator.getImageDescriptor("icons/ovr16/default_ovr.gif").createImage();
    protected Image ddImage_ = Activator.getImageDescriptor("icons/ovr16/override_ovr.gif").createImage();
    protected ArrayList<IPropertyDescriptor> listeningProperties_ = new ArrayList();

    public void setPropertyUIComposite(PropertyUIComposite uiComposite) {
        if (!this.listeningProperties_.isEmpty() || this.uiComposite_ != null) {
            this.clearListener();
        }
        this.uiComposite_ = uiComposite;
        if (this.uiComposite_ != null) {
            ArrayList widgets = this.uiComposite_.getUIWidgets();
            int i = 0;
            while (i < widgets.size()) {
                boolean needToBeDecorated;
                IAnnotationAttributeProperty iaap;
                PropertyUIWidget widget = (PropertyUIWidget)widgets.get(i);
                IPropertyDescriptor property = widget.getProperty();
                if (property instanceof IAnnotationAttributeProperty && !(iaap = (IAnnotationAttributeProperty)property).getPropertyType().getType().getName().equalsIgnoreCase("java.lang.Boolean") && (needToBeDecorated = this.decorateAttributeWidget(widget))) {
                    String widgetValue;
                    property.addPropertyChangeListener((IPropertyChangeListener)this);
                    this.listeningProperties_.add(property);
                    if (widget instanceof PropertyUIWidgetText_Base && widget.getValue() == null && (widgetValue = widget.getWidgetValue()) != null && widgetValue.length() > 0) {
                        widget.setWidgetValue("", false);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean decorateAttributeWidget(PropertyUIWidget widget) {
        boolean needToBeDecorated = false;
        IAnnotationAttributeProperty iaap = (IAnnotationAttributeProperty)widget.getProperty();
        String ddOverrideValue = this.getAttributeDDOverride(iaap);
        if (ddOverrideValue != null) {
            needToBeDecorated = true;
            String hoverHelp = NLS.bind((String)AnnotationsUIMessages.ANNOTATION_DD_VALUE, (Object[])new String[]{PropertyUIHelper.instance().getDisplayString(iaap.getDisplayName())[0], ddOverrideValue});
            widget.decorateUIWidget(this.ddImage_, 17408, hoverHelp, null);
        } else if (iaap.getImpliedValue() != null) {
            needToBeDecorated = true;
            if (!this.isAttributeValueSet(iaap)) {
                String impliedValue = this.getObjectAsString(iaap.getImpliedValue());
                impliedValue = impliedValue.length() < 1 ? "''" : PropertyUIHelper.instance().getDisplayString(impliedValue)[0];
                String hoverHelp = NLS.bind((String)AnnotationsUIMessages.ANNOTATION_IMPLIED_VALUE, (Object[])new String[]{PropertyUIHelper.instance().getDisplayString(iaap.getDisplayName())[0], impliedValue});
                widget.decorateUIWidget(this.implyImage_, 17408, hoverHelp, null);
            }
        } else if (iaap.getDefaultValue(true) != null) {
            String defaultValue;
            needToBeDecorated = true;
            if (!this.isAttributeValueSet(iaap) && (defaultValue = this.getObjectAsString(iaap.getDefaultValue(true))).length() > 0) {
                defaultValue = PropertyUIHelper.instance().getDisplayString(defaultValue)[0];
                String hoverHelp = NLS.bind((String)AnnotationsUIMessages.ANNOTATION_DEFAULT_VALUE, (Object[])new String[]{PropertyUIHelper.instance().getDisplayString(iaap.getDisplayName())[0], defaultValue});
                widget.decorateUIWidget(this.defaultImage_, 17408, hoverHelp, null);
            }
        }
        return needToBeDecorated;
    }

    protected String getObjectAsString(Object object) {
        StringBuffer valueString = new StringBuffer();
        if (object instanceof Object[]) {
            Object[] arrayObject = (Object[])object;
            int i = 0;
            while (i < arrayObject.length) {
                if (arrayObject[i] != null) {
                    valueString.append(arrayObject[i].toString());
                }
                ++i;
            }
        } else if (object instanceof Collection) {
            for (Object obj : (Collection)object) {
                if (obj == null) continue;
                valueString.append(obj.toString());
            }
        } else if (object != null) {
            valueString.append(object.toString());
        }
        return valueString.toString();
    }

    public void propertyChange(final PropertyChangeEvent evt) {
        if (Display.getCurrent() != null) {
            this.handlePropertyChange(evt);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DecorateAttributeListener.this.handlePropertyChange(evt);
                }
            });
        }
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
        IAnnotationAttributeProperty iaap;
        String ddOverrideValue;
        PropertyUIWidget widget;
        Object source = evt.getSource();
        if (evt.getPropertyChangeType() == 0 && source instanceof IAnnotationAttributeProperty && (widget = this.uiComposite_.getUIWidget((IPropertyDescriptor)((IAnnotationAttributeProperty)source))) != null && (ddOverrideValue = this.getAttributeDDOverride(iaap = (IAnnotationAttributeProperty)source)) == null) {
            if (this.isAttributeValueSet(iaap)) {
                widget.decorateUIWidget(null, 17408, null, null);
            } else {
                AnnotationInfo annoInfo = iaap.getParentAnnotation();
                if (annoInfo.getDeclaredAttributes().indexOf(iaap) == -1 || iaap instanceof SingleValueArgumentProperty && ((SingleValueArgumentProperty)iaap).getValue() == null && "com.ibm.etools.annotations.ui.javaClassProperty".equals(iaap.getID())) {
                    this.decorateAttributeWidget(widget);
                }
            }
        }
    }

    protected boolean isAttributeValueSet(IAnnotationAttributeProperty iaap) {
        if (!iaap.isSet()) {
            return false;
        }
        if (PropertyHelper.isSingleValuedProperty((IPropertyDescriptor)iaap)) {
            return ((ISingleValuedProperty)iaap).getValue() != null;
        }
        if (PropertyHelper.isMultiValuedProperty((IPropertyDescriptor)iaap)) {
            Object[] values = ((IMultiValuedProperty)iaap).getValues();
            return values != null && values.length > 0;
        }
        return false;
    }

    protected String getAttributeDDOverride(IAnnotationAttributeProperty iaap) {
        AnnotationInfo anoInfo = iaap.getParentAnnotation();
        String attributeName = iaap.getName();
        String annotationName = anoInfo.getName();
        String pkgName = anoInfo.getCategorizationKey();
        String fileName = "";
        IProject project = null;
        IJavaElement jelm = null;
        if (anoInfo.getParentJavaElementInfo() != null && (jelm = anoInfo.getParentJavaElementInfo().getJavaElement()) != null && jelm.getPath() != null) {
            fileName = jelm.getPath().toString();
        }
        if (jelm != null && jelm.getJavaProject() != null) {
            project = jelm.getJavaProject().getProject();
        }
        if (project == null || jelm == null) {
            return null;
        }
        String ddValue = AnnotationConfigDDOverrideInfo.instance().getOverrideValue(pkgName, annotationName, attributeName, project, fileName, anoInfo, anoInfo.getOffset());
        return ddValue;
    }

    public void clearListener() {
        if (this.uiComposite_ != null) {
            this.uiComposite_ = null;
        }
        int i = 0;
        while (i < this.listeningProperties_.size()) {
            this.listeningProperties_.get(i).removePropertyChangeListener((IPropertyChangeListener)this);
            ++i;
        }
        this.listeningProperties_.clear();
    }

    public void dispose() {
        if (this.implyImage_ != null && !this.implyImage_.isDisposed()) {
            this.implyImage_.dispose();
        }
        if (this.defaultImage_ != null && !this.defaultImage_.isDisposed()) {
            this.defaultImage_.dispose();
        }
        if (this.ddImage_ != null && !this.ddImage_.isDisposed()) {
            this.ddImage_.dispose();
        }
        if (!this.listeningProperties_.isEmpty() || this.uiComposite_ != null) {
            this.clearListener();
        }
    }
}

