/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.dialogs;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.internal.AnnotationConfigElem;
import com.ibm.etools.annotations.core.internal.AnnotationConfigInfo;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.etools.annotations.ui.Activator;
import com.ibm.etools.annotations.ui.internal.data.AnnotationCategoryElement;
import com.ibm.etools.annotations.ui.internal.messages.AnnotationsUIMessages;
import com.ibm.etools.annotations.ui.internal.providers.AnnotationLabelProvider;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.propertygroup.ui.internal.controls.NewPatternFilter;
import com.ibm.propertygroup.ui.internal.controls.ToolBarFilteredTreeViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AddAnnotationDialog
extends TrayDialog {
    protected TreeViewer treeViewer_;
    protected TreeViewer javaElementViewer_;
    SashForm sashForm_;
    protected AnnotationInfo annInfo_ = null;
    protected String title_;
    protected IJavaProject javaProject_;
    protected AnnotationLabelProvider labelProvider_;
    protected TargetJavaElementLabelProvider tjLabelProvider_;
    protected IJavaElement defaultJavaElement_;
    protected IJavaElement selectedJavaElement_;

    public AddAnnotationDialog(Shell shell, String title, IJavaProject jProj) {
        super(shell);
        this.title_ = title;
        this.javaProject_ = jProj;
        this.defaultJavaElement_ = null;
        this.setBlockOnOpen(true);
        this.setShellStyle(67696);
    }

    public AddAnnotationDialog(Shell shell, String title, IJavaElement defaultJavaElement) {
        super(shell);
        this.title_ = title;
        this.defaultJavaElement_ = defaultJavaElement;
        if (defaultJavaElement != null) {
            this.javaProject_ = this.defaultJavaElement_.getJavaProject();
        }
        this.setBlockOnOpen(true);
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title_ != null) {
            shell.setText(this.title_);
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.sashForm_ = new SashForm(container, 512);
        this.sashForm_.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        gridData.heightHint = 400;
        gridData.widthHint = 500;
        this.sashForm_.setLayoutData((Object)gridData);
        Group group = new Group((Composite)this.sashForm_, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_TARGET_JAVA_ELEMENTS);
        this.javaElementViewer_ = new TreeViewer((Composite)group, 2052);
        this.javaElementViewer_.getControl().setLayoutData((Object)new GridData(1808));
        this.javaElementViewer_.setContentProvider((IContentProvider)new TargetJavaElementContentProvider());
        this.tjLabelProvider_ = new TargetJavaElementLabelProvider();
        this.javaElementViewer_.setLabelProvider((IBaseLabelProvider)this.tjLabelProvider_);
        this.javaElementViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddAnnotationDialog.this.handleTreeSelectionChanged(event);
            }
        });
        this.javaElementViewer_.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddAnnotationDialog.this.handleTreeDoubleClick(event);
            }
        });
        ArrayList<IJavaElement> jeInput = this.buildTargetJavaElementInput();
        if (this.defaultJavaElement_ != null) {
            this.javaElementViewer_.setInput(jeInput);
            this.selectDefaultJavaElement();
        }
        group = new Group((Composite)this.sashForm_, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setText(AnnotationsUIMessages.ANNOTATIONS_UI_LABEL_ANNOTATIONS1);
        ToolBarFilteredTreeViewer filteredTree = new ToolBarFilteredTreeViewer((Composite)group, 2048, new NewPatternFilter());
        filteredTree.showFilterTextField(true);
        this.treeViewer_ = filteredTree.getViewer();
        this.treeViewer_.setContentProvider((IContentProvider)new AnnotationContentProvider());
        this.labelProvider_ = new AnnotationLabelProvider();
        this.treeViewer_.setLabelProvider((IBaseLabelProvider)this.labelProvider_);
        this.treeViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddAnnotationDialog.this.handleTreeSelectionChanged(event);
            }
        });
        this.treeViewer_.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AddAnnotationDialog.this.handleTreeDoubleClick(event);
            }
        });
        Collection<AnnotationCategoryElement> input = this.buildInput();
        if (input != null) {
            this.treeViewer_.setInput(input);
        }
        this.treeViewer_.setSorter(new ViewerSorter());
        if (this.defaultJavaElement_ == null || jeInput.isEmpty()) {
            this.sashForm_.setMaximizedControl((Control)group);
        } else {
            this.sashForm_.setWeights(new int[]{42, 58});
        }
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this.sashForm_, "com.ibm.etools.annotations.ui.AddAnnotationDialog");
        return container;
    }

    protected Collection<AnnotationCategoryElement> buildInput() {
        if (this.javaProject_ != null) {
            Hashtable<String, AnnotationCategoryElement> categories = new Hashtable<String, AnnotationCategoryElement>();
            List ais = new AnnotationUtils().parseAllAnnotationsOnClassPath(this.javaProject_);
            if (ais != null && !ais.isEmpty()) {
                int i = 0;
                while (i < ais.size()) {
                    AnnotationCategoryElement acElement;
                    AnnotationInfo info = (AnnotationInfo)ais.get(i);
                    String catKey = info.getCategorizationKey();
                    if (catKey == null) {
                        catKey = "";
                    }
                    if ((acElement = (AnnotationCategoryElement)categories.get(catKey)) == null) {
                        acElement = new AnnotationCategoryElement(catKey);
                        acElement.addAnnotation(info);
                        categories.put(catKey, acElement);
                    } else {
                        acElement.addAnnotation(info);
                    }
                    ++i;
                }
            }
            ArrayList annoConfig = AnnotationConfigInfo.instance().getAnnotationConfigFromExtensionPointInfo();
            int i = 0;
            while (i < annoConfig.size()) {
                AnnotationConfigElem confgElem = (AnnotationConfigElem)annoConfig.get(i);
                String catKey = confgElem.getCateogry();
                String aPkg = confgElem.getAnnoPackage();
                String aName = confgElem.getAnnotationName();
                AnnotationCategoryElement acElement = (AnnotationCategoryElement)categories.get(catKey);
                AnnotationInfo aInfo = null;
                if (!confgElem.hasDefault()) {
                    try {
                        aInfo = new AnnotationInfo(aName, 0, null);
                        aInfo.setCategorizationKey(catKey);
                        aInfo.setPackageName(aPkg);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    if (acElement == null) {
                        acElement = new AnnotationCategoryElement(catKey);
                        if (aInfo != null) {
                            acElement.addAnnotation(aInfo);
                        }
                        categories.put(catKey, acElement);
                    } else if (aInfo != null) {
                        acElement.addAnnotation(aInfo);
                    }
                }
                ++i;
            }
            if (!categories.isEmpty()) {
                return categories.values();
            }
        }
        return null;
    }

    protected ArrayList<IJavaElement> buildTargetJavaElementInput() {
        ArrayList<IJavaElement> inputList = new ArrayList<IJavaElement>(6);
        if (this.defaultJavaElement_ != null) {
            ICompilationUnit cu = (ICompilationUnit)this.defaultJavaElement_.getAncestor(5);
            try {
                IJavaElement[] children = cu.getChildren();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IAnnotatable) {
                            inputList.add(children[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return inputList;
    }

    protected void selectDefaultJavaElement() {
        IPath path = null;
        String name = AnnotationUIUtils.getJavaElementName(this.defaultJavaElement_);
        if (name != null) {
            path = AnnotationUIUtils.buildFullQualifiedPath(this.defaultJavaElement_, name);
        }
        if (path != null) {
            TreeItem item = this.findAnnotationParentTreeItem(this.javaElementViewer_, this.javaElementViewer_.getTree().getItems(), path, 0);
            if (item != null) {
                this.javaElementViewer_.setSelection((ISelection)new StructuredSelection((Object)this.defaultJavaElement_), true);
            } else {
                this.javaElementViewer_.setSelection(null, true);
            }
        }
    }

    protected TreeItem findAnnotationParentTreeItem(TreeViewer treeViewer, TreeItem[] items, IPath path, int index) {
        if (items != null) {
            String segment = path.segment(index);
            int start = 0;
            int nsIndex = segment.lastIndexOf("@#");
            if (nsIndex != -1) {
                start = Integer.parseInt(segment.substring(nsIndex + "@#".length()));
                segment = segment.substring(0, nsIndex);
            }
            int i = start;
            while (i < items.length) {
                if (items[i].getText().endsWith(segment)) {
                    Object data = items[i].getData();
                    treeViewer.expandToLevel(data, 1);
                    if (index == path.segmentCount() - 1) {
                        return items[i];
                    }
                    return this.findAnnotationParentTreeItem(treeViewer, items[i].getItems(), path, index + 1);
                }
                ++i;
            }
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.getButton(0).setEnabled(false);
    }

    public AnnotationInfo getSelection() {
        return this.annInfo_;
    }

    public IJavaElement getTargetJavaElement() {
        return this.selectedJavaElement_;
    }

    public boolean close() {
        if (this.labelProvider_ != null) {
            this.labelProvider_.dispose();
        }
        if (this.tjLabelProvider_ != null) {
            this.tjLabelProvider_.dispose();
        }
        return super.close();
    }

    protected void okPressed() {
        if (this.annInfo_ != null) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent e) {
        Object source = e.getSource();
        if (source == this.treeViewer_) {
            Object selection = ((StructuredSelection)this.treeViewer_.getSelection()).getFirstElement();
            this.annInfo_ = selection != null && selection instanceof AnnotationInfo ? (AnnotationInfo)selection : null;
        } else if (source == this.javaElementViewer_) {
            Object selection = ((StructuredSelection)this.javaElementViewer_.getSelection()).getFirstElement();
            this.selectedJavaElement_ = selection != null ? (IJavaElement)selection : null;
        }
        this.validateDialog();
    }

    protected void handleTreeDoubleClick(DoubleClickEvent e) {
        if (this.getButton(0).isEnabled()) {
            this.okPressed();
        }
    }

    protected void validateDialog() {
        boolean valid = false;
        if (this.annInfo_ != null) {
            valid = this.defaultJavaElement_ != null ? this.selectedJavaElement_ != null : true;
        }
        if (this.getButton(0) != null) {
            if (valid) {
                Button button = this.getButton(0);
                button.setEnabled(true);
                this.setButtonToDefault(button);
            } else {
                this.getButton(0).setEnabled(false);
                this.setButtonToDefault(this.getButton(1));
            }
        }
    }

    protected void setButtonToDefault(Button button) {
        Shell shell = button.getShell();
        if (shell != null) {
            shell.setDefaultButton(button);
        }
    }

    protected class AnnotationContentProvider
    implements ITreeContentProvider {
        protected AnnotationContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<AnnotationInfo> list;
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof AnnotationCategoryElement && (list = ((AnnotationCategoryElement)parentElement).getAnnotations()) != null && !list.isEmpty()) {
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class TargetJavaElementContentProvider
    implements ITreeContentProvider {
        protected TargetJavaElementContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof IMember) {
                try {
                    IJavaElement[] children = ((IMember)parentElement).getChildren();
                    ArrayList<IJavaElement> childrenList = new ArrayList<IJavaElement>();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IAnnotatable) {
                            childrenList.add(children[i]);
                        }
                        ++i;
                    }
                    if (!childrenList.isEmpty()) {
                        return childrenList.toArray();
                    }
                }
                catch (Exception exception) {}
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TargetJavaElementLabelProvider
    extends LabelProvider {
        private Hashtable<String, Image> allocatedImages_ = new Hashtable();

        public Image getImage(Object element) {
            if (element instanceof IJavaElement) {
                IJavaElement je = (IJavaElement)element;
                if (je.getElementType() == 7) {
                    return this.getImageFromFile("icons/obj16/class.gif");
                }
                if (je.getElementType() == 8) {
                    return this.getImageFromFile("icons/obj16/field.gif");
                }
                if (je.getElementType() == 9) {
                    return this.getImageFromFile("icons/obj16/method.gif");
                }
                if (je.getElementType() == 11) {
                    return this.getImageFromFile("icons/obj16/package_obj.gif");
                }
            }
            return null;
        }

        protected Image getImageFromFile(String imageFileName) {
            if (imageFileName != null) {
                Image im = this.allocatedImages_.get(imageFileName);
                if (im != null) {
                    return im;
                }
                im = Activator.getImageDescriptor(imageFileName).createImage();
                this.allocatedImages_.put(imageFileName, im);
                return im;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IJavaElement) {
                return AnnotationUIUtils.getJavaElementName((IJavaElement)element);
            }
            return "";
        }

        public void dispose() {
            super.dispose();
            Enumeration<Image> ims = this.allocatedImages_.elements();
            while (ims.hasMoreElements()) {
                Image i = ims.nextElement();
                if (i.isDisposed()) continue;
                i.dispose();
            }
            this.allocatedImages_.clear();
        }
    }
}

