/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.data;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class AnnotationViewOverlayInfo {
    private static AnnotationViewOverlayInfo anObjInfo_;
    private int annoicon_index = 2;
    private int icon_index = 1;
    private int label_index = 0;
    private static Hashtable<String, ArrayList> annoIconLabelConfigurations_;

    public static AnnotationViewOverlayInfo instance() {
        if (anObjInfo_ == null) {
            anObjInfo_ = new AnnotationViewOverlayInfo();
            annoIconLabelConfigurations_ = AnnotationViewOverlayInfo.getOnceOnlyAnnotationOverlayFromExtensionPointInfo();
        }
        return anObjInfo_;
    }

    private static Hashtable getOnceOnlyAnnotationOverlayFromExtensionPointInfo() {
        annoIconLabelConfigurations_ = new Hashtable();
        IConfigurationElement[] annoConfigExtensionPoints = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.etools.annotations.ui.AnnotationViewOverlayInfo");
        int i = 0;
        while (i < annoConfigExtensionPoints.length) {
            if ("annotation".equals(annoConfigExtensionPoints[i].getName())) {
                String aLabel = annoConfigExtensionPoints[i].getAttribute("label");
                String aIcon = annoConfigExtensionPoints[i].getAttribute("icon");
                String ovricon = annoConfigExtensionPoints[i].getAttribute("annoIcon");
                String aPackage = annoConfigExtensionPoints[i].getAttribute("package");
                ArrayList<String> aList = new ArrayList<String>();
                aList.add(aLabel);
                aList.add(aIcon);
                aList.add(ovricon);
                annoIconLabelConfigurations_.put(aPackage, aList);
            }
            ++i;
        }
        return annoIconLabelConfigurations_;
    }

    public String getIcon(String pkg) {
        ArrayList aList;
        if (!annoIconLabelConfigurations_.isEmpty() && pkg != null && (aList = annoIconLabelConfigurations_.get(pkg)) != null) {
            return (String)aList.get(this.icon_index);
        }
        return null;
    }

    public String getOverlayIcon(String pkg) {
        ArrayList aList;
        if (!annoIconLabelConfigurations_.isEmpty() && pkg != null && (aList = annoIconLabelConfigurations_.get(pkg)) != null) {
            return (String)aList.get(this.annoicon_index);
        }
        return null;
    }

    public String getLabel(String pkg) {
        ArrayList aList;
        if (!annoIconLabelConfigurations_.isEmpty() && pkg != null && (aList = annoIconLabelConfigurations_.get(pkg)) != null && !aList.isEmpty()) {
            return (String)aList.get(this.label_index);
        }
        return pkg;
    }

    public String getIconFromLabel(String label) {
        if (!annoIconLabelConfigurations_.isEmpty()) {
            annoIconLabelConfigurations_.elements();
            Enumeration<ArrayList> list = annoIconLabelConfigurations_.elements();
            if (list != null) {
                while (list.hasMoreElements()) {
                    ArrayList iconLabelPair = list.nextElement();
                    if (!iconLabelPair.get(this.label_index).equals(label)) continue;
                    return (String)iconLabelPair.get(this.icon_index);
                }
            }
        }
        return null;
    }

    public String getAnnoIconFromLabel(String label) {
        if (!annoIconLabelConfigurations_.isEmpty()) {
            annoIconLabelConfigurations_.elements();
            Enumeration<ArrayList> list = annoIconLabelConfigurations_.elements();
            if (list != null) {
                while (list.hasMoreElements()) {
                    ArrayList iconLabelPair = list.nextElement();
                    if (!iconLabelPair.get(this.label_index).equals(label)) continue;
                    return (String)iconLabelPair.get(this.annoicon_index);
                }
            }
        }
        return null;
    }

    public String getAnnoIconFromPackage(String pkg) {
        ArrayList aList;
        if (!annoIconLabelConfigurations_.isEmpty() && pkg != null && (aList = annoIconLabelConfigurations_.get(pkg)) != null && !aList.isEmpty()) {
            return (String)aList.get(this.annoicon_index);
        }
        return null;
    }

    public String getIconFromPackage(String pkg) {
        ArrayList aList;
        if (!annoIconLabelConfigurations_.isEmpty() && pkg != null && (aList = annoIconLabelConfigurations_.get(pkg)) != null && !aList.isEmpty()) {
            return (String)aList.get(this.icon_index);
        }
        return null;
    }
}

