/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ui.internal.data;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.model.IAnnotationAttributeProperty;
import com.ibm.etools.annotations.ui.internal.properties.AnnotationAttributeNodeProperty;
import com.ibm.etools.annotations.ui.internal.utils.AnnotationUIUtils;
import com.ibm.propertygroup.IPropertyChangeListener;
import com.ibm.propertygroup.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.viewers.TreeViewer;

public class AnnotationAttributeNodeSynchronizer
implements IPropertyChangeListener {
    protected Hashtable<IAnnotationAttributeProperty, AnnotationAttributeNodeProperty> annotationAttributes_ = new Hashtable();
    protected TreeViewer treeViewer_;

    public AnnotationAttributeNodeSynchronizer(TreeViewer viewer) {
        this.treeViewer_ = viewer;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Object source;
        AnnotationAttributeNodeProperty aanp;
        if (this.treeViewer_ == null || this.treeViewer_.getControl().isDisposed()) {
            return;
        }
        if (evt.getPropertyChangeType() == 0 && (aanp = this.annotationAttributes_.get(source = evt.getSource())) != null) {
            try {
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if (oldValue != null) {
                    aanp.removeAnnotationInfo((AnnotationInfo)oldValue);
                }
                if (newValue != null) {
                    aanp.addAnnotationInfo((AnnotationInfo)newValue);
                }
                this.treeViewer_.refresh((Object)aanp);
            }
            catch (Exception e) {
                AnnotationUIUtils.showExceptionMessage(e, null, null, e.getMessage());
            }
        }
    }

    public void clearSynchronizer() {
        Enumeration<IAnnotationAttributeProperty> e = this.annotationAttributes_.keys();
        while (e.hasMoreElements()) {
            IAnnotationAttributeProperty aap = e.nextElement();
            aap.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.annotationAttributes_.clear();
    }

    public void registerAttributeNode(AnnotationAttributeNodeProperty node) {
        if (node != null) {
            IAnnotationAttributeProperty aap = node.getAnnotationAttributeProperty();
            this.annotationAttributes_.put(aap, node);
            aap.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }
}

