/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.jaxws.gstc.ui.commands;

import com.ibm.ccl.ws.internal.jaxws.gstc.ui.GstcUIMessages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.conformance.JDTResolver;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class JaxwsProxyCheckingCommand
extends AbstractDataModelOperation {
    private static final String GET_DESCRIPTOR = "_getDescriptor";
    private static final String GET_DISPATCH = "getDispatch";
    private static final String GET_PROXY = "getProxy";
    private static final String DISPATCH_NAME = "javax.xml.ws.Dispatch";
    private IStructuredSelection selection;
    private boolean abort = false;
    private IStatus status = OK_STATUS;
    private JDTResolver resolver = null;
    private ICompilationUnit proxyBean = null;
    private ICompilationUnit proxyInterface = null;

    private IType getMethodReturnType(IType type, String name) {
        IMethod method;
        block3: {
            try {
                method = type.getMethod(name, new String[0]);
                if (method != null && method.exists()) break block3;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return this.resolver.getReturnType(method);
    }

    private boolean isValidDescriptor(IType descriptorType) {
        IType returnType = this.getMethodReturnType(descriptorType, GET_DISPATCH);
        if (returnType == null || !returnType.getFullyQualifiedName().equals(DISPATCH_NAME)) {
            return false;
        }
        returnType = this.getMethodReturnType(descriptorType, GET_PROXY);
        if (returnType == null) {
            return false;
        }
        this.proxyInterface = returnType.getCompilationUnit();
        return true;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        if (this.proxyBean == null && this.selection != null) {
            Object selectedObj = this.selection.getFirstElement();
            if (selectedObj instanceof IFile) {
                this.proxyBean = JavaCore.createCompilationUnitFrom((IFile)((IFile)selectedObj));
            } else if (selectedObj instanceof ICompilationUnit) {
                this.proxyBean = (ICompilationUnit)selectedObj;
            }
        }
        IType proxyType = null;
        if (this.proxyBean == null || (proxyType = this.proxyBean.findPrimaryType()) == null) {
            this.abort = true;
            this.status = StatusUtils.errorStatus((String)GstcUIMessages.NO_SELECTED_BEAN);
            return OK_STATUS;
        }
        try {
            this.resolver = new JDTResolver(this.proxyBean.getCorrespondingResource().getProject(), monitor);
            IType descriptorType = this.getMethodReturnType(proxyType, GET_DESCRIPTOR);
            if (descriptorType == null) {
                this.abort = true;
                this.status = StatusUtils.errorStatus((String)NLS.bind((String)GstcUIMessages.NO_DESCRIPTOR, (Object[])new String[]{"_getDescriptor()"}));
                return OK_STATUS;
            }
            if (!this.isValidDescriptor(descriptorType)) {
                this.abort = true;
                this.status = StatusUtils.errorStatus((String)GstcUIMessages.NOT_VALID_PROXY_BEAN);
                return OK_STATUS;
            }
        }
        catch (JavaModelException e) {
            this.abort = true;
            this.status = StatusUtils.errorStatus((Throwable)e);
        }
        return OK_STATUS;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setProxyBean(ICompilationUnit proxyBean) {
        this.proxyBean = proxyBean;
    }

    public boolean getAbort() {
        return this.abort;
    }

    public IStatus getRealStatus() {
        return this.status;
    }

    public ICompilationUnit getProxyInterface() {
        return this.proxyInterface;
    }
}

