/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.finder.ui.navigator.services;

import com.ibm.ccl.ws.finder.ui.FinderUIMessages;
import com.ibm.ccl.ws.internal.finder.ui.navigator.AbstractServiceContentProvider;
import com.ibm.ccl.ws.internal.finder.ui.navigator.ServiceRootRegistry;
import com.ibm.ccl.ws.internal.finder.ui.navigator.services.GlobalServiceRootNode;
import com.ibm.ccl.ws.internal.finder.ui.navigator.services.GlobalServiceRootObjectProvider;
import java.util.ArrayList;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class GlobalServiceContentProvider
extends AbstractServiceContentProvider
implements IActivityManagerListener {
    private FormToolkit toolkit = new FormToolkit(Display.getDefault());
    private Composite blankPanel = null;

    public GlobalServiceContentProvider() {
        super(new GlobalServiceRootObjectProvider());
        this.toolkit.setBorderStyle(0);
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        support.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
    }

    private void createBlankPanel(Viewer viewer) {
        if (this.blankPanel != null || viewer == null) {
            return;
        }
        Control tree = viewer.getControl();
        tree.setVisible(false);
        Composite parent = tree.getParent();
        parent.setBackground(Display.getDefault().getSystemColor(1));
        parent.setLayout((Layout)new FillLayout(512));
        this.blankPanel = new Composite(parent, 0);
        this.blankPanel.setBackground(Display.getDefault().getSystemColor(1));
        this.blankPanel.moveAbove(tree);
        this.blankPanel.setLayout((Layout)new GridLayout(1, true));
        Text text = this.toolkit.createText(this.blankPanel, FinderUIMessages.MSG_NO_ACTIVE_CAPABILITY, 64);
        text.setLayoutData((Object)new GridData(1, 1, true, false));
        text.setEditable(false);
        Hyperlink link = this.toolkit.createHyperlink(this.blankPanel, FinderUIMessages.MSG_NO_ACTIVE_CAPABILITY_LINK, 64);
        link.setLayoutData((Object)new GridData(1, 1, true, false));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.sdk.capabilities", null, null);
                dialog.open();
            }
        });
        parent.layout();
    }

    private void disposeBlankPanel() {
        if (this.blankPanel == null || this.viewer == null) {
            return;
        }
        this.blankPanel.dispose();
        this.blankPanel = null;
        Control tree = this.viewer.getControl();
        tree.setVisible(true);
        tree.getParent().layout();
    }

    private boolean hasUnfilteredNodes() {
        for (ServiceRootRegistry.ServiceRoot root : ServiceRootRegistry.getInstance().getServiceRoots()) {
            if (WorkbenchActivityHelper.filterItem((Object)root)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void inputChanged(Viewer viewer, Object anOldInput, Object newInput) {
        if (viewer != this.viewer && !this.hasUnfilteredNodes()) {
            this.createBlankPanel(viewer);
        }
        super.inputChanged(viewer, anOldInput, newInput);
    }

    public Object[] getElements(Object anInputElement) {
        Object[] unfiltered = ((GlobalServiceRootObjectProvider)this.rootObjectProvider).createRootNodes(ServiceRootRegistry.getInstance().getServiceRoots());
        ArrayList<GlobalServiceRootNode> filtered = new ArrayList<GlobalServiceRootNode>();
        Object[] objectArray = unfiltered;
        int n = unfiltered.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            GlobalServiceRootNode root = (GlobalServiceRootNode)object;
            if (!WorkbenchActivityHelper.filterItem((Object)root.serviceRoot)) {
                filtered.add(root);
            }
            ++n2;
        }
        return filtered.toArray();
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (!activityManagerEvent.haveEnabledActivityIdsChanged()) {
            return;
        }
        if (!this.hasUnfilteredNodes()) {
            this.createBlankPanel((Viewer)this.viewer);
        } else {
            this.disposeBlankPanel();
            this.viewer.refresh();
        }
    }

    public void dispose() {
        IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
        support.getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        this.disposeBlankPanel();
        super.dispose();
    }
}

