/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.internal.finder.ui.navigator;

import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.core.event.IWebServiceChangeListener;
import com.ibm.ccl.ws.finder.core.event.WebServiceChangeEvent;
import com.ibm.ccl.ws.internal.finder.ui.navigator.AbstractServiceRootNode;
import com.ibm.ccl.ws.internal.finder.ui.navigator.AbstractServiceTypeNode;
import com.ibm.etools.ui.navigator.framework.IRefreshHandlerListener;
import com.ibm.etools.ui.navigator.framework.IRootObjectProvider;
import com.ibm.etools.ui.navigator.framework.ModelManager;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;

public abstract class AbstractServiceRootObjectProvider
implements IRootObjectProvider,
IWebServiceChangeListener {
    private static final Object[] EMPTY = new Object[0];
    protected Map<String, AbstractServiceRootNode> rootNodes = new Hashtable<String, AbstractServiceRootNode>();
    private ListenerList listeners = new ListenerList();

    protected AbstractServiceRootObjectProvider() {
        FinderCore.getWebServiceRegistry().addWebServiceChangeListener((IWebServiceChangeListener)this);
    }

    public void setModelLoaded(Object context, boolean modelLoaded) {
        if (context instanceof AbstractServiceRootNode) {
            ((AbstractServiceRootNode)context).setLoaded(modelLoaded);
        } else {
            ((AbstractServiceTypeNode)((Object)context)).setLoaded(modelLoaded);
        }
    }

    public boolean hasLoadedModels(Object context) {
        if (context instanceof AbstractServiceRootNode) {
            return ((AbstractServiceRootNode)context).isLoaded();
        }
        return ((AbstractServiceTypeNode)((Object)context)).isLoaded();
    }

    public void setModelManager(ModelManager modelManager, Object context) {
    }

    public Object[] getModels(Object context) {
        if (context instanceof AbstractServiceRootNode) {
            AbstractServiceTypeNode[] typeNodes = ((AbstractServiceRootNode)context).getTypeNodes();
            Object[] clients = typeNodes[0].getChildren();
            Object[] services = typeNodes[1].getChildren();
            if (clients.length > 0) {
                Object[] children = new Object[services.length + 1];
                children[0] = typeNodes[0];
                if (services.length > 0) {
                    System.arraycopy(services, 0, children, 1, services.length);
                }
                return children;
            }
            return services;
        }
        if (context instanceof AbstractServiceTypeNode) {
            return ((AbstractServiceTypeNode)((Object)context)).getChildren();
        }
        return EMPTY;
    }

    public void addRefreshHandlerListener(IRefreshHandlerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeRefreshHandlerListener(IRefreshHandlerListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void notifyListeners(Object context) {
        Object[] objs;
        if (context == null) {
            return;
        }
        Object[] objectArray = objs = this.listeners.getListeners();
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ((IRefreshHandlerListener)obj).onRefresh(context);
            ++n2;
        }
    }

    protected abstract AbstractServiceRootNode getRootNode(WSInfo var1);

    protected abstract void handleWebServiceChanged(WebServiceChangeEvent var1);

    public void webServiceChanged(WebServiceChangeEvent event) {
        WSInfo info = null;
        AbstractServiceRootNode rootNode = null;
        switch (event.getType()) {
            case 0: 
            case 1: {
                int type;
                AbstractServiceTypeNode[] typeNodes;
                info = (WSInfo)event.getSource();
                rootNode = this.getRootNode(info);
                if (rootNode == null || (typeNodes = rootNode.getTypeNodes()) == null || (type = FinderCore.getWebServiceRegistry().getCategoryType(info.getCategoryId())) == -1) break;
                AbstractServiceTypeNode typeNode = typeNodes[type];
                typeNode.clearChildren();
                if (rootNode.isVisible()) {
                    if (type == 0 && event.getType() == 1) {
                        this.notifyListeners((Object)typeNode);
                        break;
                    }
                    this.notifyListeners(rootNode);
                    break;
                }
                if (event.getType() != 0) break;
                this.notifyListeners(info.getProject());
                break;
            }
            case 2: {
                info = (WSInfo)event.getSource();
                this.notifyListeners(info);
                break;
            }
            default: {
                this.handleWebServiceChanged(event);
            }
        }
    }

    public void dispose() {
        FinderCore.getWebServiceRegistry().removeWebServiceChangeListener((IWebServiceChangeListener)this);
        this.rootNodes.clear();
        this.listeners.clear();
    }
}

