/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.ws.finder.ui;

import com.ibm.ccl.ws.finder.core.FinderCore;
import com.ibm.ccl.ws.finder.core.WSInfo;
import com.ibm.ccl.ws.finder.core.event.IWebServiceChangeListener;
import com.ibm.ccl.ws.finder.core.event.WebServiceChangeEvent;
import com.ibm.ccl.ws.internal.finder.ui.navigator.ServiceRootRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.ITriggerPointManager;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IWebServiceChangeListener {
    public static final String PLUGIN_ID = "com.ibm.ccl.ws.finder.ui";
    private static Activator plugin;
    private List<String> rootIds = new ArrayList<String>();
    private ITriggerPoint triggerPoint = null;

    public Activator() {
        ITriggerPointManager manager = PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager();
        this.triggerPoint = manager.getTriggerPoint("com.ibm.ccl.ws.finder.ui.newServiceTriggerPoint");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        FinderCore.getWebServiceRegistry().addWebServiceChangeListener((IWebServiceChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        FinderCore.getWebServiceRegistry().removeWebServiceChangeListener((IWebServiceChangeListener)this);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void webServiceChanged(WebServiceChangeEvent event) {
        if (event.getType() != 0) {
            return;
        }
        WSInfo info = (WSInfo)event.getSource();
        final ServiceRootRegistry.ServiceRoot root = ServiceRootRegistry.getInstance().getServiceRoot(info.getCategoryId());
        if (root != null && !this.rootIds.contains(root.getLocalId())) {
            this.rootIds.add(root.getLocalId());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkbenchActivityHelper.allowUseOf((ITriggerPoint)Activator.this.triggerPoint, (Object)root);
                }
            });
        }
    }
}

