/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;

public class PerspectiveSwitchUtility {
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.NewProject_errorOpeningWindow;

    public static void updatePerspective(String finalPerspId) {
        int workbenchPerspectiveSetting;
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)("Unable to find persective " + finalPerspId + " in BasicNewProjectResourceWizard.updatePerspective"));
            return;
        }
        ArrayList<String> preferredPerspIds = new ArrayList<String>();
        preferredPerspIds.add(finalPerspId);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!PerspectiveSwitchUtility.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            PerspectiveSwitchUtility.openInNewWindow(finalPersp);
            return;
        }
        PerspectiveSwitchUtility.replaceCurrentPerspective(finalPersp);
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }
}

