/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gallery.common.wizards;

import com.ibm.ccl.ua.wizards.Activator;
import com.ibm.gallery.common.wizards.ExampleProjectCreationWizard;
import com.ibm.gallery.common.wizards.ExampleProjectCreationWizardPage;
import com.ibm.gallery.common.wizards.GalleryConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;

public class GalleryWizardActionHelper
implements GalleryConstants {
    public static final String ELEM_WIZARD = "wizard";
    public static final String GALLERY_ID = "com.ibm.ccl.ua.wizards";
    public static final String GALLERY_IMPORT_WIZARD = "importWizard";

    public static IWizard getSampleGalleryImportWizard(String extensionId) {
        return GalleryWizardActionHelper.getWizardWithExtensionId(extensionId, GALLERY_ID, GALLERY_IMPORT_WIZARD);
    }

    public static IWizard getWizardWithExtensionId(String extensionId) {
        return GalleryWizardActionHelper.getWizardWithExtensionId(extensionId, GALLERY_ID, GALLERY_IMPORT_WIZARD);
    }

    public static IWizard getWizardWithExtensionId(String extensionId, String namespace, String extensionPointName) {
        Wizard wizard = null;
        IExtensionPoint xpt = GalleryWizardActionHelper.getExtensionPoint(namespace, extensionPointName);
        if (xpt == null) {
            String message = MessageFormat.format("_ERROR_GALLERY_WIZHELP_EXTENSIONPOINT_NOT_FOUND", extensionPointName, namespace);
            Activator.logWarning(message);
            return null;
        }
        IExtension extension = xpt.getExtension(extensionId);
        if (extension != null) {
            IConfigurationElement configElement = null;
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            int i = 0;
            while (i < configElements.length) {
                if (configElements[i].getName().equals(ELEM_WIZARD)) {
                    configElement = configElements[i];
                    break;
                }
                ++i;
            }
            if (configElement == null) {
                String message = MessageFormat.format("_ERROR_GALLERY_WIZHELP_CONFIG_ELEM_NOT_FOUND", ELEM_WIZARD, extensionId, extensionPointName, namespace);
                Activator.logWarning(message);
                return null;
            }
            try {
                wizard = (Wizard)configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                String message = MessageFormat.format("_ERROR_GALLERY_WIZHELP_CREATE_EXECUTABLE_EXTENSION", extensionId, ELEM_WIZARD, extensionPointName, namespace);
                Activator.logError(message, e);
                return null;
            }
        }
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        String isRemoteAssistanceEnabled = prefs.getString("remoteHelpOn");
        if (isRemoteAssistanceEnabled.equals("true")) {
            PreferenceFileHandler prefHandler = new PreferenceFileHandler();
            String[] host = prefHandler.getHostEntries();
            String[] port = prefHandler.getPortEntries();
            String[] path = prefHandler.getPathEntries();
            String[] isEnabled = prefHandler.isEnabled();
            int numICs = host.length;
            if (numICs == 0) {
                return null;
            }
            InputStream in = null;
            URL url = null;
            String wizardPathString = "";
            int i = 0;
            while (i < numICs) {
                block28: {
                    if (isEnabled[i].equalsIgnoreCase("true")) {
                        try {
                            try {
                                wizardPathString = path[i].endsWith("/") ? String.valueOf(path[i]) + "wizardBuilder" + '?' + "wizardID" + '=' + extensionId + "&namespace=" + namespace + "&extensionPointName=" + extensionPointName : String.valueOf(path[i]) + "/wizardBuilder" + '?' + "wizardID" + '=' + extensionId + "&namespace=" + namespace + "&extensionPointName=" + extensionPointName;
                                String urlString = "http://" + host[i] + ":" + new Integer(port[i]) + wizardPathString;
                                url = new URL(urlString);
                                in = url.openStream();
                                if (in != null) {
                                    int count = 0;
                                    int initialBytes = in.available();
                                    byte[] buf = new byte[initialBytes];
                                    while (count != initialBytes) {
                                        in.read(buf);
                                        ++count;
                                    }
                                    String wizardInfoString = new String(buf);
                                    String[] wizardInfoArray = wizardInfoString.split(",");
                                    String wizardURL = "http://" + host[i] + ":" + new Integer(port[i]) + path[i];
                                    ExampleProjectCreationWizard importWizard = new ExampleProjectCreationWizard();
                                    importWizard.addNewPage(new ExampleProjectCreationWizardPage(0, wizardInfoArray[0], wizardInfoArray[6], wizardInfoArray[1], wizardInfoArray[2], wizardInfoArray[6], wizardInfoArray[5], wizardInfoArray[7], wizardInfoArray[8], wizardInfoArray[9], wizardInfoArray[10], wizardURL));
                                    wizard = importWizard;
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                if (in != null) {
                                    try {
                                        in.close();
                                        in = null;
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                    in = null;
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                                in = null;
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                ++i;
            }
        } else {
            String message = MessageFormat.format("_ERROR_GALLERY_WIZHELP_EXTENSIONID_NOT_FOUND", extensionId, extensionPointName, namespace);
            Activator.logWarning(message);
        }
        return wizard;
    }

    public static IWizard findWizard(String attributeName, String className, String namespace, String extensionPointName) {
        IWizard wizard = null;
        IExtensionPoint xpt = GalleryWizardActionHelper.getExtensionPoint(namespace, extensionPointName);
        IConfigurationElement configElement = null;
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int k = 0;
            while (k < configElements.length) {
                String id;
                if (configElements[k].getName().equals(ELEM_WIZARD) && (id = configElements[k].getAttribute(attributeName)) != null && id.equals(className)) {
                    configElement = configElements[k];
                    break;
                }
                ++k;
            }
            if (configElement != null) break;
            ++i;
        }
        try {
            wizard = (IWizard)configElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Activator.logError("GalleryWizardActionHelper findWizard() ", e);
            e.printStackTrace();
        }
        return wizard;
    }

    private static IExtensionPoint getExtensionPoint(String namespace, String extensionPointName) {
        return Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPointName);
    }
}

